﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Basic.Master" AutoEventWireup="true"
    CodeBehind="ProductsInStock.aspx.cs" Inherits="Maticsoft.Web.Admin.Shop.Products.ProductsInStock" %>

<%@ Register Assembly="Maticsoft.Web" Namespace="Maticsoft.Web.Controls" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <script src="/admin/js/jquery/maticsoft.img.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        function changProductName(id) {
            $("#img_" + id).hide();
            $("#txtProductName_" + id).show().focus();
            $("#editsave_" + id).show();
            $("#p_" + id).hide();
        }

        function saveChange(id) {
            var productName = $("#txtProductName_" + id).val();
            if (!productName) {
                alert('请输入商品名称！');
                return;
            }
            $.ajax({
                url: ("ProductsInStock.aspx?timestamp={0}").format(new Date().getTime()),
                type: 'POST', dataType: 'json', timeout: 10000,
                data: { Action: "UpdateVistiCountsById", Callback: "true", ProductId: id, UpdateValue: productName },
                async: false,
                success: function (resultData) {
                    if (resultData.STATUS == "SUCCESS") {
                        $("#p_" + id).text(productName);
                        $("#img_" + id).show();
                        $("#editsave_" + id).hide();
                        $("#txtProductName_" + id).hide();
                        $("#p_" + id).show();
                    }
                    else {
                        alert("系统忙请稍后再试！");
                    }
                }
            });
        }

        $(document).ready(function () {
            resizeImg('.borderImage', 80, 80);
            
            $(".item-title-area").hover(function () {
                $(this).addClass('high-light');
            }, function () {
                $(this).removeClass("high-light");
            });
            $(".txtpname").blur(function () {
                textBulr(this);
            });
            $(".editsave").mouseenter(function () {
                var id = $(this).attr('i');
                $("#txtProductName_" + id).unbind('blur');
            }).mouseleave(function () {
                var id = $(this).attr('i');
                $("#txtProductName_" + id).bind('blur', function () {
                    $("#txtProductName_" + id).hide();
                    $("#img_" + id).show();
                    $("#editsave_" + id).hide();
                    $("#p_" + id).show();
                });
            });
        });

        function textBulr(thisenent) {
            $(thisenent).hide();
            var id = $(thisenent).attr('i');
            $("#img_" + id).show();
            $("#editsave_" + id).hide();
            $("#p_" + id).show();
        }
    </script>
    <style type="text/css">
        .autobrake
        {
            word-wrap: break-word;
            width: 280px;
        }
        .item-title-area
        {
            width: 300px;
        }
        .high-light
        {
            cursor: pointer;
        }
        .txtpname
        {
            width: 260px;
            display: none;
        }
        .editsave
        {
            margin-left: 239px;
            display: none;
            border: none;
            width: 41px;
            height: 20px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <!--Title -->
    <div class="newslistabout">
        <div class="newslist_title">
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="borderkuang">
                <tr>
                    <td bgcolor="#FFFFFF" class="newstitle">
                        <%=strTitle %>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#FFFFFF" class="newstitlebody">
                        您可以新增、修改、删除&nbsp;<%=strTitle %>
                    </td>
                </tr>
            </table>
        </div>
        <!--Title end -->
        <!--Add  -->
        <!--Add end -->
        <!--Search -->
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="borderkuang">
            <tr>
                <td width="1%" height="30" bgcolor="#FFFFFF" class="newstitlebody">
                    <img src="../../Images/icon-1.gif" width="19" height="19" />
                </td>
                <td height="35" bgcolor="#FFFFFF" class="newstitlebody">
                    <asp:Literal ID="Literal1" runat="server" Text="商品分类" />：
                    <asp:dropdownlist ID="drpProductCategory" runat="server">
                    </asp:dropdownlist>
                    <asp:Literal ID="Literal2" runat="server" Text="商品名称" />：
                    <asp:TextBox ID="txtKeyword" runat="server"></asp:TextBox>
                    <asp:Literal ID="Literal3" runat="server" Text="产品编号" />：
                    <asp:TextBox ID="txtProductNum" runat="server"></asp:TextBox>
                    <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:Site, btnSearchText %>"
                        OnClick="btnSearch_Click" class="adminsubmit"></asp:Button>
                </td>
            </tr>
        </table>
        <br />
        <div class="newslist">
            <div class="newsicon">
                <ul>
                    <li style="background: url(/admin/images/reload.png)  no-repeat; width: auto;">
                        <asp:LinkButton ID="LinkButton2" runat="server" OnClick="btnFresh_Click" Text="刷新" /><b>|</b></li></ul>
            </div>
        </div>
        <!--Search end-->
        <cc1:GridViewEx ID="gridView" runat="server" AllowPaging="True" AllowSorting="True"
            AutoGenerateColumns="False" OnBind="BindData" OnPageIndexChanging="gridView_PageIndexChanging"
            OnRowDataBound="gridView_RowDataBound" unexportedcolumnnames="Modify" Width="100%"
            PageSize="10" ShowExportExcel="False" ShowExportWord="False" ExcelFileName="FileName1"
            CellPadding="1" BorderWidth="1px" ShowCheckAll="true" DataKeyNames="ProductId"
            ShowToolBar="false">
            <Columns>
                <asp:TemplateField HeaderText=""  ItemStyle-HorizontalAlign="Center" >
                    <ItemTemplate>
                            <div class="borderImage"><img ref='<%# Eval("ThumbnailUrl1") %>' /></div>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField SortExpression="ProductName" ItemStyle-HorizontalAlign="Left"
                    HeaderText="商品名称" ControlStyle-Width="300">
                    <ItemTemplate>
                        <div title="编辑宝贝标题" class="item-title-area">
                            <p id="p_<%# Eval("ProductId")%>" class="autobrake">
                                <%# Eval("ProductName")%></p>
                            <textarea id="txtProductName_<%# Eval("ProductId")%>" rows="2" class="txtpname" i="<%# Eval("ProductId")%>"><%# Eval("ProductName")%></textarea>
                            &nbsp;<img alt="编辑宝贝标题" id="img_<%# Eval("ProductId")%>" title="编辑宝贝标题" src="/admin/Images/up_xiaobi.png"
                                onclick='changProductName(<%# Eval("ProductId")%>);' />
                            <br />
                        </div>
                        <a id="editsave_<%# Eval("ProductId")%>" href="javascript:void(0)" onclick="saveChange(<%# Eval("ProductId")%>);"
                            class="editsave" i="<%# Eval("ProductId")%>">保存</a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品价格" ItemStyle-HorizontalAlign="Left">
                    <ItemTemplate>
                        市场价：<span ><%#Eval("MarketPrice", "￥{0:N2}")%></span><br />
                        销售价：<span style="color: #f60;font-family:tahoma;font-weight:700"><%#Eval("LowestSalePrice", "￥{0:N2}")%></span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField  ItemStyle-HorizontalAlign="Left"
                    HeaderText="所在分类">
                    <ItemTemplate>
                        <asp:Literal runat="server" ID="litProductCate"></asp:Literal>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField SortExpression="VistiCounts" ItemStyle-HorizontalAlign="Left"
                    HeaderText="浏览次数">
                    <ItemTemplate>
                        <%#Eval("VistiCounts") %>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField SortExpression="VistiCounts" ItemStyle-HorizontalAlign="Left"
                    HeaderText="库存数量">
                    <ItemTemplate>
                        <%#StockNum(Eval("ProductId"))%>
                        <%--<input id="ipTextVistiCount<%# Eval("ProductId")%>" type="text" value=" <%# Eval("VistiCounts")%>"
                            style="width: 45px; display: none;" />
                        &nbsp;<img alt="" id="imgVistiCount<%# Eval("ProductId")%>" src="/admin/Images/up_xiaobi.png"
                            onclick="return UpdateState(<%# Eval("ProductId")%>,'VistiCounts','imgVistiCount','aVistiCount','spVistiCount','ipTextVistiCount')" />
                        <a id="aVistiCount<%# Eval("ProductId")%>" href="javascript:void(0)" style="display: none;"
                            onclick="return UpdateVistiCountsById(<%# Eval("ProductId")%>)">保存</a>--%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField SortExpression="AddedDate" ItemStyle-HorizontalAlign="Center"
                    HeaderText="发布时间">
                    <ItemTemplate>
                        <%#Convert.ToDateTime(Eval("AddedDate")).ToString("yyyy-MM-dd HH:mm:ss")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑" ItemStyle-HorizontalAlign="Center" >
                    <ItemTemplate>
                        <a href="ProductModify.aspx?pid=<%#Eval("ProductId") %>">编辑</a>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </cc1:GridViewEx>
        <table border="0" cellpadding="0" cellspacing="1" style="width: 100%;">
            <tr>
                <td style="width: 1px;">
                </td>
                <td align="left">
                    <asp:Button ID="btnDelete" OnClientClick="return confirm('你确定要放入回收站吗？要还原商品请到回收站找回！')" runat="server" Text="批量删除" class="adminsubmit" OnClick="btnDelete_Click" />
                    <asp:Button ID="btnInverseApprove" runat="server" Text="批量下架" class="adminsubmit"
                        OnClick="btnInverseApprove_Click" />
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceCheckright" runat="server">
</asp:Content>