/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef TreeHIncl
#define TreeHIncl

// GP: clean

#include "base.h"
#include "verts.h"
#include "datastr.h"
#include "output.h"

//
//  Document
//  holds information about a source document that yielded
//  some of the nodes in a tree
//

/*      T B D
class Document
{
public:
    Document(Processor *proc_);
};
*/

class RootNode;

#define TREE_ARENA_SIZE         0x10000
#define TREE_DICT_LOGSIZE    10


/****************************************
T r e e
****************************************/

class Tree
{
public:
    Tree(const Str&, Bool);
    ~Tree();
    BOOL XSLTree;
    eFlag appendVertex(Sit S, Vertex *);
    Vertex *popVertex();
    Vertex *appendText(Sit S, char *, int);
    eFlag parseFinished(Sit S);
    void dump();
    void setName(const Str&);
    Vertex *stackTop;
    Str name;
    NSList pendingNS;
    int stripped;
    void dropCurrentElement(Vertex *);
    OutputDefinition outputDef;
    void flushPendingText();
    Element& dummyElement() const;
    HashTable& dict();
    Arena& getArena();
    const QName& getTheEmptyQName() const;
    Phrase stdPhrase(StandardPhrase phrase_) const
    { 
        assert(phrase_ <= PHRASE_LAST); 
	    return stdPhrases[phrase_]; 
	};
	Bool cmpQNames(const QName &q1, const QName &q2) const;
	Bool cmpQNamesForeign(const QName &q, const HashTable& dictForeign, const QName &qForeign);
	Bool cmpQNameStrings(const QName &q, const Str& uri, const Str& local);
	void expandQ(const QName& q, EQName &expanded);
	void expandQStr(const QName& q, Str &expName);
	const Str& expand(Phrase ph);
	Phrase unexpand(const Str& strg);
	RootNode& getRoot() const {return *NZ(root);} 
	eFlag serialize(Sit S, char *& result);
	eFlag serializeNode(Sit S, Element *v, char *& result);
	void makeStamps();
	RuleSList &rules();
	P2List &aliases();
    eFlag processVertexAfterParse(Sit S, Vertex *v, TreeConstructer* tc);
    eFlag parse(Sit S, DataLine *d);    
    eFlag getMatchingList(Sit S, Expression& match, Context& result);
private:
    Arena theArena;
    Text *pendingTextNode;
    DStr pendingText;
    int vcount;             // # of vertices in tree
    Element *theDummyElement;
    HashTable theDictionary;
    const QName theEmptyQName;
    Phrase stdPhrases[PHRASE_LAST];
    void initDict();
    RootNode *root;
    RuleSList rulesList;
    P2List aliasesList;
    Element* findStylesheet(Daddy& d);
    eFlag insertRule(Sit S, XSLElement *tmpl);
    double defaultPriorityLP(Expression *);
    double defaultPriority(XSLElement *);      
    void report(Sit S, MsgType type, MsgCode code, 
        const Str &arg1, const Str &arg2) const;
};

#endif //ifndef TreeHIncl
