/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.LocalVariableInstruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IIncInstruction
extends LocalVariableInstruction {
    private int _inc = 0;

    public IIncInstruction setIncrement(int n) {
        this._inc = n;
        return this;
    }

    public int getIncrement() {
        return this._inc;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IIncInstruction)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        IIncInstruction iIncInstruction = (IIncInstruction)object;
        return this._inc == 0 || iIncInstruction._inc == 0 || this._inc == iIncInstruction._inc;
    }

    public int getLength() {
        return super.getLength() + 2;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        this.setIncrement(((IIncInstruction)instruction).getIncrement());
    }

    protected void readData(DataInput dataInput) throws IOException {
        this.setIndex(dataInput.readUnsignedByte());
        this.setIncrement(dataInput.readByte());
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.getIndex());
        dataOutput.writeByte(this.getIncrement());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterIIncInstruction(this);
        bCVisitor.exitIIncInstruction(this);
    }

    protected IIncInstruction(Code code) {
        super(code);
        this._opcode = 132;
    }
}

