/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.app.CacheLog;
import com.macromedia.generator.app.GenCache;
import com.macromedia.generator.app.GenCacheEntry;
import com.macromedia.generator.platform.Mac;
import com.macromedia.generator.protocol.fgftp.FgftpURLConnection;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public abstract class URLCache
extends GenCache {
    protected final int kMinBufferSize = 5000;
    protected boolean mForce = false;
    protected boolean mCheckModifiedSince = false;
    protected int mDiskBufferSize = 0;
    protected int mNetBufferSize = 0;

    public URLCache(long l, boolean bl, boolean bl2, long l2, boolean bl3, int n, int n2, CacheLog cacheLog) {
        super(l, bl2, l2, cacheLog);
        this.setBufferSize(n, n2);
        this.setForce(bl);
        this.setCheckModifiedSince(bl3);
    }

    public boolean getForce() {
        return this.mForce;
    }

    public void setForce(boolean bl) {
        this.mForce = bl;
        this.logCacheMessage(this.getResString("SetForce") + new Boolean(bl).toString(), 2);
    }

    public void setCheckModifiedSince(boolean bl) {
        this.mCheckModifiedSince = bl;
        this.logCacheMessage(this.getResString("SetCheckModifiedSince") + new Boolean(bl).toString(), 2);
    }

    public boolean getCheckModifiedSince() {
        return this.mCheckModifiedSince;
    }

    public void setBufferSize(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        this.mDiskBufferSize = n * 1000;
        this.logCacheMessage(this.getResString("SetDiskBufferSize") + Integer.toString(n) + "K", 2);
        if (n2 < 0) {
            n2 = 0;
        }
        this.mNetBufferSize = n2 * 1000;
        this.logCacheMessage(this.getResString("SetNetBufferSize") + Integer.toString(n2) + "K", 2);
    }

    public int getDiskBufferSize() {
        return this.mDiskBufferSize;
    }

    public int getNetBufferSize() {
        return this.mNetBufferSize;
    }

    public Object getURLData(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        Object object = null;
        if (this.isCacheEnabled()) {
            if (this.mCheckModifiedSince && this.checkModifiedSince(uRL)) {
                this.removeCacheURL(uRL);
                return null;
            }
            object = this.getCacheURL(uRL);
        }
        return object;
    }

    public Object fetchURLData(URL uRL, boolean bl, long l) throws IOException {
        if (uRL == null) {
            return null;
        }
        byte[] byArray = null;
        if (this.isLocal(uRL)) {
            byArray = this.readURLLocalFile(uRL, bl, l);
        }
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        try {
            int n;
            uRLConnection = uRL.openConnection();
            if (uRLConnection == null) {
                return null;
            }
            if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)uRLConnection).getResponseCode()) != 200) {
                throw new IOException(((HttpURLConnection)uRLConnection).getResponseMessage());
            }
            long l2 = uRLConnection.getContentLength();
            if (l2 == 0L || l2 == -1L) {
                throw new IOException(this.getResString("InvalidURL"));
            }
            inputStream = uRLConnection.getInputStream();
            if (inputStream != null) {
                long l3 = this.mNetBufferSize;
                if (l3 == 0L) {
                    l3 = l2;
                }
                if ((byArray = this.readURLInputStream(uRL, inputStream, l2, (int)l3, bl, l)) != null || !(uRLConnection instanceof FgftpURLConnection)) {
                    inputStream.close();
                }
                if (byArray != null) {
                    this.logCacheMessage(this.getResString("FetchedURL") + uRL.toString(), 2);
                }
            }
            if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
            throw iOException;
        }
        return byArray;
    }

    protected boolean checkModifiedSince(URL uRL) throws IOException {
        boolean bl = false;
        long l = 0L;
        long l2 = this.getCacheURLTime(uRL);
        if (l2 == 0L) {
            return false;
        }
        if (this.isLocal(uRL)) {
            String string = this.getURLLocalPath(uRL);
            if (string == null) {
                return false;
            }
            File file = new File(string);
            if (file == null) {
                return false;
            }
            l = file.lastModified();
        } else {
            URLConnection uRLConnection = null;
            try {
                uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    l = httpURLConnection.getLastModified();
                }
                if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).disconnect();
                }
            }
            catch (IOException iOException) {
                if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).disconnect();
                }
                throw iOException;
            }
        }
        if (l > l2) {
            this.logCacheMessage(this.getResString("URLModified") + uRL.toString(), 5);
            bl = true;
        }
        return bl;
    }

    protected abstract byte[] readURLInputStream(URL var1, InputStream var2, long var3, int var5, boolean var6, long var7) throws IOException;

    protected byte[] readURLLocalFile(URL uRL, boolean bl, long l) throws IOException {
        byte[] byArray = null;
        String string = this.getURLLocalPath(uRL);
        if (string != null) {
            byArray = this.readFile(string);
            if (byArray != null && this.isCacheEnabled() && (this.getForce() || bl)) {
                this.setCacheURL(uRL, byArray, byArray.length, l);
            }
        }
        return byArray;
    }

    protected byte[] readInputStream(InputStream inputStream, long l, int n) throws IOException {
        byte[] byArray = null;
        try {
            int n2 = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            long l2 = 0L;
            if (n <= 0) {
                n = 5000;
            }
            byte[] byArray2 = new byte[n];
            while (n2 != -1) {
                l2 += (long)n2;
                n2 = inputStream.read(byArray2);
                if (n2 == -1) continue;
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            long l3 = byArray.length;
            if (l3 < l) {
                byArray = null;
                throw new IOException(this.getResString("IncompleteRead"));
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            throw iOException;
        }
        return byArray;
    }

    protected byte[] readFile(String string) throws IOException {
        byte[] byArray = null;
        File file = new File(this.makeJavaPretty(string));
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        if (l == 0L) {
            throw new IOException(this.getResString("EmptyFile") + string);
        }
        if (fileInputStream != null) {
            long l2 = this.mDiskBufferSize;
            if (l2 == 0L) {
                l2 = l;
            }
            byArray = this.readInputStream(fileInputStream, l, (int)l2);
            fileInputStream.close();
        }
        if (byArray == null) {
            throw new IOException(this.getResString("ErrorReadingInputStream"));
        }
        if ((long)byArray.length != l) {
            throw new IOException(this.getResString("IncompleteRead") + string);
        }
        this.logCacheMessage(this.getResString("ReadLocalFile") + string, 2);
        return byArray;
    }

    protected boolean isLocal(URL uRL) {
        String string = uRL.getProtocol();
        return string.equals("file");
    }

    protected String getURLLocalPath(URL uRL) {
        String string = null;
        string = uRL.toString();
        string = this.stripLocalPrefix(string);
        return string;
    }

    protected String stripLocalPrefix(String string) {
        return string.substring(5);
    }

    protected boolean setCacheURL(URL uRL, Object object, long l, long l2) {
        if (!this.isCacheEnabled()) {
            return false;
        }
        String string = uRL.toString();
        return this.setCacheValue(string, object, l, l2);
    }

    protected Object getCacheURL(URL uRL) {
        if (!this.isCacheEnabled()) {
            return null;
        }
        String string = uRL.toString();
        return this.getCacheValue(string);
    }

    protected long getCacheURLTime(URL uRL) {
        if (!this.isCacheEnabled()) {
            return 0L;
        }
        GenCacheEntry genCacheEntry = this.getCacheURLEntry(uRL);
        if (genCacheEntry != null) {
            return genCacheEntry.time;
        }
        return 0L;
    }

    protected synchronized GenCacheEntry getCacheURLEntry(URL uRL) {
        if (this.mIndex == null) {
            return null;
        }
        if (!this.isCacheEnabled()) {
            return null;
        }
        String string = uRL.toString();
        return (GenCacheEntry)this.mIndex.get(string);
    }

    protected void removeCacheURL(URL uRL) {
        if (!this.isCacheEnabled()) {
            return;
        }
        String string = uRL.toString();
        this.removeCacheValue(string);
    }

    protected String makeJavaPretty(String string) {
        Mac mac = Mac.getMac();
        if (mac != null) {
            return mac.makeJavaPretty(string);
        }
        return string;
    }

    protected String makeSystemPretty(String string) {
        Mac mac = Mac.getMac();
        if (mac != null) {
            return mac.makeSystemPretty(string);
        }
        return string;
    }
}

