/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.app.GenLogAlphaComparator;
import com.macromedia.generator.app.GenLogAlphaComparator2;
import com.macromedia.generator.app.GenLogFile;
import com.macromedia.generator.app.LogFileFilter;
import com.macromedia.generator.utils.GenUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Date;

public class GenLog {
    private final String kLineBreak = "\r\n";
    private int mLevel = 0;
    private File mFile = null;
    private long mCycle = 0L;
    private long mLastCycle = 0L;
    private int mMaxLogs = 10;
    private boolean mForce = false;

    public GenLog(int n) {
        this.setLevel(n);
        this.mLastCycle = System.currentTimeMillis();
    }

    public void setLogFile(File file) {
        if (file != null) {
            this.mFile = file;
        }
    }

    public void setLogFilePath(String string) {
        if (string != null) {
            this.mFile = new File(string);
        }
    }

    public void setLevel(int n) {
        this.mLevel = n;
    }

    public void setCycle(long l, int n) {
        if (l < 0L) {
            l = 0L;
        }
        this.mCycle = l * 60L * 1000L;
        if (n < 0) {
            n = 0;
        }
        this.mMaxLogs = n;
    }

    public long getCycle() {
        return this.mCycle / 60000L;
    }

    public int getMaxLogFiles() {
        return this.mMaxLogs;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public void setForce(boolean bl) {
        this.mForce = bl;
    }

    public void logMessage(String string) {
        this.logMessages(string, null, true);
    }

    public void logMessage(String string, boolean bl) {
        this.logMessages(string, null, bl);
    }

    public void logMessages(String string, String string2) {
        this.logMessages(string, string2, true);
    }

    public void logMessages(String string, String string2, boolean bl) {
        if (string == null) {
            return;
        }
        String[] stringArray = new String[2];
        if (stringArray == null) {
            return;
        }
        stringArray[0] = "";
        if (bl) {
            stringArray[0] = this.date();
        }
        stringArray[0] = stringArray[0] + string + System.getProperty("line.separator", "\r\n");
        stringArray[1] = string2;
        this.logMessages(stringArray);
    }

    public void logMessages(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (!this.prepare()) {
            return;
        }
        try {
            this.write(stringArray);
        }
        catch (Exception exception) {
            System.out.println("Log file error: " + exception);
            System.out.println(stringArray[0]);
        }
    }

    private synchronized boolean timeToCycle() {
        if (this.mCycle <= 0L) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (l > this.mLastCycle + this.mCycle) {
            this.mLastCycle = l;
            return true;
        }
        return false;
    }

    private synchronized boolean cycle() {
        return this.reindexLogFiles();
    }

    private boolean prepare() {
        if (this.mLevel <= 0 && !this.mForce) {
            return false;
        }
        if (this.mFile == null) {
            return false;
        }
        if (this.timeToCycle()) {
            this.cycle();
        }
        return true;
    }

    private String date() {
        Date date = new Date();
        return date.toString() + ": ";
    }

    private synchronized void write(String[] stringArray) throws Exception {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.mFile, "rw");
            if (randomAccessFile != null) {
                randomAccessFile.seek(randomAccessFile.length());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (stringArray[n2] != null) {
                        randomAccessFile.write(stringArray[n2].getBytes());
                    }
                    ++n2;
                }
                randomAccessFile.close();
            }
        }
        catch (Exception exception) {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            throw exception;
        }
    }

    private boolean reindexLogFiles() {
        String[] stringArray;
        GenLogFile genLogFile = new GenLogFile(this.mFile);
        if (genLogFile == null || !genLogFile.verify()) {
            return false;
        }
        File file = genLogFile.getParentFile();
        if (file == null) {
            return false;
        }
        LogFileFilter logFileFilter = new LogFileFilter(genLogFile);
        if (logFileFilter == null) {
            return false;
        }
        Object[] objectArray = null;
        if (GenUtils.isJava2()) {
            objectArray = file.listFiles(logFileFilter);
            if (objectArray == null) {
                return false;
            }
            stringArray = new GenLogAlphaComparator2();
            Arrays.sort(objectArray, stringArray);
        } else {
            stringArray = file.list(logFileFilter);
            if (stringArray == null || stringArray.length == 0) {
                return false;
            }
            objectArray = GenUtils.makeFileArray(file, stringArray);
            if (objectArray == null || objectArray.length == 0) {
                return false;
            }
            GenLogAlphaComparator genLogAlphaComparator = new GenLogAlphaComparator();
            genLogAlphaComparator.Sort(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!this.incrementLogFile(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean incrementLogFile(File file) {
        GenLogFile genLogFile = new GenLogFile(file);
        if (genLogFile == null || !genLogFile.verify()) {
            return false;
        }
        if (this.mMaxLogs > 0 && genLogFile.getIndex() >= this.mMaxLogs) {
            try {
                if (file.exists() && file.isFile()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                return true;
            }
            return true;
        }
        File file2 = genLogFile.increment();
        if (file2 == null) {
            return false;
        }
        return file.renameTo(file2);
    }
}

