/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.app.CacheLog;
import com.macromedia.generator.app.FlashEnvironment;
import com.macromedia.generator.app.GenCacheEntry;
import com.macromedia.generator.app.GenCacheExpireComparator;
import com.macromedia.generator.app.GenCacheExpireComparator2;
import com.macromedia.generator.platform.Mac;
import com.macromedia.generator.utils.Comparer;
import com.macromedia.generator.utils.GenUtils;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class GenCache {
    protected Hashtable mIndex = null;
    protected long mCurrentSize = 0L;
    protected CacheLog mLog = null;
    protected final String kLineBreak = "\r\n";
    private boolean mLock = false;
    protected long mMaxSize = 0L;
    protected boolean mRecycle = true;
    protected long mDefaultExpire = 0L;
    protected boolean mDynamicMaintanence = true;
    private final int kForceLog = -1;

    public GenCache(long l, boolean bl, long l2, CacheLog cacheLog) {
        this.mLog = cacheLog;
        this.logCacheMessage(this.getResString("CreatingCache"), 1);
        this.setMaxSize(l);
        this.setRecycle(bl);
        this.setDefaultExpire(l2);
        this.mIndex = new Hashtable();
    }

    protected void finalize() throws Throwable {
        this.logCacheMessage(this.getResString("DeletingCache"), 1);
        this.dispose();
        this.mIndex = null;
    }

    protected void dispose() {
        this.purge();
    }

    public long getMaxSize() {
        return this.mMaxSize / 1000L;
    }

    public void setMaxSize(long l) {
        if (l < 0L) {
            l = 0L;
        }
        if (this.mDynamicMaintanence && (l *= 1000L) < this.mMaxSize) {
            this.freeCacheSpace(this.mMaxSize - l);
        }
        this.mMaxSize = l;
        this.logCacheMessage(this.getResString("SetMaxSize") + Long.toString(l / 1000L) + "K", 2);
    }

    public boolean getRecycle() {
        return this.mRecycle;
    }

    public void setRecycle(boolean bl) {
        this.mRecycle = bl;
        this.logCacheMessage(this.getResString("SetRecycle") + new Boolean(this.mRecycle).toString(), 2);
    }

    public long getDefaultExpire() {
        return this.mDefaultExpire / 1000L;
    }

    public void setDefaultExpire(long l) {
        if (l < 0L) {
            l = 0L;
        }
        this.mDefaultExpire = l * 1000L;
        this.logCacheMessage(this.getResString("SetDefaultExpire") + Long.toString(l) + this.getResString("Seconds"), 2);
    }

    public synchronized boolean getLock() {
        return this.mLock;
    }

    public synchronized void setLock(boolean bl) {
        this.mLock = bl;
        this.logCacheMessage(this.getResString("SetLock") + new Boolean(bl).toString(), 2);
    }

    public boolean isCacheEnabled() {
        Mac mac = Mac.getMac();
        if (mac != null) {
            return false;
        }
        if (FlashEnvironment.isLimited()) {
            return false;
        }
        return this.mMaxSize != 0L;
    }

    /*
     * Unable to fully structure code
     */
    public void purge() {
        if (this.mIndex == null) {
            return;
        }
        var1_1 = this.mIndex.elements();
        if (var1_1 != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (GenCacheEntry)var1_1.nextElement();
            this.removeCacheEntry(var2_2);
lbl8:
            // 2 sources

            ** while (var1_1.hasMoreElements())
        }
lbl9:
        // 1 sources

        this.logCacheMessage(this.getResString("Purged"), 2);
    }

    public void logHitCounts() {
        if (this.mIndex == null) {
            return;
        }
        Enumeration enumeration = this.mIndex.elements();
        if (enumeration == null) {
            return;
        }
        this.logCacheMessage(this.getResString("LogHitCounts"), -1);
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            GenCacheEntry genCacheEntry = (GenCacheEntry)enumeration.nextElement();
            this.logCacheMessage((String)genCacheEntry.key, -1);
            this.logCacheMessage(this.getResString("HitCount") + genCacheEntry.hits, -1);
            bl = true;
        }
        if (!bl) {
            this.logCacheMessage(this.getResString("None"), -1);
        }
    }

    protected synchronized boolean setCacheValue(Object object, Object object2, long l, long l2) {
        GenCacheEntry genCacheEntry = new GenCacheEntry();
        genCacheEntry.key = object;
        genCacheEntry.value = object2;
        genCacheEntry.size = l;
        genCacheEntry.time = System.currentTimeMillis();
        genCacheEntry.expires = l2 * 1000L;
        genCacheEntry.hits = 0L;
        return this.setCacheEntry(genCacheEntry);
    }

    protected synchronized boolean setCacheEntry(GenCacheEntry genCacheEntry) {
        if (this.mIndex == null) {
            return false;
        }
        if (this.mLock) {
            this.logCacheMessage(this.getResString("CacheLockedSet") + genCacheEntry.key, 3);
            return false;
        }
        if (this.existsCacheEntry(genCacheEntry)) {
            return false;
        }
        if (this.setCacheEntryValidate(genCacheEntry)) {
            if (this.mLog != null && this.mLog.getLevel() >= 3) {
                this.logCacheMessage(this.getResString("AddingCacheEntry") + genCacheEntry.key, 3);
                this.logCacheMessage(this.getResString("Size") + Long.toString(genCacheEntry.size / 1000L) + " K," + this.getResString("Time") + DateFormat.getDateTimeInstance().format(new Date(genCacheEntry.time)) + "," + this.getResString("Expires") + Long.toString(genCacheEntry.expires / 1000L) + this.getResString("Seconds"), 5);
            }
            this.mIndex.put(genCacheEntry.key, genCacheEntry);
            this.mCurrentSize += genCacheEntry.size;
            return true;
        }
        return false;
    }

    protected boolean existsCacheEntry(GenCacheEntry genCacheEntry) {
        if (genCacheEntry == null) {
            return false;
        }
        return this.getCacheValue(genCacheEntry.key) != null;
    }

    private boolean setCacheEntryValidate(GenCacheEntry genCacheEntry) {
        if (genCacheEntry == null || genCacheEntry.value == null) {
            return false;
        }
        if (genCacheEntry.expires == 0L) {
            genCacheEntry.expires = this.mDefaultExpire;
        }
        if (this.mCurrentSize + genCacheEntry.size > this.mMaxSize) {
            if (this.mRecycle && this.mDynamicMaintanence) {
                long l = this.freeCacheSpace(genCacheEntry.size);
                if (l < genCacheEntry.size) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected synchronized Object getCacheValue(Object object) {
        if (this.mIndex == null) {
            return null;
        }
        GenCacheEntry genCacheEntry = (GenCacheEntry)this.mIndex.get(object);
        if (genCacheEntry == null) return null;
        if (!this.verifyCacheValue(genCacheEntry)) {
            this.removeCacheEntry(genCacheEntry);
            return null;
        }
        if (this.isCacheEntryExpired(genCacheEntry)) {
            this.removeCacheEntry(genCacheEntry);
            return null;
        }
        this.logCacheMessage(this.getResString("FoundValue") + genCacheEntry.key, 4);
        ++genCacheEntry.hits;
        this.logCacheMessage(this.getResString("HitCount") + genCacheEntry.hits, 5);
        return genCacheEntry.value;
    }

    protected boolean verifyCacheValue(GenCacheEntry genCacheEntry) {
        return genCacheEntry.value != null;
    }

    protected synchronized void removeCacheValue(Object object) {
        if (this.mIndex == null) {
            return;
        }
        GenCacheEntry genCacheEntry = (GenCacheEntry)this.mIndex.get(object);
        if (genCacheEntry != null) {
            this.removeCacheEntry(genCacheEntry);
        }
    }

    protected synchronized void removeCacheEntry(GenCacheEntry genCacheEntry) {
        if (this.mIndex == null) {
            return;
        }
        if (this.mLock) {
            this.logCacheMessage(this.getResString("CacheLockedGet") + genCacheEntry.key, 3);
            return;
        }
        if (genCacheEntry != null) {
            if (this.mLog != null && this.mLog.getLevel() >= 3) {
                this.logCacheMessage(this.getResString("RemovingCacheEntry") + genCacheEntry.key, 3);
                this.logCacheMessage(this.getResString("Size") + Long.toString(genCacheEntry.size / 1000L) + " K," + this.getResString("Time") + DateFormat.getDateTimeInstance().format(new Date(genCacheEntry.time)) + "," + this.getResString("Expires") + Long.toString(genCacheEntry.expires / 1000L) + this.getResString("Seconds"), 5);
            }
            this.mCurrentSize -= genCacheEntry.size;
            this.mIndex.remove(genCacheEntry.key);
        }
    }

    protected synchronized long freeCacheSpace(long l) {
        Enumeration enumeration;
        if (this.mIndex == null) {
            return 0L;
        }
        this.logCacheMessage(this.getResString("RequestFree") + Long.toString(l / 1000L) + "K", 3);
        long l2 = this.mCurrentSize;
        this.expireCacheEntries();
        long l3 = l2 - this.mCurrentSize;
        if (l3 > l) {
            return l3;
        }
        Vector vector = null;
        if (GenUtils.isJava2()) {
            vector = new Vector(this.mIndex.values());
            enumeration = new GenCacheExpireComparator2();
            Collections.sort(vector, enumeration);
        } else {
            vector = GenUtils.hashtableToVector(this.mIndex);
            enumeration = new GenCacheExpireComparator();
            ((Comparer)((Object)enumeration)).Sort(vector);
        }
        l2 = this.mCurrentSize;
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GenCacheEntry genCacheEntry = (GenCacheEntry)enumeration.nextElement();
            this.removeCacheEntry(genCacheEntry);
            l3 = l2 - this.mCurrentSize;
            if (l3 <= l) continue;
            this.logCacheMessage(this.getResString("Freed") + Long.toString(l3 / 1000L) + "K", 1);
            return l3;
        }
        if (l3 > 0L) {
            this.logCacheMessage(this.getResString("Freed") + Long.toString(l3 / 1000L) + "K", 1);
        } else {
            this.logCacheMessage(this.getResString("Freed") + this.getResString("None"), 1);
        }
        return 0L;
    }

    protected synchronized long freeCacheItems(int n) {
        Enumeration enumeration;
        if (this.mIndex == null) {
            return 0L;
        }
        int n2 = this.mIndex.size();
        this.expireCacheEntries();
        long l = n2 - this.mIndex.size();
        if (l > (long)n) {
            return l;
        }
        Vector vector = null;
        if (GenUtils.isJava2()) {
            vector = new Vector(this.mIndex.values());
            enumeration = new GenCacheExpireComparator2();
            Collections.sort(vector, enumeration);
        } else {
            vector = GenUtils.hashtableToVector(this.mIndex);
            enumeration = new GenCacheExpireComparator();
            ((Comparer)((Object)enumeration)).Sort(vector);
        }
        enumeration = vector.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements() && n3 < n) {
            GenCacheEntry genCacheEntry = (GenCacheEntry)enumeration.nextElement();
            this.removeCacheEntry(genCacheEntry);
            ++n3;
            ++l;
        }
        this.logCacheMessage(this.getResString("FreedItems") + Long.toString(l), 1);
        return l;
    }

    protected void expireCacheEntries() {
        if (this.mIndex == null) {
            return;
        }
        Enumeration enumeration = this.mIndex.elements();
        while (enumeration.hasMoreElements()) {
            GenCacheEntry genCacheEntry = (GenCacheEntry)enumeration.nextElement();
            if (!this.isCacheEntryExpired(genCacheEntry)) continue;
            this.removeCacheEntry(genCacheEntry);
        }
    }

    protected boolean isCacheEntryExpired(GenCacheEntry genCacheEntry) {
        long l = System.currentTimeMillis();
        if (genCacheEntry.expires == 0L) {
            return false;
        }
        if (genCacheEntry.time + genCacheEntry.expires < l) {
            this.logCacheMessage(this.getResString("Expired") + genCacheEntry.key, 5);
            return true;
        }
        return false;
    }

    protected void logCacheMessage(String string, int n) {
        this.logCacheMessage(string, true, n);
    }

    private void logCacheMessage(String string, boolean bl, int n) {
        if (this.mLog != null) {
            if (n == -1) {
                this.mLog.setForce(true);
            }
            if (n <= this.mLog.getLevel()) {
                this.mLog.logMessage(string, bl);
            }
            if (n == -1) {
                this.mLog.setForce(false);
            }
        }
    }

    protected String getResString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.macromedia.generator.app.CacheData", Locale.getDefault());
        return resourceBundle.getString(string);
    }
}

