/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Script;
import com.macromedia.generator.app.CacheLog;
import com.macromedia.generator.app.CacheProperties;
import com.macromedia.generator.app.FileCache;
import com.macromedia.generator.app.FlashEnvironment;
import com.macromedia.generator.app.FontCache;
import com.macromedia.generator.app.MediaCache;
import com.macromedia.generator.app.RequestCache;
import com.macromedia.generator.platform.Mac;
import com.macromedia.generator.utils.GenUtils;
import com.macromedia.generator.utils.QueryStringParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class CacheManager {
    private boolean mDebug = true;
    private final String kGenRequestCacheParam = "grc";
    private final String kGenRequestExpiresParam = "gre";
    private final String kGenMediaCacheParam = "gmc";
    private final String kGenMediaExpiresParam = "gme";
    private final String kLineBreak = "\r\n";
    private RequestCache mRequestCache = null;
    private FontCache mFontCache = null;
    private MediaCache mMediaCache = null;
    private FileCache mFileCache = null;
    private CacheLog mLog = null;
    private boolean mUseInternalCaches = false;
    private long mInternalFontCacheMaxSize = 0L;
    private long mInternalMediaCacheMaxSize = 0L;

    public CacheManager() {
        CacheProperties cacheProperties = new CacheProperties();
        this.init(cacheProperties);
    }

    public CacheManager(CacheProperties cacheProperties) {
        this.init(cacheProperties);
    }

    private void init(CacheProperties cacheProperties) {
        this.mLog = new CacheLog(cacheProperties.logLevel, cacheProperties.logCycle, cacheProperties.logsMax);
        if (this.mLog != null && cacheProperties.rcMaxSize == 0L) {
            this.mLog.setLevel(0);
        }
        this.logCacheBreak();
        this.mRequestCache = new RequestCache(cacheProperties.rcMaxSize, cacheProperties.rcForce, cacheProperties.rcRecycle, cacheProperties.rcDefaultExpire, this.mLog);
        if (this.mLog != null) {
            this.mLog.setLevel(cacheProperties.logLevel);
            if (cacheProperties.tcMaxSize == 0L) {
                this.mLog.setLevel(0);
            }
        }
        this.mFontCache = new FontCache(cacheProperties.tcMaxSize, cacheProperties.tcForce, cacheProperties.tcRecycle, cacheProperties.tcDefaultExpire, cacheProperties.tcCheckModifiedSince, cacheProperties.diskBufferSize, cacheProperties.netBufferSize, this.mLog);
        if (this.mLog != null) {
            this.mLog.setLevel(cacheProperties.logLevel);
            if (cacheProperties.mcMaxSize == 0L) {
                this.mLog.setLevel(0);
            }
        }
        this.mMediaCache = new MediaCache(cacheProperties.mcMaxSize, cacheProperties.mcForce, cacheProperties.mcRecycle, cacheProperties.mcDefaultExpire, cacheProperties.mcCheckModifiedSince, cacheProperties.diskBufferSize, cacheProperties.netBufferSize, this.mLog);
        if (this.mLog != null) {
            this.mLog.setLevel(cacheProperties.logLevel);
            if (cacheProperties.fcMaxSize == 0L) {
                this.mLog.setLevel(0);
            }
        }
        this.mFileCache = new FileCache(cacheProperties.fcMaxSize, cacheProperties.fcForce, cacheProperties.fcRecycle, cacheProperties.fcDefaultExpire, cacheProperties.fcCheckModifiedSince, cacheProperties.fcLoad, cacheProperties.diskBufferSize, cacheProperties.netBufferSize, this.mLog);
        if (this.mLog != null) {
            this.mLog.setLevel(cacheProperties.logLevel);
        }
        this.mUseInternalCaches = cacheProperties.useInternalCaches;
        this.mInternalFontCacheMaxSize = cacheProperties.itcMaxSize;
        this.mInternalMediaCacheMaxSize = cacheProperties.imcMaxSize;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        this.logCacheMessage(this.getCacheResString("DisposeCache"), 2);
        if (this.mRequestCache != null) {
            this.mRequestCache.dispose();
            this.mRequestCache = null;
        }
        if (this.mFontCache != null) {
            this.mFontCache.dispose();
            this.mFontCache = null;
        }
        if (this.mMediaCache != null) {
            this.mMediaCache.dispose();
            this.mMediaCache = null;
        }
        if (this.mFileCache != null) {
            this.mFileCache.dispose();
            this.mFileCache = null;
        }
    }

    public void setProperties(CacheProperties cacheProperties) {
        if (this.mLog != null) {
            this.logCacheBreak();
            this.logCacheMessage(this.getCacheResString("SettingCacheProps"), 2);
            this.mLog.setLevel(cacheProperties.logLevel);
            this.mLog.setCycle(cacheProperties.logCycle, cacheProperties.logsMax);
        }
        if (this.mRequestCache != null) {
            this.mRequestCache.setMaxSize(cacheProperties.rcMaxSize);
            this.mRequestCache.setForce(cacheProperties.rcForce);
            this.mRequestCache.setDefaultExpire(cacheProperties.rcDefaultExpire);
            this.mRequestCache.setRecycle(cacheProperties.rcRecycle);
        }
        if (this.mFontCache != null) {
            this.mFontCache.setMaxSize(cacheProperties.tcMaxSize);
            this.mFontCache.setForce(cacheProperties.tcForce);
            this.mFontCache.setDefaultExpire(cacheProperties.tcDefaultExpire);
            this.mFontCache.setRecycle(cacheProperties.tcRecycle);
            this.mFontCache.setCheckModifiedSince(cacheProperties.tcCheckModifiedSince);
            this.mFontCache.setBufferSize(cacheProperties.diskBufferSize, cacheProperties.netBufferSize);
        }
        if (this.mMediaCache != null) {
            this.mMediaCache.setMaxSize(cacheProperties.mcMaxSize);
            this.mMediaCache.setForce(cacheProperties.mcForce);
            this.mMediaCache.setDefaultExpire(cacheProperties.mcDefaultExpire);
            this.mMediaCache.setRecycle(cacheProperties.mcRecycle);
            this.mMediaCache.setCheckModifiedSince(cacheProperties.mcCheckModifiedSince);
            this.mMediaCache.setBufferSize(cacheProperties.diskBufferSize, cacheProperties.netBufferSize);
        }
        if (this.mFileCache != null) {
            this.mFileCache.setMaxSize(cacheProperties.fcMaxSize);
            this.mFileCache.setForce(cacheProperties.fcForce);
            this.mFileCache.setDefaultExpire(cacheProperties.fcDefaultExpire);
            this.mFileCache.setRecycle(cacheProperties.fcRecycle);
            this.mFileCache.setCheckModifiedSince(cacheProperties.fcCheckModifiedSince);
            this.mFileCache.setBufferSize(cacheProperties.diskBufferSize, cacheProperties.netBufferSize);
            this.mFileCache.setLoad(cacheProperties.fcLoad);
        }
        if (this.mLog != null) {
            this.logCacheBreak();
        }
    }

    public CacheProperties getProperties() {
        CacheProperties cacheProperties = new CacheProperties();
        if (this.mLog != null) {
            cacheProperties.logLevel = this.mLog.getLevel();
            cacheProperties.logCycle = this.mLog.getCycle();
            cacheProperties.logsMax = this.mLog.getMaxLogFiles();
        }
        if (this.mRequestCache != null) {
            cacheProperties.rcMaxSize = this.mRequestCache.getMaxSize();
            cacheProperties.rcForce = this.mRequestCache.getForce();
            cacheProperties.rcDefaultExpire = this.mRequestCache.getDefaultExpire();
            cacheProperties.rcRecycle = this.mRequestCache.getRecycle();
        }
        if (this.mFontCache != null) {
            cacheProperties.tcMaxSize = this.mFontCache.getMaxSize();
            cacheProperties.tcForce = this.mFontCache.getForce();
            cacheProperties.tcDefaultExpire = this.mFontCache.getDefaultExpire();
            cacheProperties.tcRecycle = this.mFontCache.getRecycle();
            cacheProperties.tcCheckModifiedSince = this.mFontCache.getCheckModifiedSince();
        }
        if (this.mMediaCache != null) {
            cacheProperties.mcMaxSize = this.mMediaCache.getMaxSize();
            cacheProperties.mcForce = this.mMediaCache.getForce();
            cacheProperties.mcDefaultExpire = this.mMediaCache.getDefaultExpire();
            cacheProperties.mcRecycle = this.mMediaCache.getRecycle();
            cacheProperties.mcCheckModifiedSince = this.mMediaCache.getCheckModifiedSince();
        }
        if (this.mFileCache != null) {
            cacheProperties.fcMaxSize = this.mFileCache.getMaxSize();
            cacheProperties.fcForce = this.mFileCache.getForce();
            cacheProperties.fcDefaultExpire = this.mFileCache.getDefaultExpire();
            cacheProperties.fcRecycle = this.mFileCache.getRecycle();
            cacheProperties.fcCheckModifiedSince = this.mFileCache.getCheckModifiedSince();
            cacheProperties.fcLoad = this.mFileCache.getLoad();
            cacheProperties.diskBufferSize = this.mFileCache.getDiskBufferSize();
            cacheProperties.netBufferSize = this.mFileCache.getNetBufferSize();
        }
        return cacheProperties;
    }

    public RequestCache getRequestCache() {
        return this.mRequestCache;
    }

    public FontCache getFontCache() {
        return this.mFontCache;
    }

    public MediaCache getMediaCache() {
        return this.mMediaCache;
    }

    public FileCache getFileCache() {
        return this.mFileCache;
    }

    public CacheLog getCacheLog() {
        return this.mLog;
    }

    public boolean useInternalCache() {
        return this.mUseInternalCaches;
    }

    public long getInternalFontCacheMaxSize() {
        return this.mInternalFontCacheMaxSize;
    }

    public long getInternalMediaCacheMaxSize() {
        return this.mInternalMediaCacheMaxSize;
    }

    public void purgeCaches() {
        if (this.mRequestCache != null) {
            this.mRequestCache.purge();
        }
        if (this.mFontCache != null) {
            this.mFontCache.purge();
        }
        if (this.mMediaCache != null) {
            this.mMediaCache.purge();
        }
        if (this.mFileCache != null) {
            this.mFileCache.purge();
        }
    }

    public void logHitCounts() {
        this.logCacheBreak(true);
        if (this.mRequestCache != null) {
            this.mRequestCache.logHitCounts();
        }
        if (this.mFontCache != null) {
            this.mFontCache.logHitCounts();
        }
        if (this.mMediaCache != null) {
            this.mMediaCache.logHitCounts();
        }
        if (this.mFileCache != null) {
            this.mFileCache.logHitCounts();
        }
        this.logCacheBreak(true);
    }

    public String makeRequestString(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = string + (string2 != null ? "?" + string2 : "");
        return string3;
    }

    public boolean addRequest(String string, Buffer buffer) {
        if (this.mRequestCache == null) {
            return false;
        }
        boolean bl = false;
        long l = 0L;
        QueryStringParser queryStringParser = new QueryStringParser();
        Hashtable hashtable = queryStringParser.parse(string);
        if (hashtable != null && hashtable.size() > 0) {
            String string2 = null;
            string2 = (String)hashtable.get("grc");
            if (string2 != null) {
                if (string2.equalsIgnoreCase("true")) {
                    bl = true;
                } else if (string2.equalsIgnoreCase("false")) {
                    bl = false;
                }
            }
            if ((string2 = (String)hashtable.get("gre")) != null) {
                l = Long.parseLong(string2);
            }
            string = this.stripGeneratorParams(string);
        }
        return this.mRequestCache.addRequest(string, buffer, bl, l);
    }

    public String stripGeneratorParams(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf(63);
        if (n > -1) {
            string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1, string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "&");
            boolean bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (n <= 0 || string4.startsWith("grc") || string4.startsWith("gre")) continue;
                if (!bl) {
                    string2 = string2 + "&";
                }
                string2 = string2 + string4;
                bl = false;
            }
            if (string2.endsWith("?")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    public Buffer getRequestBuffer(String string) {
        if (this.mRequestCache == null || string == null) {
            return null;
        }
        string = this.stripGeneratorParams(string);
        return this.mRequestCache.getMatchingRequestBuffer(string);
    }

    public void loadExternalFonts(FlashEnvironment flashEnvironment, Script script) throws GeneratorApiException {
        try {
            int n = script.getExternalFontCount();
            if (n > 0) {
                this.logWarning(flashEnvironment, this.getGeneratorResString("ExtFontWarn"));
            }
            int n2 = 0;
            while (n2 < n) {
                String string = script.getExternalFontFile(n2);
                Object object = this.getFontData(flashEnvironment, string);
                if (object != null) {
                    Buffer buffer = new Buffer();
                    buffer.write((byte[])object);
                    script.loadExternalFontBuffer(n2, buffer);
                    buffer.release();
                }
                ++n2;
            }
        }
        catch (GeneratorApiException generatorApiException) {
            this.logError(flashEnvironment, this.getGeneratorResString("ExtFontErrProcess"));
            throw generatorApiException;
        }
    }

    private Object getFontData(FlashEnvironment flashEnvironment, String string) {
        if (string == null || this.mFontCache == null) {
            return null;
        }
        String string2 = null;
        string2 = this.createFontPath(flashEnvironment, string);
        if (string2 == null) {
            return null;
        }
        URL uRL = null;
        uRL = this.createURLFromPath(flashEnvironment, string2);
        if (uRL == null) {
            return null;
        }
        Object object = null;
        try {
            if (flashEnvironment.getFontCache() != null) {
                object = flashEnvironment.getFontCache().getURLData(uRL);
                if (object == null) {
                    object = flashEnvironment.getFontCache().fetchURLData(uRL, true, 0L);
                }
            } else {
                object = this.mFontCache.getURLData(uRL);
                if (object == null) {
                    object = this.mFontCache.fetchURLData(uRL, true, 0L);
                }
            }
            if (object == null) {
                this.logError(flashEnvironment, this.getGeneratorResString("ExtFontErr") + uRL.toString());
            }
        }
        catch (IOException iOException) {
            this.logError(flashEnvironment, this.getGeneratorResString("ExtFontErr") + uRL.toString() + ": " + iOException);
            return null;
        }
        return object;
    }

    private String createFontPath(FlashEnvironment flashEnvironment, String string) {
        Object object;
        String string2 = null;
        File file = new File(string);
        if (!file.isAbsolute()) {
            object = null;
            if (flashEnvironment != null) {
                object = flashEnvironment.getDirectory();
            }
            if (object != null) {
                file = new File((File)object, file.getPath());
            } else {
                this.logError(flashEnvironment, this.getGeneratorResString("ExtFontErr") + file.getPath());
            }
        }
        if (file.exists() && file.isFile()) {
            string2 = file.getPath();
        } else {
            object = null;
            if (flashEnvironment != null) {
                object = flashEnvironment.getExternalFontLocation();
            }
            if (object != null) {
                object = this.stripQuotes((String)object);
                String string3 = System.getProperty("file.separator");
                String string4 = (String)object + string3 + string;
                file = new File(string4);
                if (file.exists() && file.isFile()) {
                    string2 = file.getPath();
                } else {
                    File file2 = flashEnvironment.getDirectory();
                    file = new File(file2, string4);
                    if (file.exists() && file.isFile()) {
                        string2 = file.getPath();
                    } else if (string4.startsWith("\\")) {
                        string2 = "http:" + string4;
                        string2 = string2.replace('\\', '/');
                    } else {
                        this.logError(flashEnvironment, this.getGeneratorResString("ExtFontErr") + file.getPath());
                    }
                }
            } else {
                this.logError(flashEnvironment, this.getGeneratorResString("ExtFontErr") + file.getPath());
            }
        }
        return string2;
    }

    private String stripQuotes(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Object getMediaData(FlashEnvironment flashEnvironment, String string, boolean bl) {
        Object object;
        URL uRL = null;
        uRL = this.createURLFromPath(flashEnvironment, string);
        if (uRL == null) {
            return null;
        }
        long l = 0L;
        QueryStringParser queryStringParser = new QueryStringParser();
        Hashtable hashtable = queryStringParser.parse(string);
        if (hashtable != null && hashtable.size() > 0) {
            object = null;
            object = (String)hashtable.get("gmc");
            if (object != null) {
                if (((String)object).equalsIgnoreCase("true")) {
                    bl = true;
                } else if (((String)object).equalsIgnoreCase("false")) {
                    bl = false;
                }
            }
            if ((object = (String)hashtable.get("gme")) != null) {
                l = Long.parseLong((String)object);
            }
        }
        object = null;
        object = this.getMediaURLData(flashEnvironment, uRL, bl, l);
        return object;
    }

    private Object getMediaURLData(FlashEnvironment flashEnvironment, URL uRL, boolean bl, long l) {
        if (uRL == null || this.mMediaCache == null || this.mFileCache == null) {
            return null;
        }
        Object object = null;
        try {
            if (flashEnvironment.getMediaCache() != null) {
                object = flashEnvironment.getMediaCache().getURLData(uRL);
                if (object == null) {
                    object = flashEnvironment.getMediaCache().fetchURLData(uRL, true, 0L);
                }
            } else {
                object = this.mMediaCache.getURLData(uRL);
                if (object == null) {
                    object = this.mFileCache.getURLData(uRL);
                    if (object == null) {
                        object = this.mFileCache.fetchURLData(uRL, bl, l);
                        if (object == null) {
                            object = this.mMediaCache.fetchURLData(uRL, bl, l);
                        } else {
                            this.mMediaCache.setCacheURL(uRL, object, ((byte[])object).length, l);
                        }
                    } else {
                        this.mMediaCache.setCacheURL(uRL, object, ((byte[])object).length, l);
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.logError(flashEnvironment, this.getCacheResString("ErrorReadingMediaData") + uRL.toString() + ": " + iOException);
            return null;
        }
        if (object == null) {
            this.logCacheMessage(this.getCacheResString("UnableToGetURLData") + uRL.toString(), 2);
        }
        return object;
    }

    private URL createURLFromPath(FlashEnvironment flashEnvironment, String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = this.createFileFromPath(flashEnvironment, string);
            if (file == null) {
                uRL = null;
            }
            try {
                string = file.getAbsolutePath();
                if (string.startsWith("\\")) {
                    uRL = !GenUtils.isJava2() ? GenUtils.toURL(file) : file.toURL();
                } else {
                    String string2 = System.getProperty("file.separator");
                    if (string2.length() == 1) {
                        char c = string2.charAt(0);
                        if (c != '/') {
                            string = string.replace(c, '/');
                        }
                        if (string.charAt(0) != '/') {
                            string = '/' + string;
                        }
                    }
                    string = "file://" + string;
                    uRL = new URL(string);
                }
            }
            catch (MalformedURLException malformedURLException2) {
                uRL = null;
            }
        }
        return uRL;
    }

    private File createFileFromPath(FlashEnvironment flashEnvironment, String string) {
        Object object;
        if (string == null) {
            return null;
        }
        Mac mac = Mac.getMac();
        File file = null;
        if (mac != null) {
            object = mac.makeJavaPretty(string);
            file = new File((String)object);
            if (!file.exists() || !file.isFile()) {
                file = new File(((String)object).substring(1));
            }
        } else {
            file = new File(string);
        }
        if (file != null) {
            if (!file.isAbsolute()) {
                object = null;
                if (flashEnvironment != null) {
                    object = flashEnvironment.getDirectory();
                }
                if (object != null) {
                    file = new File((File)object, file.getPath());
                }
            }
            if (!file.exists() || !file.isFile()) {
                file = null;
            }
        }
        return file;
    }

    private void logMessage(FlashEnvironment flashEnvironment, String string) {
        if (flashEnvironment != null) {
            flashEnvironment.logMessage(string);
        } else {
            System.out.println(string);
        }
    }

    private void logWarning(FlashEnvironment flashEnvironment, String string) {
        if (flashEnvironment != null) {
            flashEnvironment.logWarning(string);
        } else {
            System.out.println(string);
        }
    }

    private void logError(FlashEnvironment flashEnvironment, String string) {
        if (flashEnvironment != null) {
            flashEnvironment.logError(string);
        } else {
            System.out.println(string);
        }
    }

    private void logCacheBreak() {
        this.logCacheBreak(false);
    }

    private void logCacheBreak(boolean bl) {
        if (this.mLog != null) {
            if (bl) {
                this.mLog.setForce(true);
            }
            this.mLog.logMessage("", false);
            if (bl) {
                this.mLog.setForce(false);
            }
        }
    }

    private void logCacheMessage(String string, int n) {
        if (this.mLog != null && n <= this.mLog.getLevel()) {
            this.mLog.logMessage(string);
        }
    }

    private String getCacheResString(String string) {
        return this.getResString("com.macromedia.generator.app.CacheData", string);
    }

    private String getGeneratorResString(String string) {
        return this.getResString("com.macromedia.generator.resources.ResourceData", string);
    }

    private String getResString(String string, String string2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
        return resourceBundle.getString(string2);
    }

    private void DebugOut(String string) {
        if (this.mDebug) {
            System.out.println(string);
        }
    }
}

