/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.FillStyle;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.LineStyle;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.peer.ShapePeer;

public class Shape
extends GenObject {
    private static final int MAX_VALUE = 30000;
    private static final String rangeErrorStr = "Shape outline range error";

    public Shape() throws GeneratorApiException {
        this.peer = ShapePeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Shape(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ShapePeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ShapePeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setLineStyle(LineStyle lineStyle) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ShapePeer.SetLineStyle(this.peer, lineStyle.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting the line style");
        }
    }

    public void setFillStyle(FillStyle fillStyle, FillStyle fillStyle2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ShapePeer.SetFillStyle(this.peer, fillStyle.peer, fillStyle2.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting the fill style");
        }
    }

    public void moveTo(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (n > 30000 || n2 > 30000 || n < -30000 || n2 < -30000) {
            throw new GeneratorApiException(rangeErrorStr);
        }
        int n3 = ShapePeer.MoveTo(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error moving to a position");
        }
    }

    public void lineTo(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (n > 30000 || n2 > 30000 || n < -30000 || n2 < -30000) {
            throw new GeneratorApiException(rangeErrorStr);
        }
        int n3 = ShapePeer.LineTo(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error adding a line");
        }
    }

    public void curveTo(int n, int n2, int n3, int n4) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (n > 30000 || n2 > 30000 || n < -30000 || n2 < -30000) {
            throw new GeneratorApiException(rangeErrorStr);
        }
        if (n3 > 30000 || n4 > 30000 || n3 < -30000 || n4 < -30000) {
            throw new GeneratorApiException(rangeErrorStr);
        }
        int n5 = ShapePeer.CurveTo(this.peer, n, n2, n3, n4);
        if (n5 == 0) {
            throw new GeneratorApiException("error adding a curve");
        }
    }

    public Rect getBounds() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ShapePeer.GetBounds(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting bounds");
        }
        return new Rect(nArray[0]);
    }

    public void setCenter(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (n > 30000 || n2 > 30000 || n < -30000 || n2 < -30000) {
            throw new GeneratorApiException(rangeErrorStr);
        }
        int n3 = ShapePeer.SetCenter(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting center");
        }
    }

    public void append(Shape shape) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ShapePeer.Append(this.peer, shape.peer);
        if (n == 0) {
            throw new GeneratorApiException("error appending shape");
        }
    }
}

