/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiRuntimeException;
import com.macromedia.generator.api.peer.RectPeer;

public class Rect
extends GenObject {
    public Rect() {
        this.peer = RectPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("unable to create peer");
        }
    }

    protected Rect(int n) {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            RectPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            RectPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setXMin(int n) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = RectPeer.SetXMin(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error setting minimum x value");
        }
    }

    public int getXMin() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = RectPeer.GetXMin(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting minimum x value");
        }
        return nArray[0];
    }

    public void setXMax(int n) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = RectPeer.SetXMax(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error setting maximum x value");
        }
    }

    public int getXMax() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = RectPeer.GetXMax(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting maximum x value");
        }
        return nArray[0];
    }

    public void setYMin(int n) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = RectPeer.SetYMin(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error setting minimum y value");
        }
    }

    public int getYMin() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = RectPeer.GetYMin(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting minimum y value");
        }
        return nArray[0];
    }

    public void setYMax(int n) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = RectPeer.SetYMax(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error setting maximum x value");
        }
    }

    public int getYMax() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = RectPeer.GetYMax(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting maximum y value");
        }
        return nArray[0];
    }
}

