/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Serial;
import com.macromedia.generator.api.peer.GifBuilderPeer;

public class GifBuilder
extends GenObject {
    public GifBuilder() throws GeneratorApiException {
        this.peer = GifBuilderPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected GifBuilder(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            GifBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            GifBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setSerial(Serial serial) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = serial != null ? serial.peer : 0;
        GifBuilderPeer.SetSerial(this.peer, n);
    }

    public void setInterlace(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetInterlace(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting interlace flag");
        }
    }

    public boolean getInterlace() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetInterlace(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting interlace flag");
        }
        return blArray[0];
    }

    public void setTransparent(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetTransparent(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting transparent flag");
        }
    }

    public boolean getTransparent() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetTransparent(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting transparent flag");
        }
        return blArray[0];
    }

    public void setTransparentSmart(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetTransparentSmart(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting transparent smart flag");
        }
    }

    public boolean getTransparentSmart() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetTransparentSmart(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting transparent smart flag");
        }
        return blArray[0];
    }

    public void setTransparentThreshold(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GifBuilderPeer.SetTransparentThreshold(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting transparent threshold value");
        }
    }

    public int getTransparentThreshold() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetTransparentThreshold(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting transparent threshold value");
        }
        return nArray[0];
    }

    public void setLoopCount(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GifBuilderPeer.SetLoopCount(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting loop count");
        }
    }

    public int getLoopCount() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetLoopCount(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting loop count");
        }
        return nArray[0];
    }

    public void setFirstFrame(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GifBuilderPeer.SetFirstFrame(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting first frame");
        }
    }

    public int getFirstFrame() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetFirstFrame(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting first frame");
        }
        return nArray[0];
    }

    public void setLastFrame(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GifBuilderPeer.SetLastFrame(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting last frame");
        }
    }

    public int getLastFrame() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetLastFrame(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting last frame");
        }
        return nArray[0];
    }

    public void setDither(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetDither(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting dither flag");
        }
    }

    public boolean getDither() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetDither(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting dither flag");
        }
        return blArray[0];
    }

    public void setDitherType(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GifBuilderPeer.SetDitherType(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting dither type flag");
        }
    }

    public int getDitherType() throws GeneratorApiException {
        int[] nArray = new int[]{2};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetDitherType(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting dither type value");
        }
        return nArray[0];
    }

    public void setSmooth(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetSmooth(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting smooth flag");
        }
    }

    public boolean getSmooth() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{true};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetSmooth(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting smooth flag");
        }
        return blArray[0];
    }

    public void setGradient(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetGradient(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting gradient flag");
        }
    }

    public boolean getGradient() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetGradient(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting gradient flag");
        }
        return blArray[0];
    }

    public void setDimensions(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = GifBuilderPeer.SetDimensions(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting dimensions for gif");
        }
    }

    public boolean getDimensions(int[] nArray, int[] nArray2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetDimensions(this.peer, nArray, nArray2);
        if (n == 0) {
            throw new GeneratorApiException("error getting dimensions");
        }
        return true;
    }

    public void build(Buffer buffer, Buffer buffer2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (buffer.peer == 0 || buffer2.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.Build(this.peer, buffer.peer, buffer2.peer);
        if (n == 0) {
            throw new GeneratorApiException("error building the GIF buffer");
        }
    }

    public void buildImageMap(boolean bl, int n, Buffer buffer, Buffer buffer2, String string) throws GeneratorApiException {
        int n2;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (buffer.peer == 0 || buffer2.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            string = new String("NOMAPNAME");
        }
        if ((n2 = GifBuilderPeer.BuildImageMap(this.peer, bl, n, buffer.peer, buffer2.peer, string)) == 0) {
            throw new GeneratorApiException("error building the image map buffer");
        }
    }

    public void setColorOptimization(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetColorOptimization(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting color optimization flag");
        }
    }

    public boolean getColorOptimization() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{true};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetColorOptimization(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting the color optimization flag");
        }
        return blArray[0];
    }

    public void setPaletteType(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GifBuilderPeer.SetPaletteType(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting palette type");
        }
    }

    public void setMaxColors(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GifBuilderPeer.SetMaxColors(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting max number of colors");
        }
    }

    public void setFilePalette(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetFilePalette(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting the custom palette");
        }
    }

    public void setQuality(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetQuality(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("Error Setting Quality");
        }
    }

    public void setExactFit(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetExactFit(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting exact fit flag");
        }
    }

    public void setAnimated(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetAnimated(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting animated flag");
        }
    }

    public boolean getAnimated() throws GeneratorApiException {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.GetAnimated(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting animated flag");
        }
        return blArray[0];
    }

    public void setBackgroundColor(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = GifBuilderPeer.SetBackgroundColor(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting background color");
        }
    }
}

