/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Bitmap;
import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Gradient;
import com.macromedia.generator.api.Matrix;
import com.macromedia.generator.api.peer.FillStylePeer;

public class FillStyle
extends GenObject {
    public FillStyle() throws GeneratorApiException {
        this.peer = FillStylePeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected FillStyle(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            FillStylePeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            FillStylePeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setMatrix(Matrix matrix) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FillStylePeer.SetMatrix(this.peer, matrix.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting matrix");
        }
    }

    public void setRgb(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = FillStylePeer.SetRgb(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting rgb");
        }
    }

    public void setColor(Color color) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FillStylePeer.SetColor(this.peer, color.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting color");
        }
    }

    public void setTiledBitmap(Bitmap bitmap) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FillStylePeer.SetTiledBitmap(this.peer, bitmap.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting tiled bitmap");
        }
    }

    public void setClippedBitmap(Bitmap bitmap) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FillStylePeer.SetClippedBitmap(this.peer, bitmap.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting clipped bitmap");
        }
    }

    public void setLinearGradient(Gradient gradient) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FillStylePeer.SetLinearGradient(this.peer, gradient.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting linear gradient");
        }
    }

    public void setRadialGradient(Gradient gradient) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = FillStylePeer.SetRadialGradient(this.peer, gradient.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting radial gradient");
        }
    }
}

