/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.ActionPeer;

public class Action
extends GenObject {
    public static final int bsIdleToOverUp = 1;
    public static final int bsOverUpToIdle = 2;
    public static final int bsOverUpToOverDown = 4;
    public static final int bsOverDownToOverUp = 8;
    public static final int bsOverDownToOutDown = 272;
    public static final int bsOutDownToOverDown = 160;
    public static final int bsOutDownToIdle = 64;
    public static final int bsIdleToOverDown = 128;
    public static final int bsOverDownToIdle = 256;
    public static final int NOSEND = 128;
    public static final int GET = 129;
    public static final int POST = 130;
    public static final int PROP_X_POSITION = 1;
    public static final int PROP_Y_POSITION = 2;
    public static final int PROP_X_SCALE = 3;
    public static final int PROP_Y_SCALE = 4;
    public static final int PROP_ALPHA = 5;
    public static final int PROP_VISIBILITY = 6;
    public static final int PROP_ROTATION = 7;
    public static final int PROP_NAME = 8;

    public Action() throws GeneratorApiException {
        this.peer = ActionPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Action(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ActionPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ActionPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void addGotoFrame(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ActionPeer.AddGotoFrame(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error adding goto frame action");
        }
    }

    public void addSetVariableArgs(String string, String string2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        this.addPush(string);
        this.addPush(string2);
        int n = ActionPeer.AddSetVariable(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding set variable action");
        }
    }

    public void addSetVariable() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddSetVariable(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding set variable action");
        }
    }

    public void addGetVariable() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddGetVariable(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding get variable action");
        }
    }

    public void addTellTarget(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddTellTarget(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error adding tell target action");
        }
    }

    public void addGetURL(String string, String string2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null || string2 == null) {
            throw new GeneratorApiException("null string");
        }
        int n = ActionPeer.AddGetURL(this.peer, string, string2);
        if (n == 0) {
            throw new GeneratorApiException("error adding get URL action");
        }
    }

    public void addNextFrame() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddNextFrame(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding next frame action");
        }
    }

    public void addPrevFrame() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddPrevFrame(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding previous frame action");
        }
    }

    public void addPlay() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddPlay(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding play action");
        }
    }

    public void addStop() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStop(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding stop action");
        }
    }

    public void addToggleQuality() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddToggleQuality(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding toggle quality action");
        }
    }

    public void addStopSounds() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStopSounds(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding stop sounds action");
        }
    }

    public void addWaitForFrame(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ActionPeer.AddWaitForFrame(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error adding wait for frame action");
        }
    }

    public void addGotoLabel(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddGotoLabel(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error adding goto label action");
        }
    }

    public void addAdd() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddAdd(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding add action");
        }
    }

    public void addSubtract() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddSubtract(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding subtract action");
        }
    }

    public void addMultiply() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddMultiply(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding multiply action");
        }
    }

    public void addDivide() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddDivide(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding divide action");
        }
    }

    public void addLess() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddLess(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding less action");
        }
    }

    public void addAnd() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddAnd(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding less action");
        }
    }

    public void addOr() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddOr(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding Or action");
        }
    }

    public void addStringExtract() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStringExtract(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding StringExtract action");
        }
    }

    public void addToInteger() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddToInteger(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding ToInteger action");
        }
    }

    public void addJump() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddJump(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding Jump action");
        }
    }

    public void addEndJump() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddEndJump(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding EndJump action");
        }
    }

    public void addCall() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddCall(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding Call action");
        }
    }

    public void addPush(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddPush(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error adding push action");
        }
    }

    public void addPushProperty(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ActionPeer.AddPushProperty(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error adding pushProperty action");
        }
    }

    public void addPop() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddPop(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding pop action");
        }
    }

    public void addNot() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddNot(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding Not action");
        }
    }

    public void addStringEq() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStringEq(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding stringEq action");
        }
    }

    public void addStringLength() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStringLength(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding stringLength action");
        }
    }

    public void addStringAdd() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStringAdd(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding stringAdd action");
        }
    }

    public void addEq() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddEq(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding Eq action");
        }
    }

    public void addIf() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddIf(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding If action");
        }
    }

    public void addGetURL2(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ActionPeer.AddGetURL2(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error adding Get URL 2 action");
        }
    }

    public void addGotoFrame2() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddGotoFrame2(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding GotoFrame2 action");
        }
    }

    public void addSetTarget2() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddSetTarget2(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding SetTarget2 action");
        }
    }

    public void addGetProperty() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddGetProperty(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding GetProperty action");
        }
    }

    public void addSetProperty() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddSetProperty(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding SetProperty action");
        }
    }

    public void addCloneSprite() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddCloneSprite(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding CloneSprite action");
        }
    }

    public void addRemoveSprite() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddRemoveSprite(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding RemoveSprite action");
        }
    }

    public void addTrace() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddTrace(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding Trace action");
        }
    }

    public void addStartDrag() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStartDrag(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding StartDrag action");
        }
    }

    public void addEndDrag() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddEndDrag(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding EndDrag action");
        }
    }

    public void addStringLess() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddStringLess(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding StringLess action");
        }
    }

    public void addWaitForFrame2() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddWaitForFrame2(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding WaitForFrame2 action");
        }
    }

    public void addRandomNumber() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddRandomNumber(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding RandomNumber action");
        }
    }

    public void addMBStringLength() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddMBStringLength(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding MBStringLength action");
        }
    }

    public void addCharToAscii() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddCharToAscii(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding CharToAscii action");
        }
    }

    public void addAsciiToChar() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddAsciiToChar(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding AsciiToChar action");
        }
    }

    public void addGetTime() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddGetTime(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding GetTime action");
        }
    }

    public void addMBStringExtract() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddMBStringExtract(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding MBStringExtract action");
        }
    }

    public void addMBCharToAscii() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddMBCharToAscii(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding MBCharToAscii action");
        }
    }

    public void addMBAsciiToChar() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddMBAsciiToChar(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding MBAsciiToChar action");
        }
    }

    public void addEndIf() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ActionPeer.AddEndIf(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding EndIf action");
        }
    }

    public void setTransitionState(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ActionPeer.SetTransitionState(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting transition state for action");
        }
    }
}

