/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.GradientPanel;
import com.android.draw9patch.ui.ImageEditorPanel;
import com.android.draw9patch.ui.OpenFilePanel;
import com.android.draw9patch.ui.PngFileFilter;
import com.android.draw9patch.ui.action.ExitAction;
import com.android.draw9patch.ui.action.OpenAction;
import com.android.draw9patch.ui.action.SaveAction;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame {
    private ActionMap actionsMap;
    private JMenuItem saveMenuItem;
    private ImageEditorPanel imageEditor;

    public MainFrame(String path) throws HeadlessException {
        super("Draw 9-patch");
        this.buildActions();
        this.buildMenuBar();
        this.buildContent();
        if (path == null) {
            this.showOpenFilePanel();
        } else {
            try {
                File file = new File(path);
                BufferedImage img = GraphicsUtilities.loadCompatibleImage(file.toURI().toURL());
                this.showImageEditor(img, file.getAbsolutePath());
            }
            catch (Exception ex) {
                this.showOpenFilePanel();
            }
        }
        this.setSize(1024, 600);
    }

    private void buildActions() {
        this.actionsMap = new ActionMap();
        this.actionsMap.put("open", new OpenAction(this));
        this.actionsMap.put("save", new SaveAction(this));
        this.actionsMap.put("exit", new ExitAction(this));
    }

    private void buildMenuBar() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        openMenuItem.setAction(this.actionsMap.get("open"));
        fileMenu.add(openMenuItem);
        this.saveMenuItem.setAction(this.actionsMap.get("save"));
        this.saveMenuItem.setEnabled(false);
        fileMenu.add(this.saveMenuItem);
        exitMenuItem.setAction(this.actionsMap.get("exit"));
        fileMenu.add(exitMenuItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
    }

    private void buildContent() {
        this.setContentPane(new GradientPanel());
    }

    private void showOpenFilePanel() {
        this.add(new OpenFilePanel(this));
    }

    public SwingWorker<?, ?> open(File file) {
        if (file == null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new PngFileFilter());
            int choice = chooser.showOpenDialog(this);
            if (choice == 0) {
                return new OpenTask(chooser.getSelectedFile());
            }
            return null;
        }
        return new OpenTask(file);
    }

    void showImageEditor(BufferedImage image, String name) {
        this.getContentPane().removeAll();
        this.imageEditor = new ImageEditorPanel(this, image, name);
        this.add(this.imageEditor);
        this.saveMenuItem.setEnabled(true);
        this.validate();
        this.repaint();
    }

    public SwingWorker<?, ?> save() {
        if (this.imageEditor == null) {
            return null;
        }
        File file = this.imageEditor.chooseSaveFile();
        return file != null ? new SaveTask(file) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OpenTask
    extends SwingWorker<BufferedImage, Void> {
        private final File file;

        OpenTask(File file) {
            this.file = file;
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            return GraphicsUtilities.loadCompatibleImage(this.file.toURI().toURL());
        }

        @Override
        protected void done() {
            try {
                MainFrame.this.showImageEditor((BufferedImage)this.get(), this.file.getAbsolutePath());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SaveTask
    extends SwingWorker<Boolean, Void> {
        private final File file;

        SaveTask(File file) {
            this.file = file;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            try {
                ImageIO.write(MainFrame.this.imageEditor.getImage(), "PNG", this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

