#include <koan.fx>

/*
sampler baseTex : register(s0) = sampler_state
{
   addressu = clamp;
   addressv = clamp;
};
*/

//----------------------------------------------------------------------------
// ripple effect
//----------------------------------------------------------------------------
float time = 0;
float freq = 4;
float amp = 0.0;
float speed = 4;
float offset = 0.5;

float cx = 0.5;
float cy = 0.5;

float4 Ripple( float2 uv: TEXCOORD0, float4 color : COLOR0 ) : COLOR 
{
    float x = (uv.x - cx)*2;  // 0 - 1
    float y = (uv.y - cy)*2;  // 0 - 1
    float d = sqrt(x*x + y*y);
    float wave = cos(d * 3.1415926 * freq - (time * speed)) * amp;
    
    float2 dir = normalize( float2(x, y) );
    
    return tex2D( g_Tex, (uv + dir * wave / exp(d*freq/2) ) ) * color;
}

technique RippleEffect
{
    pass P0
    {
        PixelShader  = compile ps_2_0 Ripple();
    }
}

technique BasicEffect
{
	pass P0
    {
    }
}
