sampler texA : register(s0);
sampler texB : register(s1);

float alphaOffset = 0.5;
float totalBlockCount = 0;

float4 wipe( float2 uv: TEXCOORD0, float4 color : COLOR0 ) : COLOR 
{
	const float4 cA = tex2D(texA, uv);
    const float pos = color[3]; // between 0 ~ 1.  1 is the last block
    const float a = clamp((alphaOffset - pos * 0.2) * 10, 0, 1);
    const float4 base = float4(color[0], color[1], color[2], 1.0);
    const float4 cColor = (base * (1.0 - a) + cA * a) * step(0.1, a);
    
    return float4(cColor[0], cColor[1], cColor[2], step(0.1, a));
}

technique Wipe
{
    pass P0 {
        PixelShader  = compile ps_2_0 wipe();
        SRCBLEND = ONE;
        DESTBLEND = ZERO;
        ALPHABLENDENABLE = FALSE;
    }
}

technique NoEffect
{
	pass P0 {
		ColorWriteEnable = 0;
		zenable = true;
		zfunc = never;
	}
} 