sampler tex : register(s0);


float4 glossy( float2 uv: TEXCOORD0, float4 color : COLOR0 ) : COLOR 
{
    float x = uv[0];
    float y = uv[1];
    
    const float r = 357.0 / 256.0;
    float det = pow(x - 347.0 / 256.0, 2) + pow(y - 347.0 / 256.0, 2) - r * r;
    const float4 tColor = tex2D(tex, uv);
    return float4(tColor.rgb, step(det * -1, 0) * tColor.a);
}

technique Glossy
{
    pass P0 {
        ColorWriteEnable = 7;
        PixelShader  = compile ps_2_0 glossy();
    }
}

technique NoEffect
{
	pass P0 {
		ColorWriteEnable = 0;
		zenable = true;
		zfunc = never;
	}
} 