{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnTestParseTimeWizard;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣʱרʾԪ
* ԪߣCnPack 
*     עõԪǽʱרҵĲԵԪԱTObject.Create 
*           D2010 ԰µĺʱʮ D5/D7 ǰ汾ڴ
*           ڣֻ IDE ڲ exe վɡ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַݲֱ֧ػʽ
* Ԫʶ$Id$
* ޸ļ¼2009.06.06 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolsAPI, IniFiles, StdCtrls, CnPasCodeParser, mPasLex, Contnrs, TypInfo,
  CnWizClasses, CnWizUtils, CnWizConsts, CnEditControlWrapper, mwBCBTokenList;

type

  TCnTestToken = class(TPersistent)
  {* һ Token ĽṹϢ}
  private

  protected
    FCppTokenKind: TCTokenKind;
    FCharIndex: Integer;
    FEditCol: Integer;
    FEditLine: Integer;
    FItemIndex: Integer;
    FItemLayer: Integer;
    FLineNumber: Integer;
    FMethodLayer: Integer;
    // FToken: AnsiString;
    FTokenID: TTokenKind;
    FTokenPos: Integer;
    FIsMethodStart: Boolean;
    FIsMethodClose: Boolean;
    FIsBlockStart: Boolean;
    FIsBlockClose: Boolean;
    FUseAsC: Boolean;
  published
    property UseAsC: Boolean read FUseAsC;
    {* Ƿ C ʽĽĬϲ}
    property CharIndex: Integer read FCharIndex; // Start 0
    {* ӱпʼַλã㿪ʼ }
    property EditCol: Integer read FEditCol write FEditCol;
    {* Уһʼ }
    property EditLine: Integer read FEditLine write FEditLine;
    {* Уһʼ }
    property ItemIndex: Integer read FItemIndex;
    {*  Parser е }
    property ItemLayer: Integer read FItemLayer;
    {* ڸĲ }
    property LineNumber: Integer read FLineNumber; // Start 0
    {* кţ㿪ʼ }
    property MethodLayer: Integer read FMethodLayer;
    {* ںǶײΣΪһ }
    // property Token: AnsiString read FToken;
    {*  Token ַ }
    property TokenID: TTokenKind read FTokenID;
    {* Token ﷨ }
    property CppTokenKind: TCTokenKind read FCppTokenKind;
    {* Ϊ C  Token ʹʱ CToken }
    property TokenPos: Integer read FTokenPos;
    {* Token ļеλ }
    property IsBlockStart: Boolean read FIsBlockStart;
    {* ǷһƥĿʼ }
    property IsBlockClose: Boolean read FIsBlockClose;
    {* ǷһƥĽ }
    property IsMethodStart: Boolean read FIsMethodStart;
    {* ǷǺ̵Ŀʼ }
    property IsMethodClose: Boolean read FIsMethodClose;
    {* ǷǺ̵Ľ }
  end;

  PCnTestRecord = ^TCnTestRecord;
  TCnTestRecord = packed record
    FCppTokenKind: TCTokenKind;
    FCharIndex: Integer;
    FEditCol: Integer;
    FEditLine: Integer;
    FItemIndex: Integer;
    FItemLayer: Integer;
    FLineNumber: Integer;
    FMethodLayer: Integer;
    FToken: AnsiString;
    FTokenID: TTokenKind;
    FTokenPos: Integer;
    FIsMethodStart: Boolean;
    FIsMethodClose: Boolean;
    FIsBlockStart: Boolean;
    FIsBlockClose: Boolean;
    FUseAsC: Boolean;
  end;

//==============================================================================
// ʱò˵ר
//==============================================================================

{ TCnTestParseTimeWizard }

  TCnTestParseTimeWizard = class(TCnMenuWizard)
  private

  protected
    function GetHasConfig: Boolean; override;
  public
    function GetState: TWizardState; override;
    procedure Config; override;
    procedure LoadSettings(Ini: TCustomIniFile); override;
    procedure SaveSettings(Ini: TCustomIniFile); override;
    class procedure GetWizardInfo(var Name, Author, Email, Comment: string); override;
    function GetCaption: string; override;
    function GetHint: string; override;
    function GetDefShortCut: TShortCut; override;
    procedure Execute; override;

    destructor Destroy; override;
  end;

implementation

//==============================================================================
// ʱò˵ר
//==============================================================================

{ TCnSampleMenuWizard }

procedure TCnTestParseTimeWizard.Config;
begin
  ShowMessage('Test option.');
  { TODO -oAnyone : ڴʾô }
end;

destructor TCnTestParseTimeWizard.Destroy;
begin

  inherited;
end;

procedure TCnTestParseTimeWizard.Execute;
var
  Tick: Cardinal;
  EditView: IOTAEditView;
  Stream: TMemoryStream;
  Parser: TCnPasStructureParser;
  I: Integer;
  List: TList;
  P: PCnTestRecord;
  AControl: TControl;
  Str: AnsiString;
  WStr: string;
begin
  Stream := TMemoryStream.Create;
  Parser := TCnPasStructureParser.Create;
  try
    EditView := CnOtaGetTopMostEditView;
    CnOtaSaveEditorToStream(EditView.Buffer, Stream);
    // ǰʾԴļʱ
    Tick := GetTickCount;
    Parser.ParseSource(PAnsiChar(Stream.Memory),
      IsDpr(EditView.Buffer.FileName), True);
    Tick := GetTickCount - Tick;
  finally
    Parser.Free;
    Stream.Free;
  end;

  ShowMessage('Parse Time: ' + IntToStr(Tick));

  List := TObjectList.Create(True);
  Tick := GetTickCount;
  for I := 0 to 100000 - 1 do
    List.Add(TCnPasToken.Create);

  Tick := GetTickCount - Tick;

  ShowMessage('Create TCnPasToken 100000 Time: ' + IntToStr(Tick));
  List.Free;

  List := TObjectList.Create(True);
  Tick := GetTickCount;
  for I := 0 to 100000 - 1 do
    List.Add(TCnTestToken.Create);
  Tick := GetTickCount - Tick;

  ShowMessage('Create TCnTestToken 100000 Time: ' + IntToStr(Tick));
  List.Free;

  List := TObjectList.Create(True);
  Tick := GetTickCount;
  for I := 0 to 100000 - 1 do
    List.Add(TObject.Create);
  Tick := GetTickCount - Tick;

  ShowMessage('Create TObject 100000 Time: ' + IntToStr(Tick));
  List.Free;

  List := TList.Create;
  Tick := GetTickCount;
  for I := 0 to 100000 - 1 do
  begin
    New(P);
    List.Add(P);
  end;
  Tick := GetTickCount - Tick;

  ShowMessage('New PCnTestRecord 100000 Time: ' + IntToStr(Tick));
  for I := 0 to 100000 - 1 do
    Dispose(List[I]);
  List.Free;

  Tick := GetTickCount;
  for I := 0 to 10000 - 1 do
  begin
    AControl := CnOtaGetCurrentEditControl;
    if AControl <> nil then
    begin
      Str := AnsiString(GetStrProp(AControl, 'LineText'));
      if Str = '' then
        Exit;
    end;
  end;
  Tick := GetTickCount - Tick;
  ShowMessage('AnsiString(GetStrProp(AControl, LineText)) 100000 Time: ' + IntToStr(Tick));

 {$IFDEF UNICODE}
  Tick := GetTickCount;
  for I := 0 to 10000 - 1 do
  begin
    AControl := CnOtaGetCurrentEditControl;
    if AControl <> nil then
    begin
      WStr := GetStrProp(AControl, 'LineText');
      if WStr = '' then
        Exit;
    end;
  end;
  Tick := GetTickCount - Tick;
  ShowMessage('Unicode GetStrProp(AControl, LineText) 100000 Time: ' + IntToStr(Tick));
 {$ENDIF}
end;

function TCnTestParseTimeWizard.GetCaption: string;
begin
  Result := 'Test Parse Time';
  { TODO -oAnyone : רҲ˵ı⣬ַбػ }
end;

function TCnTestParseTimeWizard.GetDefShortCut: TShortCut;
begin
  Result := 0;
  { TODO -oAnyone : ĬϵĿݼ }
end;

function TCnTestParseTimeWizard.GetHasConfig: Boolean;
begin
  Result := False;
  { TODO -oAnyone : רǷô }
end;

function TCnTestParseTimeWizard.GetHint: string;
begin
  Result := 'Test Parse Time of Current Unit';
  { TODO -oAnyone : רҲ˵ʾϢַбػ }
end;

function TCnTestParseTimeWizard.GetState: TWizardState;
begin
  Result := [wsEnabled];
  { TODO -oAnyone : רҲ˵״̬ɸָ趨 }
end;

class procedure TCnTestParseTimeWizard.GetWizardInfo(var Name, Author, Email, Comment: string);
begin
  Name := 'CnTestParseTimeWizard';
  Author := 'CnPack Team';
  Email := 'master@cnpack.org';
  Comment := 'Test Parse Time Wizard';
  { TODO -oAnyone : רҵơߡ估עַбػ }
end;

procedure TCnTestParseTimeWizard.LoadSettings(Ini: TCustomIniFile);
begin
  { TODO -oAnyone : ڴװרڲõĲרҴʱԶ }
end;

procedure TCnTestParseTimeWizard.SaveSettings(Ini: TCustomIniFile);
begin
  { TODO -oAnyone : ڴ˱רڲõĲרͷʱԶ }
end;

initialization
  RegisterCnWizard(TCnTestParseTimeWizard); // ער

end.
