{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnSrcEditorNav;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣ༭ǰչԪ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* Ԫʶ$Id$
* ޸ļ¼2013.08.05
*                BDS ֧
*           2005.01.03
*               Ԫԭ CnEditorEnhancements Ƴ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, ToolsAPI, IniFiles,
  Forms, ExtCtrls, Menus, ComCtrls, TypInfo, Math, CnCommon, ActnList, ImgList,
  {$IFDEF BDS}
  ActnMan,
  {$ENDIF}
  CnWizUtils, CnConsts, CnWizIdeUtils, CnWizConsts, CnMenuHook, CnWizNotifier,
  CnEditControlWrapper, CnWizShareImages, CnPopupMenu;

type

//==============================================================================
// ༭ǰչ
//==============================================================================

{ TCnSrcEditorNav }

  TCnSrcEditorNavMgr = class;

  TCnSrcEditorNav = class(TComponent)
  private
    FFileName: string;
    FLine: Integer;
    FUpdating: Boolean;
    FPause: Boolean;
    FNavMgr: TCnSrcEditorNavMgr;
    FEditControl: TControl;
    FOldBackMenu: Menus.TPopupMenu;
    FOldForwardMenu: Menus.TPopupMenu;
    FOldBackAction: TBasicAction;
    FOldForwardAction: TBasicAction;
    FOldImageList: TCustomImageList;
    FLastUpdateTick: Cardinal;
    FBackMenu: TPopupMenu;
    FForwardMenu: TPopupMenu;
    FBackAction: TAction;
    FForwardAction: TAction;
    FBackList: TStringList;
    FForwardList: TStringList;
    function ActionEnabled(AAction: TBasicAction): Boolean;
    function MenuEnabled(AMenu: Menus.TPopupMenu): Boolean;
    procedure DoMenuPopup(AMenu: Menus.TPopupMenu; AList: TStringList; AOnItem, AOnIDE:
      TNotifyEvent; const AIDECaption, AIDEListCaption: string; AOldAction:
      TBasicAction; AOldMenu: Menus.TPopupMenu);
    procedure BackMenuPopup(Sender: TObject);
    procedure ForwardMenuPopup(Sender: TObject);
    procedure BackMenuClick(Sender: TObject);
    procedure ForwardMenuClick(Sender: TObject);
    procedure OnIDEBack(Sender: TObject);
    procedure OnIDEForward(Sender: TObject);
    procedure OnIDEListClick(Sender: TObject);
    procedure OnPauseClick(Sender: TObject);
    procedure BackActionExecute(Sender: TObject);
    procedure ForwardActionExecute(Sender: TObject);
    procedure ActionUpdate(Sender: TObject);
    procedure GotoSourceLine(Idx: Integer; SrcList, DstList: TStringList);
    procedure AppIdle(Sender: TObject);
    procedure AddItem(AList: TStringList; const AFileName: string; ALine: Integer);
{$IFDEF BDS}
    function FindActionByNameFromActionManager(ActionManager: TActionManager; AName: string): TBasicAction;
{$ENDIF}
  protected
    procedure OnEnhConfig(Sender: TObject);
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Install;
    procedure Uninstall;
    procedure UpdateControls;
  end;

{ TCnSrcEditorNavMgr }

  TCnSrcEditorNavMgr = class(TObject)
  private
    FActive: Boolean;
    FList: TList;
    FExtendForwardBack: Boolean;
    FOnEnhConfig: TNotifyEvent;
    FMinLineDiff: Integer;
    FMaxItems: Integer;

    procedure EditControlNotify(EditControl: TControl; EditWindow: TCustomForm; 
      Operation: TOperation);
    procedure SetExtendForwardBack(const Value: Boolean);
  protected
    procedure SetActive(Value: Boolean); 
    procedure DoUpdateInstall(EditWindow: TCustomForm; EditControl: TControl;
      Context: Pointer);
    procedure DoEnhConfig;
  public
    constructor Create;
    destructor Destroy; override;

    procedure UpdateInstall;
{$IFDEF BDS}
    procedure DoUpdateInstallInAppBuilder(Sender: TObject);
    procedure FixButtonArrowInComplete(Sender: TObject);
{$ENDIF}
    procedure UpdateControls;

    procedure LoadSettings(Ini: TCustomIniFile);
    procedure SaveSettings(Ini: TCustomIniFile);
    procedure LanguageChanged(Sender: TObject);

    property ExtendForwardBack: Boolean read FExtendForwardBack write SetExtendForwardBack;
    property MinLineDiff: Integer read FMinLineDiff write FMinLineDiff;
    property MaxItems: Integer read FMaxItems write FMaxItems;
    property Active: Boolean read FActive write SetActive;
    property OnEnhConfig: TNotifyEvent read FOnEnhConfig write FOnEnhConfig;
  end;

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

const
  SBackToolButtonName = 'BackToolButton';
  SForwardToolButtonName = 'ForwardToolButton';
  SCnSrcEditorNavName = 'CnSrcEditorNav';
  SBrowserToolBarName = 'BrowserToolBar';
  SBackCommandActionName = 'BackCommand';
  SForwardCommandActionName = 'ForwardCommand';
  SBrowserToolBarImageListName = 'ImageList1';
  SIDEActionManagerName = 'ActionList1';

  SCnBackActionName = 'CnBackAction';
  SCnForwardActionName = 'CnForwardAction';
  csUpdateInterval = 100;

{ TCnSrcEditorNav }

constructor TCnSrcEditorNav.Create(AOwner: TComponent);
begin
  inherited;
  FBackMenu := TPopupMenu.Create(Self);
  FForwardMenu := TPopupMenu.Create(Self);
  FBackAction := TAction.Create(Self);
  FForwardAction := TAction.Create(Self);
  
  FBackMenu.OnPopup := BackMenuPopup;
  FForwardMenu.OnPopup := ForwardMenuPopup;
  FBackAction.OnExecute := BackActionExecute;
  FBackAction.OnUpdate := ActionUpdate;
  FBackAction.ImageIndex := 0;

  FBackAction.Name := SCnBackActionName;
  FForwardAction.OnExecute := ForwardActionExecute;
  FForwardAction.OnUpdate := ActionUpdate;
  FForwardAction.ImageIndex := 1;
  FForwardAction.Name := SCnForwardActionName;
  
  FBackList := TStringList.Create;
  FForwardList := TStringList.Create;

  CnWizNotifierServices.AddApplicationIdleNotifier(AppIdle);
end;

destructor TCnSrcEditorNav.Destroy;
begin
  CnWizNotifierServices.RemoveApplicationIdleNotifier(AppIdle);

  Uninstall;
  FBackList.Free;
  FForwardList.Free;
  FNavMgr.FList.Remove(Self);
  inherited;
end;

procedure TCnSrcEditorNav.AddItem(AList: TStringList;
  const AFileName: string; ALine: Integer);
begin
  if AFileName = '' then
    Exit;
    
  if (AList.Count > 0) and (AList[AList.Count - 1] = AFileName) and
    (Integer(AList.Objects[AList.Count - 1]) = ALine) then
    Exit;
    
  AList.AddObject(AFileName, TObject(ALine));
  UpdateControls;
end;

procedure TCnSrcEditorNav.AppIdle(Sender: TObject);
var
  View: IOTAEditView;

  function IsSelectingBlock: Boolean;
  var
    EPos, EPos1, EPos2: TOTAEditPos;
    CPos, CPos1, CPos2: TOTACharPos;
  begin
    Result := False;
    if View.Block.IsValid then
    begin
      EPos := View.CursorPos;
      View.ConvertPos(True, EPos, CPos);
      EPos1 := OTAEditPos(View.Block.StartingColumn, View.Block.StartingRow);
      EPos2 := OTAEditPos(View.Block.EndingColumn, View.Block.EndingRow);
      View.ConvertPos(True, EPos1, CPos1);
      View.ConvertPos(True, EPos2, CPos2);
      if (CPos.Line = CPos1.Line) and (CPos.CharIndex = CPos1.CharIndex) or
        (CPos.Line = CPos2.Line) and (CPos.CharIndex = CPos2.CharIndex) then
        Result := True;
    end;
  end;
begin
  if not FUpdating and not FPause and Assigned(Owner) and
    TCustomForm(Owner).Active then
  begin
    View := EditControlWrapper.GetEditView(FEditControl);
    if Assigned(View) then
    begin
      if FFileName = '' then
      begin
        FFileName := View.Buffer.FileName;
        FLine := View.CursorPos.Line;
      end
      else if (not SameText(View.Buffer.FileName, FFileName) or
        (Abs(View.CursorPos.Line - FLine) > FNavMgr.MinLineDiff)) and
        not IsSelectingBlock then
      begin
        AddItem(FBackList, FFileName, FLine);
        FFileName := View.Buffer.FileName;
        FLine := View.CursorPos.Line;
      end;
    end;
  end;
end;

procedure TCnSrcEditorNav.GotoSourceLine(Idx: Integer; SrcList, DstList:
  TStringList);
var
  i: Integer;
  AFileName: string;
  ALine: Integer;
  EditPos: TOTAEditPos;
begin
  if (Idx >= 0) and (Idx < SrcList.Count) then
  begin
    FUpdating := True;
    try
      AddItem(DstList, FFileName, FLine);

      AFileName := SrcList[Idx];
      ALine := Integer(SrcList.Objects[Idx]);
      for i := SrcList.Count - 1 downto Idx + 1 do
      begin
        AddItem(DstList, SrcList[i], Integer(SrcList.Objects[i]));
        SrcList.Delete(i);
      end;
      SrcList.Delete(Idx);

      CnOtaMakeSourceVisible(AFileName);
      EditPos.Col := 1;
      EditPos.Line := ALine;
      CnOtaGotoEditPos(EditPos, nil, True);
      FFileName := AFileName;
      FLine := ALine;
    finally
      FUpdating := False;
    end;
  end;
end;

procedure TCnSrcEditorNav.BackActionExecute(Sender: TObject);
begin
  if not FPause and (GetShiftState * [ssShift, ssAlt, ssCtrl] = []) and
    (FBackList.Count > 0) then
    GotoSourceLine(FBackList.Count - 1, FBackList, FForwardList)
  else
    OnIDEBack(nil);
end;

procedure TCnSrcEditorNav.ForwardActionExecute(Sender: TObject);
begin
  if not FPause and (GetShiftState * [ssShift, ssAlt, ssCtrl] = []) and
    (FForwardList.Count > 0) then
    GotoSourceLine(FForwardList.Count - 1, FForwardList, FBackList)
  else
    OnIDEForward(nil);
end;

procedure TCnSrcEditorNav.ActionUpdate(Sender: TObject);
begin
  if GetTickCount - FLastUpdateTick > csUpdateInterval then
  begin
    FBackAction.Enabled := (not FPause and (FBackList.Count > 0)) or
      MenuEnabled(FOldBackMenu);
    FForwardAction.Enabled := (not FPause and (FForwardList.Count > 0)) or
      MenuEnabled(FOldForwardMenu);
    FLastUpdateTick := GetTickCount;
  end;
end;

function TCnSrcEditorNav.ActionEnabled(AAction: TBasicAction): Boolean;
begin
  if AAction <> nil then
  begin
    if AAction is TCustomAction then
      Result := TCustomAction(AAction).Enabled
    else
      Result := True;
  end
  else
    Result := False;
end;

function TCnSrcEditorNav.MenuEnabled(AMenu: Menus.TPopupMenu): Boolean;
begin
  if AMenu <> nil then
  begin
    AMenu.OnPopup(AMenu);
    Result := AMenu.Items.Count > 0;
  end
  else
    Result := False;
end;

procedure TCnSrcEditorNav.DoMenuPopup(AMenu: Menus.TPopupMenu; AList: TStringList;
  AOnItem, AOnIDE: TNotifyEvent; const AIDECaption, AIDEListCaption: string; 
  AOldAction: TBasicAction; AOldMenu: Menus.TPopupMenu);
var
  i: Integer;
  Item: TMenuItem;
begin
  AMenu.Items.Clear;

  if ActionEnabled(AOldAction) and MenuEnabled(AOldMenu) then
  begin
    AddMenuItem(AMenu.Items, AIDECaption, AOnIDE);
    Item := AddMenuItem(AMenu.Items, AIDEListCaption, nil);
    for i := 0 to AOldMenu.Items.Count - 1 do
      with AOldMenu.Items[i] do
      begin
        AddMenuItem(Item, Caption, OnIDEListClick, nil, ShortCut, Hint,
          Integer(AOldMenu.Items[i]));
      end;
    AddSepMenuItem(AMenu.Items);
  end;

  for i := AList.Count - 1 downto 0 do
    AddMenuItem(AMenu.Items, Format('%s %d', [AList[i],
      Integer(AList.Objects[i])]), AOnItem, nil, 0, '', i);

  AddSepMenuItem(AMenu.Items);
  AddMenuItem(AMenu.Items, SCnSrcEditorNavPause, OnPauseClick).Checked := FPause;
  AddMenuItem(AMenu.Items, SCnEditorEnhanceConfig, OnEnhConfig);
end;

procedure TCnSrcEditorNav.BackMenuPopup(Sender: TObject);
begin
  DoMenuPopup(FBackMenu, FBackList, BackMenuClick, OnIDEBack,
    SCnSrcEditorNavIDEBack, SCnSrcEditorNavIDEBackList, FOldBackAction,
    FOldBackMenu);
end;

procedure TCnSrcEditorNav.ForwardMenuPopup(Sender: TObject);
begin
  DoMenuPopup(FForwardMenu, FForwardList, ForwardMenuClick, OnIDEForward,
    SCnSrcEditorNavIDEForward, SCnSrcEditorNavIDEForwardList, FOldForwardAction,
    FOldForwardMenu);
end;

procedure TCnSrcEditorNav.BackMenuClick(Sender: TObject);
begin
  if Sender is TMenuItem then
    GotoSourceLine(TMenuItem(Sender).Tag, FBackList, FForwardList);
end;

procedure TCnSrcEditorNav.ForwardMenuClick(Sender: TObject);
begin
  if Sender is TMenuItem then
    GotoSourceLine(TMenuItem(Sender).Tag, FForwardList, FBackList);
end;

procedure TCnSrcEditorNav.OnIDEBack(Sender: TObject);
begin
  if ActionEnabled(FOldBackAction) then
  begin
    Uninstall;
    try
      FOldBackAction.Execute;
    finally
      Install;
    end;
  end;
end;

procedure TCnSrcEditorNav.OnIDEForward(Sender: TObject);
begin
  if ActionEnabled(FOldForwardAction) then
  begin
    Uninstall;
    try
      FOldForwardAction.Execute;
    finally
      Install;
    end;
  end;
end;

procedure TCnSrcEditorNav.OnIDEListClick(Sender: TObject);
begin
  if Sender is TMenuItem then
  begin
    Uninstall;
    try
      TMenuItem(TMenuItem(Sender).Tag).Click;
    finally
      Install;
    end;
  end;
end;

procedure TCnSrcEditorNav.OnPauseClick(Sender: TObject);
begin
  FPause := not FPause;
end;

procedure TCnSrcEditorNav.Install;
var
  BackButton: TToolButton;
  ForwardButton: TToolButton;
{$IFDEF BDS}
  BrowserToolbar: TToolBar;
{$ENDIF}
begin
  if Assigned(Owner) then
  begin
    BackButton := TToolButton(Owner.FindComponent(SBackToolButtonName));
    if Assigned(BackButton) and (BackButton.Action <> FBackAction) then
    begin
      FOldImageList := TToolBar(BackButton.Parent).Images;
      TToolBar(BackButton.Parent).Images := dmCnSharedImages.ilBackForward;
      FOldBackAction := BackButton.Action;
      FOldBackMenu := BackButton.DropdownMenu;
      BackButton.Action := FBackAction;
      BackButton.DropdownMenu := FBackMenu;
    end;

    ForwardButton := TToolButton(Owner.FindComponent(SForwardToolButtonName));
    if Assigned(ForwardButton) and (ForwardButton.Action <> FForwardAction) then
    begin
      FOldForwardAction := ForwardButton.Action;
      FOldForwardMenu := ForwardButton.DropdownMenu;
      ForwardButton.Action := FForwardAction;
      ForwardButton.DropdownMenu := FForwardMenu;
    end;

{$IFDEF BDS}
    if (BackButton = nil) and (ForwardButton = nil) then
    begin
      // In AppBuilder, install it to Toolbar.
      BrowserToolbar := TToolBar(Owner.FindComponent(SBrowserToolBarName));
      if BrowserToolbar <> nil then
      begin
{$IFDEF DEBUG}
        CnDebugger.LogMsg('TCnSrcEditorNav.Install. Got BrowserToolbar.');
{$ENDIF}
        BackButton := BrowserToolbar.Buttons[0];
        ForwardButton := BrowserToolbar.Buttons[1];

        if Assigned(BackButton) and (BackButton.Action <> FBackAction) then
        begin
          FOldImageList := TToolBar(BackButton.Parent).Images;
          TToolBar(BackButton.Parent).Images := dmCnSharedImages.ilBackForwardBDS;

          FOldBackAction := BackButton.Action;
          FOldBackMenu := BackButton.DropdownMenu;
          BackButton.Action := FBackAction;
          BackButton.DropdownMenu := FBackMenu;
        end;

        if Assigned(ForwardButton) and (ForwardButton.Action <> FForwardAction) then
        begin
          FOldForwardAction := ForwardButton.Action;
          FOldForwardMenu := ForwardButton.DropdownMenu;
          ForwardButton.Action := FForwardAction;
          ForwardButton.DropdownMenu := FForwardMenu;
        end;
{$IFDEF DEBUG}
        CnDebugger.LogMsg('TCnSrcEditorNav.Install. Buttons Hooked.');
{$ENDIF}
      end;
    end;
{$ENDIF}
  end;
end;

procedure TCnSrcEditorNav.Uninstall;
var
  BackButton: TToolButton;
  ForwardButton: TToolButton;
{$IFDEF BDS}
  BrowserToolbar: TToolBar;
  ActionMgr: TActionManager;
{$ENDIF}
begin
  if Assigned(Owner) then
  begin
    BackButton := TToolButton(Owner.FindComponent(SBackToolButtonName));
    if Assigned(BackButton) and (BackButton.Action = FBackAction) then
    begin
      TToolBar(BackButton.Parent).Images := FOldImageList;
      BackButton.Action := FOldBackAction;
      BackButton.DropdownMenu := FOldBackMenu;
    end;

    ForwardButton := TToolButton(Owner.FindComponent(SForwardToolButtonName));
    if Assigned(ForwardButton) and (ForwardButton.Action = FForwardAction) then
    begin
      ForwardButton.Action := FOldForwardAction;
      ForwardButton.DropdownMenu := FOldForwardMenu;
    end;

{$IFDEF BDS}
    if (BackButton = nil) and (ForwardButton = nil) then
    begin
      // In AppBuilder, uninstall it from Toolbar.
      BrowserToolbar := TToolBar(Owner.FindComponent(SBrowserToolBarName));
      if BrowserToolbar <> nil then
      begin
{$IFDEF DEBUG}
        CnDebugger.LogMsg('TCnSrcEditorNav.UnInstall. Got BrowserToolbar.');
{$ENDIF}
        BackButton := BrowserToolbar.Buttons[0];
        ForwardButton := BrowserToolbar.Buttons[1];

        ActionMgr := TActionManager(Owner.FindComponent(SIDEActionManagerName));
        if ActionMgr <> nil then
        begin
          if Assigned(BackButton) and (BackButton.Action = FBackAction) then
          begin
            TToolBar(BackButton.Parent).Images := TImageList(Owner.FindComponent(SBrowserToolBarImageListName));

            BackButton.Action := FindActionByNameFromActionManager(ActionMgr, SBackCommandActionName);
            BackButton.DropdownMenu := FOldBackMenu;
          end;

          if Assigned(ForwardButton) and (ForwardButton.Action = FForwardAction) then
          begin
            ForwardButton.Action := FindActionByNameFromActionManager(ActionMgr, SForwardCommandActionName);
            ForwardButton.DropdownMenu := FOldForwardMenu;
          end;
        end;
      end;
    end;
{$ENDIF}
  end;
end;

procedure TCnSrcEditorNav.UpdateControls;
begin
  while (FBackList.Count > 0) and (FBackList.Count > FNavMgr.MaxItems) do
    FBackList.Delete(0);
  while (FForwardList.Count > 0) and (FForwardList.Count > FNavMgr.MaxItems) do
    FForwardList.Delete(0);
end;

procedure TCnSrcEditorNav.OnEnhConfig(Sender: TObject);
begin
  FNavMgr.DoEnhConfig;
end;

procedure TCnSrcEditorNav.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;
  if Operation = opRemove then
  begin
    if AComponent = FOldBackMenu then
      FOldBackMenu := nil
    else if AComponent = FOldForwardMenu then
      FOldForwardMenu := nil
    else if AComponent = FOldBackAction then
      FOldBackAction := nil
    else if AComponent = FOldForwardAction then
      FOldForwardAction := nil;
  end;
end;

{$IFDEF BDS}

function TCnSrcEditorNav.FindActionByNameFromActionManager(
  ActionManager: TActionManager; AName: string): TBasicAction;
var
  I: Integer;
begin
  Result := nil;
  if ActionManager = nil then
    Exit;

  for I := 0 to ActionManager.ActionCount - 1 do
  begin
    if ActionManager.Actions[I].Name = AName then
    begin
      Result := ActionManager.Actions[I];
      Exit;
    end;
  end;
end;

{$ENDIF}

{ TCnSrcEditorNavMgr }

constructor TCnSrcEditorNavMgr.Create;
begin
  inherited;
  FMinLineDiff := 5;
  FMaxItems := 20;
  FExtendForwardBack := True;
  FActive := True;
  FList := TList.Create;
  
  EditControlWrapper.AddEditControlNotifier(EditControlNotify);
  UpdateInstall;
end;

destructor TCnSrcEditorNavMgr.Destroy;
var
  i: Integer;
begin
  EditControlWrapper.RemoveEditControlNotifier(EditControlNotify);
  for i := FList.Count - 1 downto 0 do
    TCnSrcEditorNav(FList[i]).Free;
  FList.Free;
  inherited;
end;

procedure TCnSrcEditorNavMgr.DoUpdateInstall(EditWindow: TCustomForm;
  EditControl: TControl; Context: Pointer);
var
  EditorNav: TCnSrcEditorNav;
begin
  EditorNav := TCnSrcEditorNav(FindComponentByClass(EditWindow,
    TCnSrcEditorNav, SCnSrcEditorNavName));
  if Active and ExtendForwardBack then
  begin
    if not Assigned(EditorNav) then
    begin
      EditorNav := TCnSrcEditorNav.Create(EditWindow);
      EditorNav.Name := SCnSrcEditorNavName;
      EditorNav.FNavMgr := Self;
      EditorNav.FEditControl := EditControl;
      EditorNav.Install;
      FList.Add(EditorNav);
    end;
  end
  else if Assigned(EditorNav) then
  begin
    EditorNav.Free;
  end;
end;

{$IFDEF BDS}

procedure TCnSrcEditorNavMgr.DoUpdateInstallInAppBuilder(Sender: TObject);
var
  EditorNav: TCnSrcEditorNav;
begin
  EditorNav := TCnSrcEditorNav(FindComponentByClass(GetIdeMainForm,
    TCnSrcEditorNav, SCnSrcEditorNavName));
  if Active and ExtendForwardBack then
  begin
    if not Assigned(EditorNav) then
    begin
      EditorNav := TCnSrcEditorNav.Create(GetIdeMainForm);
      EditorNav.Name := SCnSrcEditorNavName;
      EditorNav.FNavMgr := Self;
      EditorNav.FEditControl := nil;
      EditorNav.Install;
      FList.Add(EditorNav);

      CnWizNotifierServices.ExecuteOnApplicationIdle(FixButtonArrowInComplete);
    end;
  end
  else if Assigned(EditorNav) then
  begin
    EditorNav.Free;
  end;
end;

procedure TCnSrcEditorNavMgr.FixButtonArrowInComplete(Sender: TObject);
var
  EditorNav: TCnSrcEditorNav;
  BrowserToolbar: TToolBar;
  ToolbarParent: TWinControl;
  P: TPoint;
begin
  if Active and ExtendForwardBack then
  begin
    EditorNav := TCnSrcEditorNav(FindComponentByClass(GetIdeMainForm,
      TCnSrcEditorNav, SCnSrcEditorNavName));
    if EditorNav <> nil then
    begin
      // Send Drag Message to Fix its Icon Showing Problem.
      BrowserToolbar := TToolBar(EditorNav.Owner.FindComponent(SBrowserToolBarName));
      if BrowserToolbar <> nil then
      begin
        ToolbarParent := BrowserToolbar.Parent;
        if ToolbarParent <> nil then
        begin
          P.X := 5;
          P.Y := BrowserToolbar.Height div 2;
          P := BrowserToolbar.ClientToParent(P);

          SendMessage(ToolbarParent.Handle, WM_LBUTTONDOWN, 0, MakeLParam(P.X, P.Y));
          SendMessage(ToolbarParent.Handle, WM_LBUTTONUP, 0, MakeLParam(P.X, P.Y));
        end;
      end;
    end;
  end;
end;

{$ENDIF}

procedure TCnSrcEditorNavMgr.UpdateInstall;
begin
  EnumEditControl(DoUpdateInstall, nil);
{$IFDEF BDS}
  //  Idle ΪһִеʱBDS е Button ڵĹû
  CnWizNotifierServices.ExecuteOnApplicationIdle(DoUpdateInstallInAppBuilder);
{$ENDIF}
  UpdateControls;
end;

procedure TCnSrcEditorNavMgr.EditControlNotify(EditControl: TControl; EditWindow:
  TCustomForm; Operation: TOperation);
begin
  if Operation = opInsert then
    UpdateInstall;
end;

procedure TCnSrcEditorNavMgr.UpdateControls;
var
  i: Integer;
begin
  for i := 0 to FList.Count - 1 do
    TCnSrcEditorNav(FList[i]).UpdateControls;
end;

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------

const
  csEditorNav = 'EditorNav';
  csExtendForwardBack = 'ExtendForwardBack';
  csMinLineDiff = 'MinLineDiff';
  csMaxItems = 'MaxItems';

procedure TCnSrcEditorNavMgr.LoadSettings(Ini: TCustomIniFile);
begin
  FExtendForwardBack := Ini.ReadBool(csEditorNav, csExtendForwardBack, True);
  FMinLineDiff := Ini.ReadInteger(csEditorNav, csMinLineDiff, FMinLineDiff);
  FMaxItems := Ini.ReadInteger(csEditorNav, csMaxItems, FMaxItems);
end;

procedure TCnSrcEditorNavMgr.SaveSettings(Ini: TCustomIniFile);
begin
  Ini.WriteBool(csEditorNav, csExtendForwardBack, FExtendForwardBack);
  Ini.WriteInteger(csEditorNav, csMinLineDiff, FMinLineDiff);
  Ini.WriteInteger(csEditorNav, csMaxItems, FMaxItems);
end;

procedure TCnSrcEditorNavMgr.DoEnhConfig;
begin
  if Assigned(FOnEnhConfig) then
    FOnEnhConfig(Self);
end;

procedure TCnSrcEditorNavMgr.LanguageChanged(Sender: TObject);
begin

end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

procedure TCnSrcEditorNavMgr.SetActive(Value: Boolean);
begin
  if FActive <> Value then
  begin
    FActive := Value;
    UpdateInstall;
  end;
end;

procedure TCnSrcEditorNavMgr.SetExtendForwardBack(const Value: Boolean);
begin
  if FExtendForwardBack <> Value then
  begin
    FExtendForwardBack := Value;
    UpdateInstall;
  end;
end;

end.
