{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnFormEnhancements;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣչԪ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* Ԫʶ$Id$
* ޸ļ¼2012.09.19 by shenloqi
*               ֲDelphi XE3
*           2007.01.11 by ܾ
*               ʹ CnWizControlHook Ԫ CallWndProcRet Hook
*               ʵָ Visible ԣĳЩ´ʾ
*           2004.12.03 by ܾ
*               Ľֶ֧๤
*           2004.05.21 by chinbo(shenloqi)
*               谴ťλôλ
*           2003.10.04 by (QSoft)
*               ʾʱ"Edit"д󲿷ֲ˵ʹ
*           2003.09.29 by (QSoft)
*               CnWizNotifier Application OnIdle ֪ͨBUG
*           2003.09.28 by (QSoft)
*               D7µClose All޷ظ⣬ͨҽ
*               Application  OnIdle ¼⣬D5¸Ѿ
*               ֽܾ
*           2003.09.25
*               ﴦ
*           2003.06.24
*               չרҸĳרעķʽ
*           2003.06.07
*               Ļұ߼·Ĵͣ
*           2003.05.04
*               岻֧ TFrame 
*           2003.05.02
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNFORMENHANCEWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, ToolsAPI, IniFiles,
  Forms, ExtCtrls, Menus, ComCtrls, StdCtrls, Contnrs, ActnList, Buttons, Math,
  ImgList, Dialogs,
  {$IFDEF DelphiXE3_UP}Actions,{$ENDIF}
  CnCommon, CnWizUtils, CnWizNotifier, CnWizIdeUtils,
  CnWizConsts, CnConsts, CnWizClasses, CnWizOptions, CnFlatToolbarConfigFrm,
  CnWizManager, CnWizMultiLang, CnSpin, TypInfo, CnPopupMenu, CnDesignEditorUtils,
  CnWizIni;

const
  WM_PROPBARMODIFIED = WM_USER + $382;

type

//==============================================================================
// 帡ؼ
//==============================================================================

{ TCnFloatSnapPanel }

  TSnapPos = (spTopLeft, spTopRight, spBottomLeft, spBottomRight, spLeftTop,
    spLeftBottom, spRightTop, spRightBottom);

  TCnFloatSnapPanel = class(TWinControl)
  private
    FAllowDrag: Boolean;
    FMouseDown: Boolean;
    FOldX: Integer;
    FOldY: Integer;
    FOffsetX: Integer;
    FOffsetY: Integer;
    FSnapForm: TCustomForm;
    FSnapPos: TSnapPos;
    FPosMenu: TMenuItem;
    FDragMenu: TMenuItem;
    FAllowShow: Boolean;
    procedure PaintBoxPaint(Sender: TObject);
    procedure PaintMouseDown(Sender: TObject; Button: TMouseButton; Shift:
      TShiftState; X, Y: Integer);
    procedure PaintBoxMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure PaintBoxMouseUp(Sender: TObject; Button: TMouseButton; Shift:
      TShiftState; X, Y: Integer);
    function GetVisible: Boolean;
    procedure SetVisible(const Value: Boolean);
    procedure SetAllowDrag(const Value: Boolean);
    procedure SetOffsetX(const Value: Integer);
    procedure SetOffsetY(const Value: Integer);
    procedure SetSnapPos(const Value: TSnapPos);
    procedure SetSnapForm(const Value: TCustomForm);
    procedure SetAllowShow(const Value: Boolean);
  protected
    PaintBox: TPaintBox;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure InitPopupMenu; virtual;
    function CanShow: Boolean; virtual;
    procedure SnapPosChanged(OldPos: TSnapPos); virtual;
    function IsVertical: Boolean; virtual;
    procedure SetPos(X, Y: Integer; hWndInsertAfter: HWND); virtual;
    procedure AlignSubControls; virtual;
    procedure OnMenuPopup(Sender: TObject); virtual;
    procedure OnMenuClose(Sender: TObject); virtual;
    procedure OnMenuSnapPos(Sender: TObject); virtual;
    procedure OnMenuAllowDrag(Sender: TObject); virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show; virtual;
    procedure Hide; virtual;
    procedure UpdatePosition; virtual;
    procedure UpdateVisible; virtual;
    procedure LoadSettings(Ini: TCustomIniFile); virtual;
    procedure SaveSettings(Ini: TCustomIniFile); virtual;
    procedure LanguageChanged(Sender: TObject); virtual;
    procedure UpdateActions; virtual;

    property AllowDrag: Boolean read FAllowDrag write SetAllowDrag;
    property AllowShow: Boolean read FAllowShow write SetAllowShow;
    property SnapPos: TSnapPos read FSnapPos write SetSnapPos;
    property OffsetX: Integer read FOffsetX write SetOffsetX;
    property OffsetY: Integer read FOffsetY write SetOffsetY;
    property SnapForm: TCustomForm read FSnapForm write SetSnapForm;
    property Visible: Boolean read GetVisible write SetVisible;
  end;

//==============================================================================
// 帡ؼ
//==============================================================================

{ TCnWizFloatButtonActionLink }

  TCnWizFloatButton = class;

{$IFNDEF BDS}
  TSpeedButtonActionLink = TControlActionLink;
{$ENDIF}

  TCnWizFloatButtonActionLink = class(TSpeedButtonActionLink)
  protected
    FClient: TCnWizFloatButton;
    procedure AssignClient(AClient: TObject); override;
    procedure SetChecked(Value: Boolean); override;
  end;

{ TCnWizFloatButton }

  TCnWizFloatButton = class(TSpeedButton)
  protected
    function GetActionLinkClass: TControlActionLinkClass; override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  end;

{ TCnFormFloatToolBar }

  TCnFormEnhanceWizard = class;

  TCnFormFloatToolBar = class(TCnFloatSnapPanel)
  private
    FVertOrder: Boolean;
    FLineCount: Integer;
    FActions: TStringList;
    FLastDataName: string;
    procedure SetLineCount(const Value: Integer);
    procedure SetVertOrder(const Value: Boolean);
    procedure OnMenuCustomize(Sender: TObject);
    procedure OnMenuConfig(Sender: TObject);
    procedure OnMenuExport(Sender: TObject);
    procedure OnMenuImport(Sender: TObject);
    function GetActionFileName: string;
  protected
    Panel: TPanel;
    Wizard: TCnFormEnhanceWizard;
    procedure RecreateButtons;
    procedure InitPopupMenu; override;
    procedure AlignSubControls; override;
    function CanShow: Boolean; override;
    procedure SnapPosChanged(OldPos: TSnapPos); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure LoadSettings(Ini: TCustomIniFile); override;
    procedure SaveSettings(Ini: TCustomIniFile); override;
    procedure SaveActions(FileName: string = '');
    procedure LoadActions(FileName: string = '');
    procedure LanguageChanged(Sender: TObject); override;
    function ExportToFile: Boolean;
    function ImportFromFile: Boolean;
    procedure Customize;
    procedure UpdateActions; override;
    
    property LineCount: Integer read FLineCount write SetLineCount;
    property VertOrder: Boolean read FVertOrder write SetVertOrder;
    property Actions: TStringList read FActions;
    property ActionFileName: string read GetActionFileName;
  end;

//==============================================================================
// 帡༭ؼ
//==============================================================================

  TCnValueComboBox = class(TCnToolBarComboBox)
  private
    FOwnerDrawList: Boolean;
    FOnKillFocus: TNotifyEvent;
    procedure SetOwnerDrawList(const Value: Boolean);
    procedure WMMouseWheel(var Message: TWMMouseWheel); message WM_MOUSEWHEEL;
  protected
    procedure ComboWndProc(var Message: TMessage; ComboWnd: HWnd;
      ComboProc: Pointer); override;
    procedure CreateParams(var Params: TCreateParams); override;
    property OwnerDrawList: Boolean read FOwnerDrawList write SetOwnerDrawList;
    property OnKillFocus: TNotifyEvent read FOnKillFocus write FOnKillFocus;
  end;

  TCnFormFloatPropBar = class(TCnFloatSnapPanel)
  private
    FFreqProp: TStringList;
    FIsFilter: Boolean;
    FUpdating: Boolean;
    FDsnForm: TCustomForm;
    FSelection: TList;
    FNameCombo: TCnToolBarComboBox;
    FValueCombo: TCnValueComboBox;
    FStringButton: TSpeedButton;
    FFreqButton: TSpeedButton;
    FRenameButton: TSpeedButton;
    FNameComboWidth: Integer;
    FValueComboWidth: Integer;
    FUseHistory: Boolean;
    FSaveValue: string;
    FStrCaption: string;
    FIsSetProp: Boolean;
    FTypeInfo: PTypeInfo;
    FSetValue: TIntegerSet;
    procedure OnDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure OnMeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure OnDropDown(Sender: TObject);
    function IsBoolType(PInfo: PTypeInfo): Boolean;
    function CanRename: Boolean;
    procedure OnMenuConfig(Sender: TObject);
    procedure OnRename(Sender: TObject);
    procedure OnFreq(Sender: TObject);
    procedure OnNameClick(Sender: TObject);
    procedure OnKeyPress(Sender: TObject; var Key: Char);
    procedure OnNameKeyPress(Sender: TObject; var Key: Char);
    procedure OnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure OnKillFocus(Sender: TObject);
    procedure OnValueClick(Sender: TObject);
    procedure OnButtonClick(Sender: TObject);
    function GetSelection(Index: Integer): TPersistent;
    function GetSelectionCount: Integer;
    procedure UpdateControls;
    procedure UpdateProperty(TextOnly: Boolean);
    procedure ModifyProperty(BySelectItem: Boolean);
    function GetWizard: TCnBaseWizard;
    procedure WMModified(var Msg: TMessage); message WM_PROPBARMODIFIED;
    procedure SetIsSetProp(const Value: Boolean);
  protected
    Panel: TPanel;
    procedure RecreateControls;
    procedure InitPopupMenu; override;
    procedure AlignSubControls; override;
    function CanShow: Boolean; override;
    function IsVertical: Boolean; override;
    function Modified: Boolean;
    property Wizard: TCnBaseWizard read GetWizard;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure LoadSettings(Ini: TCustomIniFile); override;
    procedure SaveSettings(Ini: TCustomIniFile); override;
    procedure LanguageChanged(Sender: TObject); override;
    procedure UpdateActions; override;
    property Selections[Index: Integer]: TPersistent read GetSelection;
    property SelectionCount: Integer read GetSelectionCount;
    property DsnForm: TCustomForm read FDsnForm;
    property IsSetProp: Boolean read FIsSetProp write SetIsSetProp;
  end;

//==============================================================================
// չ
//==============================================================================

{ TCnFormEnhanceWizard }

  TCnFormEnhanceWizard = class(TCnIDEEnhanceWizard)
  private
    FUpdating: Boolean;
    FList: TObjectList;
    FPropBar: TCnFormFloatPropBar;
    FDefCount: Integer;
    FIsEmbeddedDesigner: Boolean;
    FLastUpdateTick: Cardinal;
    function GetFlatToolBar(Index: Integer): TCnFormFloatToolBar;
    function GetFlatToolBarCount: Integer;
  protected
    procedure SetActive(Value: Boolean); override;
    function GetHasConfig: Boolean; override;

    procedure UpdateFlatPanelsPosition;
    procedure OnAppMessage(var Msg: TMsg; var Handled: Boolean);
    procedure OnCallWndProcRet(hwnd: HWND; Control: TWinControl; Msg: TMessage);
    procedure FormEditorNotify(FormEditor: IOTAFormEditor;
      NotifyType: TCnWizFormEditorNotifyType; ComponentHandle: TOTAHandle;
      Component: TComponent; const OldName, NewName: string);
    procedure ActiveFormChanged(Sender: TObject);
    procedure ExecOnIdle(Sender: TObject);
    procedure ApplicationIdle(Sender: TObject);
  public
    constructor Create; override;
    destructor Destroy; override;

    function GetFlatPanelFileName(Index: Integer): string;
    function AddFlatToolBar: TCnFormFloatToolBar;
    procedure RemoveFlatToolBar(FlatToolBar: TCnFormFloatToolBar);
    procedure CleanDataFile;
    procedure RestoreDefault;

    procedure Config; override;
    procedure LoadSettings(Ini: TCustomIniFile); override;
    procedure SaveSettings(Ini: TCustomIniFile); override;
    procedure LanguageChanged(Sender: TObject); override;
    class procedure GetWizardInfo(var Name, Author, Email, Comment: string); override;

    property PropBar: TCnFormFloatPropBar read FPropBar;
    property FlatToolBars[Index: Integer]: TCnFormFloatToolBar read GetFlatToolBar;
    property FlatToolBarCount: Integer read GetFlatToolBarCount;
    property IsEmbeddedDesigner: Boolean read FIsEmbeddedDesigner;
  end;

//==============================================================================
// ô
//==============================================================================

{ TCnFormEnhanceConfigForm }

  TCnFormEnhanceConfigForm = class(TCnTranslateForm)
    grpFlatPanel: TGroupBox;
    cbbSnapPos: TComboBox;
    btnCustomize: TButton;
    btnExport: TButton;
    btnImport: TButton;
    btnClose: TButton;
    btnHelp: TButton;
    ListView: TListView;
    btnAdd: TButton;
    btnDelete: TButton;
    btnDefault: TButton;
    rbAllowDrag: TRadioButton;
    rbAutoSnap: TRadioButton;
    Label1: TLabel;
    seOffsetX: TCnSpinEdit;
    Label2: TLabel;
    seOffsetY: TCnSpinEdit;
    Label3: TLabel;
    Label4: TLabel;
    edtName: TEdit;
    cbAllowShow: TCheckBox;
    grp1: TGroupBox;
    lbl3: TLabel;
    lbl4: TLabel;
    lbl5: TLabel;
    cbbSnapPosPropBar: TComboBox;
    rbAllowDragPropBar: TRadioButton;
    rbAutoSnapPropBar: TRadioButton;
    sePropBarX: TCnSpinEdit;
    sePropBarY: TCnSpinEdit;
    chkShowPropBar: TCheckBox;
    lbl6: TLabel;
    mmoFreq: TMemo;
    lbl1: TLabel;
    lbl2: TLabel;
    seNameWidth: TCnSpinEdit;
    seValueWidth: TCnSpinEdit;
    procedure UpdateControls(Sender: TObject);
    procedure btnCustomizeClick(Sender: TObject);
    procedure btnExportClick(Sender: TObject);
    procedure btnImportClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure ListViewSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure btnDefaultClick(Sender: TObject);
  private
    { Private declarations }
    FUpdating: Boolean;
    procedure InitControls;
    procedure UpdateListView;
    procedure GetFromControl;
    procedure SetToControl;
    function CurrItem: TCnFormFloatToolBar;
  protected
    Wizard: TCnFormEnhanceWizard;
    function GetHelpTopic: string; override;
  public
    { Public declarations }
  end;

{$ENDIF CNWIZARDS_CNFORMENHANCEWIZARD}

implementation

{$IFDEF CNWIZARDS_CNFORMENHANCEWIZARD}

{$R *.dfm}

uses
{$IFDEF DEBUG}
  CnDebug,
{$ENDIF}
  CnWizShareImages, CnPrefixExecuteFrm, CnDesignEditorConsts,
  CnMultiLineEditorFrm;

const
  csButtonWidth = 20;
  csButtonHeight = 20;
  csTitleWidth = 12;
  csUpdateInterval = 100;

var
  csFlatFormPosCaptions: array[TSnapPos] of PString =
    (@SCnMenuFlatPanelTopLeft, @SCnMenuFlatPanelTopRight,
    @SCnMenuFlatPanelBottomLeft, @SCnMenuFlatPanelBottomRight,
    @SCnMenuFlatPanelLeftTop, @SCnMenuFlatPanelLeftBottom,
    @SCnMenuFlatPanelRightTop, @SCnMenuFlatPanelRightBottom);

const
  csPanel = 'Panel';
  csPropBar = 'PropBar';
  csPropBarHistory = 'PropBarHistory';
  csAllowDrag = 'AllowDrag';
  csAllowShow = 'AllowShow';
  csSnapPos = 'SnapPos';
  csOffsetX = 'OffsetX';
  csOffsetY = 'OffsetY';
  csLeft = 'Left';
  csTop = 'Top';
  csCaption = 'Caption';
  csCount = 'Count';
  csPropBarHeight = 20;
  csNameComboWidth = 'NameComboWidth';
  csValueComboWidth = 'ValueComboWidth';
  csIsFilter = 'IsFilter';
  csMaxEnumCount = 255;
  IdxRename = 86;
  IdxFreq = 87;
  
  csTypeInfoSimple = [tkInteger, tkChar, tkEnumeration, tkFloat, tkString,
    tkWChar, tkLString, tkWString, tkSet, tkVariant, tkInt64{$IFDEF UNICODE_STRING}, tkUString{$ENDIF}];

  csTypeInfoHistory = [tkInteger, tkChar, tkFloat, tkString, tkWChar,
    tkLString, tkWString, tkVariant, tkInt64{$IFDEF UNICODE_STRING}, tkUString{$ENDIF}];

//==============================================================================
// 帡ؼ
//==============================================================================

{ TCnFloatSnapPanel }

constructor TCnFloatSnapPanel.Create(AOwner: TComponent);
begin
  inherited;
  PopupMenu := TPopupMenu.Create(Self);

  PaintBox := TPaintBox.Create(Self);
  PaintBox.Width := csTitleWidth;
  PaintBox.Parent := Self;
  PaintBox.Align := alLeft;
  PaintBox.PopupMenu := PopupMenu;
  PaintBox.OnPaint := PaintBoxPaint;
  PaintBox.OnMouseDown := PaintMouseDown;
  PaintBox.OnMouseMove := PaintBoxMouseMove;
  PaintBox.OnMouseUp := PaintBoxMouseUp;

  InitPopupMenu;

  ParentWindow := Application.Handle;
  Visible := False;

  FAllowDrag := False;
  FAllowShow := True;
  FSnapPos := spTopLeft;
  FOffsetX := 0;
  FOffsetY := 0;
  FSnapForm := nil;
end;

procedure TCnFloatSnapPanel.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.WndParent := Application.Handle;
  Params.Style := Params.Style and not (WS_CHILD or WS_GROUP or WS_TABSTOP or
    WS_CAPTION or WS_BORDER or WS_DLGFRAME) or WS_POPUP;
  Params.ExStyle := WS_EX_TOOLWINDOW or WS_EX_WINDOWEDGE;
end;

procedure TCnFloatSnapPanel.CreateWnd;
begin
  inherited;
  CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
  AlignSubControls;
end;

destructor TCnFloatSnapPanel.Destroy;
begin
  inherited;
end;

//------------------------------------------------------------------------------
// ؼʼ
//------------------------------------------------------------------------------

procedure TCnFloatSnapPanel.InitPopupMenu;
var
  Pos: TSnapPos;
begin
  PopupMenu.Items.Clear;
  
  with PopupMenu do
  begin
    OnPopup := OnMenuPopup;

    AddMenuItem(Items, SCnMenuFlatFormCloseCaption, OnMenuClose);
    
    AddSepMenuItem(Items);
    
    FPosMenu := AddMenuItem(Items, SCnMenuFlagFormPosCaption);
    for Pos := Low(Pos) to High(Pos) do
    begin
      with AddMenuItem(FPosMenu, csFlatFormPosCaptions[Pos]^, OnMenuSnapPos) do
      begin
        GroupIndex := 1;
        RadioItem := True;
        Tag := Ord(Pos);
      end;
    end;

    FDragMenu := AddMenuItem(Items, SCnMenuFlatFormAllowDragCaption, OnMenuAllowDrag);
  end;
end;

function TCnFloatSnapPanel.IsVertical: Boolean;
begin
  Result := FSnapPos in [spLeftTop, spLeftBottom, spRightTop, spRightBottom];
end;

procedure TCnFloatSnapPanel.AlignSubControls;
begin
  if PaintBox <> nil then
  begin
    PaintBox.Visible := AllowDrag;
    if AllowDrag then
      PaintBox.Cursor := crSizeAll
    else
      PaintBox.Cursor := crDefault;
    if IsVertical then
    begin
      PaintBox.Align := alTop;
      PaintBox.Height := csTitleWidth;
    end
    else
    begin
      PaintBox.Align := alLeft;
      PaintBox.Width := csTitleWidth;
    end;
  end;
end;

procedure TCnFloatSnapPanel.SetPos(X, Y: Integer; hWndInsertAfter: HWND);
begin
  SetWindowPos(Handle, hWndInsertAfter, X, Y, 0, 0, SWP_NOACTIVATE or SWP_NOSIZE);
end;

procedure TCnFloatSnapPanel.Hide;
begin
  Visible := False;
end;

procedure TCnFloatSnapPanel.Show;
begin
  Visible := True;
end;

//------------------------------------------------------------------------------
// ؼ¼
//------------------------------------------------------------------------------

procedure TCnFloatSnapPanel.PaintBoxPaint(Sender: TObject);
var
  r, g, b, dc: Byte;
  I, N: Integer;
  Factor: Double;
  ARect: TRect;
begin
  if IsVertical then
    N := PaintBox.Width
  else
    N := PaintBox.Height;
  if N <= 4 then Exit;
  
  if GetForegroundWindow = Handle then
  begin
    r := $00; g := $33; b := $66;
    Factor := ($99 - $00) / N;
  end
  else
  begin
    r := $99; g := $99; b := $99;
    Factor := ($CC - $99) / N;
  end;
  ARect := PaintBox.ClientRect;
  Frame3D(PaintBox.Canvas, ARect, clHighlightText, clBtnShadow, 1);
  for i := 1 to N - 2 do
  begin
    dc := Round(i * Factor);
    PaintBox.Canvas.Brush.Color := RGB(r + dc, g + dc, b + dc);
    if IsVertical then
      PaintBox.Canvas.FillRect(Rect(i, 1, i + 1, PaintBox.Height - 1))
    else
      PaintBox.Canvas.FillRect(Rect(1, i, PaintBox.Width - 1, i + 1));
  end;
end;

procedure TCnFloatSnapPanel.PaintMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if AllowDrag then
  begin
    if (Button = mbLeft) and not FMouseDown then
      FMouseDown := True;
    FOldX := X; FOldY := Y;
    PaintBox.Repaint;
  end;
end;

procedure TCnFloatSnapPanel.PaintBoxMouseMove(Sender: TObject; Shift:
  TShiftState; X, Y: Integer);
begin
  if AllowDrag and FMouseDown then
  begin
    PaintBox.OnMouseMove := nil;
    SetBounds(Left + X - FOldX, Top + Y - FOldY, Width, Height);
    PaintBox.OnMouseMove := PaintBoxMouseMove;
    PaintBox.Repaint;
  end;
end;

procedure TCnFloatSnapPanel.PaintBoxMouseUp(Sender: TObject; Button:
  TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  FMouseDown := False;
  // ʾ߽磬
  if Left < Screen.DesktopLeft then
    Left := Screen.DesktopLeft;
  if Top < Screen.DesktopTop then
    Top := Screen.DesktopTop;
  if Top + Height > Screen.DesktopHeight then
    Top := Screen.DesktopHeight - Height;
  if Left + Width > Screen.DesktopWidth then
    Left := Screen.DesktopWidth - Width;
    
  PaintBox.Repaint;
end;

procedure TCnFloatSnapPanel.OnMenuPopup(Sender: TObject);
var
  i: Integer;
begin
  if Assigned(FPosMenu) then
    for i := 0 to FPosMenu.Count - 1 do
      if FPosMenu.Items[i].Tag = Ord(SnapPos) then
      begin
        FPosMenu.Items[i].Checked := True;
        Break;
      end;
  if Assigned(FDragMenu) then
    FDragMenu.Checked := AllowDrag;
end;

procedure TCnFloatSnapPanel.OnMenuSnapPos(Sender: TObject);
begin
  if Sender is TMenuItem then
    SnapPos := TSnapPos(TMenuItem(Sender).Tag);
end;

procedure TCnFloatSnapPanel.OnMenuAllowDrag(Sender: TObject);
begin
  AllowDrag := not AllowDrag;
end;

procedure TCnFloatSnapPanel.OnMenuClose(Sender: TObject);
begin
  AllowShow := False;
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

function TCnFloatSnapPanel.GetVisible: Boolean;
begin
  Result := IsWindowVisible(Handle);
end;

procedure TCnFloatSnapPanel.SetVisible(const Value: Boolean);
begin
  if Value then
    ShowWindow(Handle, SW_SHOWNOACTIVATE)
  else
    ShowWindow(Handle, SW_HIDE);
end;

procedure TCnFloatSnapPanel.SetAllowDrag(const Value: Boolean);
begin
  if FAllowDrag <> Value then
  begin
    FAllowDrag := Value;
    AlignSubControls;
    Visible := False;
    UpdatePosition;
  end;
end;

procedure TCnFloatSnapPanel.SetOffsetX(const Value: Integer);
begin
  if FOffsetX <> Value then
  begin
    FOffsetX := Value;
    UpdatePosition;
  end;
end;

procedure TCnFloatSnapPanel.SetOffsetY(const Value: Integer);
begin
  if FOffsetY <> Value then
  begin
    FOffsetY := Value;
    UpdatePosition;
  end;
end;

procedure TCnFloatSnapPanel.SetSnapForm(const Value: TCustomForm);
begin
  if FSnapForm <> Value then
  begin
    FSnapForm := Value;
    UpdatePosition;
    UpdateVisible;
  end;
end;

procedure TCnFloatSnapPanel.SetSnapPos(const Value: TSnapPos);
var
  OldPos: TSnapPos;
  Save: Boolean;
begin
  if FSnapPos <> Value then
  begin
    Save := Visible;
    if Visible then
      Hide;
    OldPos := FSnapPos;
    FSnapPos := Value;
    SnapPosChanged(OldPos);
    AlignSubControls;
    UpdatePosition;
    if Save then
      Show;
  end;
end;

procedure TCnFloatSnapPanel.SetAllowShow(const Value: Boolean);
begin
  if FAllowShow <> Value then
  begin
    FAllowShow := Value;
    UpdateVisible;
  end;
end;

procedure TCnFloatSnapPanel.UpdatePosition;
var
  X, Y: Integer;

  function ModalFormExists: Boolean;
  var
    i: Integer;
  begin
    for i := 0 to Screen.CustomFormCount - 1 do
    begin
      if fsModal in Screen.CustomForms[i].FormState then
      begin
        Result := True;
        Exit;
      end
    end;
    Result := False;
  end;
begin
  if FAllowShow and (SnapForm <> nil) and CanShow and
    not (csDestroying in SnapForm.ComponentState) and
    not (csDestroyingHandle in SnapForm.ControlState) and
    not ModalFormExists and
    IsWindowVisible(SnapForm.Handle) and not IsIconic(SnapForm.Handle) then
  begin
    if not AllowDrag then
    begin
      if FSnapPos in [spTopLeft, spTopRight] then
        Y := SnapForm.Top - Height
      else if FSnapPos in [spLeftTop, spRightTop] then
        Y := SnapForm.Top
      else if FSnapPos in [spLeftBottom, spRightBottom] then
        Y := SnapForm.Top + SnapForm.Height - Height
      else
        Y := SnapForm.Top + SnapForm.Height;
      if FSnapPos in [spLeftTop, spLeftBottom] then
        X := SnapForm.Left - Width
      else if FSnapPos in [spTopLeft, spBottomLeft] then
        X := SnapForm.Left
      else if FSnapPos in [spTopRight, spBottomRight] then
        X := SnapForm.Left + SnapForm.Width - Width
      else
        X := SnapForm.Left + SnapForm.Width;
      Inc(Y, OffsetY);
      Inc(X, OffsetX);
      
      // ԼڵǱĻ
      if X < Screen.DesktopLeft then X := Screen.DesktopLeft;
      if Y < Screen.DesktopTop then Y := Screen.DesktopTop;
      if X + Width > Screen.DesktopWidth then
        X := Screen.DesktopWidth - Width;
      if Y + Height > Screen.DesktopHeight then
        Y := Screen.DesktopHeight - Height;
      
      if GetForegroundWindow = SnapForm.Handle then
        SetPos(X, Y, HWND_TOPMOST)
      else
        SetPos(X, Y, SnapForm.Handle);
      if not Visible then
        Show;
    end
    else
    begin
      SetPos(Left, Top, HWND_TOPMOST);
      if not Visible then
        Show;
    end;
    PaintBox.Repaint;
  end
  else if Visible then
    Hide;
end;

function TCnFloatSnapPanel.CanShow: Boolean;
begin
  Result := True;
end;

procedure TCnFloatSnapPanel.SnapPosChanged(OldPos: TSnapPos);
begin
  // do nothing
end;

procedure TCnFloatSnapPanel.UpdateVisible;
begin
  if FAllowShow and (SnapForm <> nil) and CanShow then
    Show
  else
    Hide;
end;

procedure TCnFloatSnapPanel.UpdateActions;
begin

end;

//------------------------------------------------------------------------------
// Ｐ
//------------------------------------------------------------------------------

procedure TCnFloatSnapPanel.LanguageChanged(Sender: TObject);
begin
  InitPopupMenu;
end;

procedure TCnFloatSnapPanel.LoadSettings(Ini: TCustomIniFile);
begin
  Caption := Ini.ReadString(csPanel, csCaption, Caption);
  FAllowDrag := Ini.ReadBool(csPanel, csAllowDrag, FAllowDrag);
  FAllowShow := Ini.ReadBool(csPanel, csAllowShow, FAllowShow);
  FSnapPos := TSnapPos(Ini.ReadInteger(csPanel, csSnapPos, Ord(FSnapPos)));
  if not (FSnapPos in [Low(TSnapPos)..High(TSnapPos)]) then
    FSnapPos := spTopLeft;
  FOffsetX := Ini.ReadInteger(csPanel, csOffsetX, FOffsetX);
  FOffsetY := Ini.ReadInteger(csPanel, csOffsetY, FOffsetY);
end;

procedure TCnFloatSnapPanel.SaveSettings(Ini: TCustomIniFile);
begin
  Ini.WriteString(csPanel, csCaption, Caption);
  Ini.WriteBool(csPanel, csAllowDrag, FAllowDrag);
  Ini.WriteBool(csPanel, csAllowShow, FAllowShow);
  Ini.WriteInteger(csPanel, csSnapPos, Ord(FSnapPos));
  Ini.WriteInteger(csPanel, csOffsetX, FOffsetX);
  Ini.WriteInteger(csPanel, csOffsetY, FOffsetY);
end;

//==============================================================================
// 帡ؼ
//==============================================================================

{ TCnWizFloatButtonActionLink }

procedure TCnWizFloatButtonActionLink.AssignClient(AClient: TObject);
begin
  inherited AssignClient(AClient);
  FClient := AClient as TCnWizFloatButton;
end;

procedure TCnWizFloatButtonActionLink.SetChecked(Value: Boolean);
begin
  FClient.Down := Value;
end;

{ TCnWizFloatButton }

function TCnWizFloatButton.GetActionLinkClass: TControlActionLinkClass;
begin
  Result := TCnWizFloatButtonActionLink;
end;

procedure TCnWizFloatButton.MouseUp(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  inherited;
  if (Action <> nil) and (Action is TCustomAction) then
  begin
    Action.Update;
    Down := (Action as TCustomAction).Checked;
  end;
end;

{ TCnFormFloatToolBar }

constructor TCnFormFloatToolBar.Create(AOwner: TComponent);
begin
  inherited;
  Wizard := TCnFormEnhanceWizard(CnWizardMgr.WizardByClass(TCnFormEnhanceWizard));
  Assert(Wizard <> nil);

  Panel := TPanel.Create(Self);
  Panel.Caption := '';
  Panel.Parent := Self;
  Panel.BevelInner := bvLowered;
  Panel.BevelOuter := bvNone;
  Panel.PopupMenu := PopupMenu;

  FVertOrder := True;
  FLineCount := 1;
  FActions := TStringList.Create;
end;

destructor TCnFormFloatToolBar.Destroy;
begin
  FActions.Free;
  inherited;
end;

//------------------------------------------------------------------------------
// ؼʼ
//------------------------------------------------------------------------------

procedure TCnFormFloatToolBar.AlignSubControls;
begin
  inherited;
  if Panel <> nil then
  begin
    if IsVertical then
    begin
      Panel.Left := 0;
      if PaintBox.Visible then
        Panel.Top := PaintBox.Height
      else
        Panel.Top := 0;
    end
    else
    begin
      if PaintBox.Visible then
        Panel.Left := PaintBox.Width
      else
        Panel.Left := 0;
      Panel.Top := 0;
    end;
    Width := Panel.Left + Panel.Width;
    Height := Panel.Top + Panel.Height;
  end;
end;

procedure TCnFormFloatToolBar.InitPopupMenu;
begin
  inherited;

  with PopupMenu do
  begin
    AddSepMenuItem(Items);

    AddMenuItem(Items, SCnMenuFlagFormImportCaption, OnMenuImport);
    AddMenuItem(Items, SCnMenuFlagFormExportCaption, OnMenuExport);

    AddSepMenuItem(Items);

    AddMenuItem(Items, SCnMenuFlatFormCustomizeCaption, OnMenuCustomize);
    AddMenuItem(Items, SCnMenuFlatFormConfigCaption, OnMenuConfig);
  end;
end;

function TCnFormFloatToolBar.CanShow: Boolean;
begin
  Result := Actions.Count > 0;
end;

procedure TCnFormFloatToolBar.SnapPosChanged(OldPos: TSnapPos);
var
  OldIsVertical: Boolean;
begin
  inherited;
  OldIsVertical := OldPos in [spLeftTop, spLeftBottom, spRightTop, spRightBottom];
  if OldIsVertical <> IsVertical then
    RecreateButtons;
end;

procedure TCnFormFloatToolBar.RecreateButtons;
var
  i: Integer;
  Col, Row: Integer;
  Names: TStrings;
  Actn: TContainedAction;

  procedure AddButton(AParent: TWinControl; Idx, x, y: Integer; const ActionName: string);
  var
    Actn: TContainedAction;
    Btn: TCnWizFloatButton;
  begin
    Actn := FindIDEAction(ActionName);
    if Assigned(Actn) then
    begin
      Btn := TCnWizFloatButton.Create(AParent);
      with Btn do
      begin
        Parent := AParent;
        GroupIndex := Idx;
        AllowAllUp := True;
        if IsVertical then
          SetBounds(y * csButtonWidth + 1, x * csButtonHeight + 1,
            csButtonWidth, csButtonHeight)
        else
          SetBounds(x * csButtonWidth + 1, y * csButtonHeight + 1,
            csButtonWidth, csButtonHeight);
        Action := Actn;
        dmCnSharedImages.GetSpeedButtonGlyph(Btn, dmCnSharedImages.Images,
          dmCnSharedImages.IdxUnknown);
        ShowHint := True;
        PopupMenu := Self.PopupMenu;
        if Hint = '' then
          Hint := StripHotkey(Caption);
        Caption := '';
        if Actn is TCustomAction then
          Down := TCustomAction(Actn).Checked;
      end;
    end;
  end;
begin
  Names := TStringList.Create;
  try
    // ʹʱбڵ Action Աԭеб
    Names.Assign(FActions);
    for i := Names.Count - 1 downto 0 do
    begin
      Actn := FindIDEAction(Names[i]);
      if not Assigned(Actn) then
        Names.Delete(i)
      else
      begin
        Actn.Update;
        if (Actn is TCustomAction) and not TCustomAction(Actn).Visible then
          Names.Delete(i);
      end;
    end;

    if Names.Count > 0 then
    begin
      Row := Min(LineCount, Names.Count);
      Col := (Names.Count - 1) div LineCount + 1;
      if IsVertical then
      begin
        Panel.Width := csButtonWidth * Row + 1;
        Panel.Height := csButtonHeight * Col + 1;
      end
      else
      begin
        Panel.Width := csButtonWidth * Col + 1;
        Panel.Height := csButtonHeight * Row + 1;
      end;

      for i := 0 to Names.Count - 1 do
      begin
        if Names[i] <> '' then
          if VertOrder then
            AddButton(Panel, i, i div Row, i mod Row, Names[i])
          else
            AddButton(Panel, i, i mod Col, i div Col, Names[i]);
      end;
    end;
  finally
    Names.Free;
  end;

  AlignSubControls;
  UpdatePosition;
end;

procedure TCnFormFloatToolBar.LanguageChanged(Sender: TObject);
begin
  inherited;
  RecreateButtons;
end;

procedure TCnFormFloatToolBar.UpdateActions;

  procedure TraverseClients(Container: TWinControl);
  var
    I: Integer;
    Control: TControl;
  begin
    if Container.Showing then
      for I := 0 to Container.ControlCount - 1 do
      begin
        Control := Container.Controls[I];
        if (csActionClient in Control.ControlStyle) and Control.Visible then
            Control.InitiateAction;
        if Control is TWinControl then
          TraverseClients(TWinControl(Control));
      end;
  end;
begin
  InitiateAction;
  TraverseClients(Self);
end;

//------------------------------------------------------------------------------
// öд뵼
//------------------------------------------------------------------------------

function TCnFormFloatToolBar.GetActionFileName: string;
begin
  Result := Wizard.GetFlatPanelFileName(Wizard.FList.IndexOf(Self));
end;

procedure TCnFormFloatToolBar.LoadSettings(Ini: TCustomIniFile);
var
  Value: string;
  i: Integer;
begin
  inherited;

  FLineCount := TrimInt(Ini.ReadInteger(csOptions, csLineCount, FLineCount),
    csMinLineCount, csMaxLineCount);
  FVertOrder := Ini.ReadBool(csOptions, csVertOrder, True);

  i := 0;
  FActions.Clear;
  while Ini.ValueExists(csToolBar, csButton + IntToStr(i)) do
  begin
    Value := Trim(Ini.ReadString(csToolBar, csButton + IntToStr(i), ''));
    if Value <> '' then
      FActions.Add(Value);
    Inc(i);
  end;

  RecreateButtons;
end;

procedure TCnFormFloatToolBar.SaveSettings(Ini: TCustomIniFile);
var
  i: Integer;
begin
  inherited;

  Ini.WriteInteger(csOptions, csLineCount, LineCount);
  Ini.WriteBool(csOptions, csVertOrder, FVertOrder);

  Ini.EraseSection(csToolBar);
  for i := 0 to FActions.Count - 1 do
    Ini.WriteString(csToolBar, csButton + IntToStr(i), FActions[i]);
end;

procedure TCnFormFloatToolBar.LoadActions(FileName: string = '');
var
  Ini: TMemIniFile;
begin
  if FileName = '' then
    FileName := WizOptions.GetUserFileName(ActionFileName, True);
  if FLastDataName = '' then
    FLastDataName := FileName;
  Ini := TMemIniFile.Create(FileName);
  try
    LoadSettings(Ini);
  finally
    Ini.Free;
  end;
end;

procedure TCnFormFloatToolBar.SaveActions(FileName: string = '');
var
  Ini: TMemIniFile;
begin
  if FileName = '' then
    FileName := WizOptions.GetUserFileName(ActionFileName, False);
  Ini := TMemIniFile.Create(FileName);
  try
    SaveSettings(Ini);
    Ini.UpdateFile;
  finally
    Ini.Free;
  end;
  if SameText(_CnExtractFileName(FileName), ActionFileName) then
    WizOptions.CheckUserFile(ActionFileName);
end;

function TCnFormFloatToolBar.ExportToFile: Boolean;
begin
  Result := False;
  with TSaveDialog.Create(nil) do
  try
    DefaultExt := SCnFlatToolBarDataExt;
    Filter := SCnMenuFlatFormDataFileFilter;
    Options := [ofHideReadOnly, ofOverwritePrompt, ofEnableSizing];
    FileName := FLastDataName;
    if Execute then
    begin
      SaveActions(FileName);
      FLastDataName := FileName;
      Result := True;
    end;
  finally
    Free;
  end;
end;

function TCnFormFloatToolBar.ImportFromFile: Boolean;
begin
  Result := False;
  with TOpenDialog.Create(nil) do
  try
    DefaultExt := SCnFlatToolBarDataExt;
    Filter := SCnMenuFlatFormDataFileFilter;
    Options := [ofHideReadOnly, ofFileMustExist, ofEnableSizing];
    FileName := FLastDataName;
    
    if Execute then
    begin
      LoadActions(FileName);
      FLastDataName := FileName;
      
      SaveActions;
      WizOptions.CheckUserFile(ActionFileName);
      
      Result := True;
    end;
  finally
    Free;
  end;
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

procedure TCnFormFloatToolBar.SetLineCount(const Value: Integer);
begin
  if FLineCount <> Value then
  begin
    FLineCount := Value;
    RecreateButtons;
  end;
end;

procedure TCnFormFloatToolBar.SetVertOrder(const Value: Boolean);
begin
  if FVertOrder <> Value then
  begin
    FVertOrder := Value;
    RecreateButtons;
  end;
end;

//------------------------------------------------------------------------------
// ˵¼
//------------------------------------------------------------------------------

procedure TCnFormFloatToolBar.OnMenuCustomize(Sender: TObject);
begin
  Customize;
end;

procedure TCnFormFloatToolBar.OnMenuConfig(Sender: TObject);
begin
  Wizard.Config;
end;

procedure TCnFormFloatToolBar.OnMenuExport(Sender: TObject);
begin
  ExportToFile;
end;

procedure TCnFormFloatToolBar.OnMenuImport(Sender: TObject);
begin
  ImportFromFile;
end;

procedure TCnFormFloatToolBar.Customize;
begin
  with TCnFlatToolbarConfigForm.Create(nil) do
  try
    SetStyle(tbsForm, ActionFileName, 'CnFlatToolbarConfigForm');
    ToolbarActions := FActions;
    LineCount := Self.LineCount;
    VertOrder := Self.VertOrder;
    if ShowModal = mrOk then
    begin
      FActions.Assign(ToolbarActions);
      Self.LineCount := LineCount;
      Self.VertOrder := VertOrder;

      SaveActions(WizOptions.GetUserFileName(ActionFileName, False));
      WizOptions.CheckUserFile(ActionFileName);
      RecreateButtons;
    end;
  finally
    Free;
  end;
end;

//==============================================================================
// 帡༭ؼ
//==============================================================================

{ TCnValueComboBox }

procedure TCnValueComboBox.ComboWndProc(var Message: TMessage;
  ComboWnd: HWnd; ComboProc: Pointer);
begin
  inherited;
  if Message.Msg = WM_KILLFOCUS then
  begin
    if Assigned(FOnKillFocus) then
      FOnKillFocus(Self);
    Message.Result := 0;
  end;
end;

procedure TCnValueComboBox.CreateParams(var Params: TCreateParams);
begin
  inherited;
  if FOwnerDrawList then
  begin
    Params.Style := Params.Style or CBS_OWNERDRAWVARIABLE;
  end;
end;

procedure TCnValueComboBox.SetOwnerDrawList(const Value: Boolean);
begin
  FOwnerDrawList := Value;
  RecreateWnd;
end;

procedure TCnValueComboBox.WMMouseWheel(var Message: TWMMouseWheel);
begin
  // Disable Mouse Whell
end;

{ TCnFormFloatPropBar }

constructor TCnFormFloatPropBar.Create(AOwner: TComponent);
begin
  inherited;
  FFreqProp := TStringList.Create;
  FSelection := TList.Create;
  Panel := TPanel.Create(Self);
  Panel.Caption := '';
  Panel.Parent := Self;
  Panel.BevelInner := bvLowered;
  Panel.BevelOuter := bvNone;
  Panel.PopupMenu := PopupMenu;

  FNameCombo := TCnToolBarComboBox.Create(Self);
  FNameCombo.Parent := Panel;
  FNameCombo.ParentColor := True;
  FNameCombo.Style := csDropDownList;
  FNameCombo.OnClick := OnNameClick;
  FNameCombo.OnKeyPress := OnNameKeyPress;
  FNameCombo.OnKeyDown := OnKeyDown;

  FValueCombo := TCnValueComboBox.Create(Self);
  FValueCombo.Parent := Panel;
  FValueCombo.OnKeyPress := OnKeyPress;
  FValueCombo.OnKeyDown := OnKeyDown;
  FValueCombo.OnClick := OnValueClick;
  FValueCombo.OnKillFocus := OnKillFocus;
  FValueCombo.OnMeasureItem := OnMeasureItem;
  FValueCombo.OnDrawItem := OnDrawItem;
  FValueCombo.OnDropDown := OnDropDown;

  FStringButton := TSpeedButton.Create(Self);
  FStringButton.Parent := Panel;
  FStringButton.Caption := '...';
  FStringButton.OnClick := OnButtonClick;
{$IFDEF COMPILER6_UP}
  FValueCombo.AutoComplete := False;
{$ENDIF}

  FFreqButton := TSpeedButton.Create(Self);
  FFreqButton.Parent := Panel;
  FFreqButton.OnClick := OnFreq;
  FFreqButton.GroupIndex := 100;
  FFreqButton.AllowAllUp := True;
  FFreqButton.ShowHint := True;
  FFreqButton.Hint := SCnFloatPropBarFilterCaption;
  dmCnSharedImages.GetSpeedButtonGlyph(FFreqButton, dmCnSharedImages.Images,
    IdxFreq);

  FRenameButton := TSpeedButton.Create(Self);
  FRenameButton.Parent := Panel;
  FRenameButton.OnClick := OnRename;
  FRenameButton.ShowHint := True;
  FRenameButton.Hint := SCnFloatPropBarRenameCaption;
  dmCnSharedImages.GetSpeedButtonGlyph(FRenameButton, dmCnSharedImages.Images,
    IdxRename);
end;

destructor TCnFormFloatPropBar.Destroy;
begin
  FSelection.Free;
  FFreqProp.Free;
  inherited;
end;

//------------------------------------------------------------------------------
// ؼʼ
//------------------------------------------------------------------------------

function TCnFormFloatPropBar.IsVertical: Boolean;
begin
  Result := False;
end;

procedure TCnFormFloatPropBar.AlignSubControls;
begin
  inherited;
  if Panel <> nil then
  begin
    FNameCombo.SetBounds(-1, -1, FNameComboWidth, csPropBarHeight);
    FValueCombo.SetBounds(FNameCombo.Left + FNameCombo.Width, -1,
      FValueComboWidth, csPropBarHeight);
    if FStringButton.Visible then
    begin
      FStringButton.SetBounds(FValueCombo.Left + FValueCombo.Width, 0,
        csPropBarHeight, csPropBarHeight);
      FFreqButton.SetBounds(FStringButton.Left + FStringButton.Width, 0,
        csPropBarHeight, csPropBarHeight);
    end
    else
    begin
      FFreqButton.SetBounds(FValueCombo.Left + FValueCombo.Width, 0,
        csPropBarHeight, csPropBarHeight);
    end;
    FRenameButton.SetBounds(FFreqButton.Left + FFreqButton.Width, 0,
      csPropBarHeight, csPropBarHeight);
    Panel.ClientHeight := csPropBarHeight;
    Panel.ClientWidth := FRenameButton.Left + FRenameButton.Width;
    
    if PaintBox.Visible then
      Panel.Left := PaintBox.Width
    else
      Panel.Left := 0;
    Panel.Top := 0;
    Width := Panel.Left + Panel.Width;
    Height := Panel.Top + Panel.Height;
  end;
end;

function TCnFormFloatPropBar.CanShow: Boolean;
begin
  Result := True;
end;

procedure TCnFormFloatPropBar.InitPopupMenu;
begin
  inherited;
  with PopupMenu do
  begin
    AddSepMenuItem(Items);
    AddMenuItem(Items, SCnMenuFlatFormConfigCaption, OnMenuConfig);
  end;
end;

procedure TCnFormFloatPropBar.RecreateControls;
begin
  AlignSubControls;
  UpdatePosition;
end;

procedure TCnFormFloatPropBar.LanguageChanged(Sender: TObject);
begin
  inherited;
  FFreqButton.Hint := SCnFloatPropBarFilterCaption;
  FRenameButton.Hint := SCnFloatPropBarRenameCaption;
end;

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------

function TCnFormFloatPropBar.IsBoolType(PInfo: PTypeInfo): Boolean;
begin
  Result := (PInfo = TypeInfo(Boolean)) or (PInfo = TypeInfo(WordBool)) or
    (PInfo = TypeInfo(LongBool));
end;

function TCnFormFloatPropBar.GetWizard: TCnBaseWizard;
begin
  Result := CnWizardMgr.WizardByClass(TCnFormEnhanceWizard);
  Assert(Result <> nil);
end;

function TCnFormFloatPropBar.GetSelection(Index: Integer): TPersistent;
begin
  Result := TPersistent(FSelection[Index]);
end;

function TCnFormFloatPropBar.GetSelectionCount: Integer;
begin
  Result := FSelection.Count;
end;

function TCnFormFloatPropBar.Modified: Boolean;
begin
  Result := FSaveValue <> FValueCombo.Text;
end;

procedure TCnFormFloatPropBar.UpdateActions;
var
  i: Integer;
  List: TList;
  AForm: TCustomForm;
  SelChanged: Boolean;
begin
  inherited;
  List := TList.Create;
  try
    if CnOtaGetCurrDesignedForm(AForm, List, False) then
    begin
      SelChanged := (FDsnForm <> AForm) or (SelectionCount <> List.Count);
      if not SelChanged then
        for i := 0 to List.Count - 1 do
          if FSelection[i] <> List[i] then
          begin
            SelChanged := True;
            Break;
          end;
          
      if SelChanged then
      begin
        FDsnForm := AForm;
        FSelection.Clear;
        for i := 0 to List.Count - 1 do
          FSelection.Add(List[i]);
      end;
    end
    else
    begin
      SelChanged := SelectionCount > 0;
      FDsnForm := nil;
      FSelection.Clear;
    end;

    FFreqButton.Down := FIsFilter;
    FRenameButton.Enabled := CanRename;
    FNameCombo.Enabled := SelectionCount > 0;

    if SelChanged then
      UpdateControls;
  finally
    List.Free;
  end;
end;

procedure TCnFormFloatPropBar.UpdateControls;
var
  i: Integer;
  PList: TStringList;

  procedure UpdatePropListFilter(AObj: TPersistent; Update: Boolean);
  var
    PInfo: PPropInfo;
    i, j: Integer;
    PropValid: Boolean;
  begin
    if not Update then
    begin
      for i := 0 to FFreqProp.Count - 1 do
      begin
        PInfo := GetPropInfoIncludeSub(AObj, FFreqProp[i], csTypeInfoSimple);
        if PInfo <> nil then
          if SameText(FFreqProp[i], PropInfoName(PInfo)) then
            PList.AddObject(PropInfoName(PInfo), TObject(PInfo^.PropType^))
          else  // 
            PList.AddObject(FFreqProp[i], TObject(PInfo^.PropType^));
      end;
    end
    else
    begin
      for i := PList.Count - 1 downto 0 do
      begin
        PropValid := False;
        for j := 0 to FFreqProp.Count - 1 do
        begin
          PInfo := GetPropInfoIncludeSub(AObj, FFreqProp[j], csTypeInfoSimple);
          if SameText(FFreqProp[j], PList[i]) and
            (PInfo.PropType^^.Kind = PTypeInfo(PList.Objects[i])^.Kind) and
            SameText(TypeInfoName(PInfo.PropType^), TypeInfoName(PTypeInfo(PList.Objects[i]))) then
          begin
            PropValid := True;
            Break;
          end;
        end;
        if not PropValid then
          PList.Delete(i);
      end;
    end;
  end;

  procedure UpdatePropListFromObj(AObj: TPersistent; AUpdate: Boolean);
  var
    PropList: PPropList;
    i, j, Count: Integer;
    PropValid: Boolean;
  begin
    try
      Count := GetPropList(AObj.ClassInfo, csTypeInfoSimple, nil);
    except
      Exit;
    end;

    GetMem(PropList, Count * SizeOf(PPropInfo));
    try
      GetPropList(AObj.ClassInfo, csTypeInfoSimple, PropList);
      if not AUpdate then
      begin
        for i := 0 to Count - 1 do
          if PList.IndexOf(PropInfoName(PropList[i])) < 0 then
            PList.AddObject(PropInfoName(PropList[i]), TObject(PropList[i].PropType^));
      end
      else
      begin
        for i := PList.Count - 1 downto 0 do
        begin
          PropValid := False;
          for j := 0 to Count - 1 do
            if SameText(PropInfoName(PropList[j]), PList[i]) and
              (PropList[j].PropType^^.Kind = PTypeInfo(PList.Objects[i])^.Kind) and
              SameText(TypeInfoName(PropList[j].PropType^), TypeInfoName(PTypeInfo(PList.Objects[i]))) then
            begin
              PropValid := True;
              Break;
            end;
          if not PropValid then
            PList.Delete(i);
        end;
      end;
    finally
      FreeMem(PropList);
    end;
  end;

  function IsObjInheritFrom(AObj: TObject; const ClsName: string;
    var ALevel: Integer): Boolean;
  var
    Cls: TClass;
  begin
    ALevel := 0;
    Cls := AObj.ClassType;
    repeat
      if SameText(Cls.ClassName, ClsName) then
      begin
        Result := True;
        Exit;
      end;
      Cls := Cls.ClassParent;
      Inc(ALevel);
    until Cls.ClassParent = nil;
    Result := False;
  end;  
begin
  if FUpdating then Exit;
  FUpdating := True;
  try
    FNameCombo.Items.Clear;
    if SelectionCount > 0 then
    begin
      PList := TStringList.Create;
      try
        PList.Sorted := True;
        UpdatePropListFilter(Selections[0], False);
        for i := 1 to SelectionCount - 1 do
          UpdatePropListFilter(Selections[i], True);

        if not FIsFilter then
        begin
          UpdatePropListFromObj(Selections[0], False);
          for i := 1 to SelectionCount - 1 do
            UpdatePropListFromObj(Selections[i], True);
        end;            

        if SelectionCount > 1 then
          if PList.IndexOfName('Name') >= 0 then
            PList.Delete(PList.IndexOfName('Name'));

        for i := 0 to PList.Count - 1 do
          FNameCombo.Items.Add(PList[i]);

        for i := 0 to FFreqProp.Count - 1 do
          if (Trim(FFreqProp[i]) <> '') and (PList.IndexOf(Trim(FFreqProp[i])) >= 0) then
          begin
            FNameCombo.ItemIndex := PList.IndexOf(FFreqProp[i]);
            Break;
          end;
        if (FNameCombo.Items.Count > 0) and (FNameCombo.ItemIndex < 0) then
          FNameCombo.ItemIndex := 0;
      finally
        PList.Free;
      end;   
    end;
    
    UpdateProperty(False);
  finally
    FUpdating := False;
  end;
end;

procedure TCnFormFloatPropBar.UpdateProperty(TextOnly: Boolean);
var
  i: Integer;
  PropName: string;
  V: Variant;
  IsStr: Boolean;

  procedure AddEnumList(AInfo: PTypeInfo);
  var
    i: Integer;
    SList: TStringList;
    PData: PTypeData;
  begin
    SList := TStringList.Create;
    try
      SList.Sorted := True;
      if AInfo^.Kind = tkEnumeration then
      begin
        PData := GetTypeData(AInfo);
        for i := PData.MinValue to Min(PData.MaxValue, PData.MinValue +
          csMaxEnumCount - 1) do
          SList.Add(GetEnumName(AInfo, i));
        FValueCombo.Items.Assign(SList);
      end;
    finally
      SList.Free;
    end;
  end;
begin
  if (SelectionCount > 0) and (FNameCombo.ItemIndex >= 0) then
  begin
    PropName := FNameCombo.Items[FNameCombo.ItemIndex];
    V := GetPropValueIncludeSub(Selections[0], PropName);
    for i := 1 to SelectionCount - 1 do
      if GetPropValueIncludeSub(Selections[i], PropName) <> V then
      begin
        V := '';
        Break;
      end;

    FTypeInfo := GetPropInfoIncludeSub(Selections[0], PropName)^.PropType^;
    if (FTypeInfo^.Kind = tkSet) and (V <> '') then
      V := '[' + V + ']';

    IsStr := (FTypeInfo^.Kind in [tkWChar, tkString, tkLString, tkWString
      {$IFDEF UNICODE_STRING}, tkUString{$ENDIF}]) and (PropName <> 'Name');
      
    if not TextOnly then
    begin
      FValueCombo.Items.Clear;
      FUseHistory := False;
      IsSetProp := False;
      if IsBoolType(FTypeInfo) then
      begin
        FValueCombo.Items.Add(BoolToStr(False, True));
        FValueCombo.Items.Add(BoolToStr(True, True));
      end
      else if FTypeInfo^.Kind = tkEnumeration then
      begin
        AddEnumList(FTypeInfo);
      end
      else if FTypeInfo^.Kind = tkSet then
      begin
        AddEnumList(GetTypeData(FTypeInfo)^.CompType^);
        IsSetProp := True;
      end
      else if FTypeInfo = TypeInfo(TColor) then
      begin
        GetColorList(FValueCombo.Items);
      end
      else if FTypeInfo = TypeInfo(TFontCharSet) then
      begin
        GetCharsetList(FValueCombo.Items);
      end
      else if FTypeInfo = TypeInfo(TCursor) then
      begin
        GetCursorList(FValueCombo.Items);
      end
      else if FTypeInfo^.Kind in csTypeInfoHistory then
      begin
        with Wizard.CreateIniFile do
        try
          FValueCombo.Items.CommaText := ReadString(csPropBarHistory, TypeInfoName(FTypeInfo), '');
        finally
          Free;
        end;
        FUseHistory := True;
      end;
    end;
    FValueCombo.Text := V;

    if IsStr then
    begin
      if FValueCombo.Style <> csSimple then
        FValueCombo.Style := csSimple;
      if not FStringButton.Visible then
      begin
        FStringButton.Show;
        AlignSubControls;
      end;
      FStrCaption := Selections[0].GetNamePath + '.' + PropName;
    end
    else
    begin
      if FValueCombo.Style <> csDropDown then
        FValueCombo.Style := csDropDown;
      if FStringButton.Visible then
      begin
        FStringButton.Hide;
        AlignSubControls;
      end;
    end;
  end
  else
  begin
    FValueCombo.Text := '';
  end;
  FSaveValue := FValueCombo.Text;
  FValueCombo.Enabled := FNameCombo.ItemIndex >= 0;
end;

procedure TCnFormFloatPropBar.ModifyProperty(BySelectItem: Boolean);
var
  PInfo: PTypeInfo;
  PropName: string;
  PropValue: Variant;
  EnumValue: 0..SizeOf(Integer) * 8 - 1;
  i: Integer;
begin
  if (SelectionCount > 0) and (FNameCombo.ItemIndex >= 0) then
  begin
    PropName := FNameCombo.Items[FNameCombo.ItemIndex];
    if BySelectItem and IsSetProp then
    begin
      EnumValue := GetEnumValue(GetTypeData(FTypeInfo).CompType^,
        FValueCombo.Text);
      if EnumValue in FSetValue then
        Exclude(FSetValue, EnumValue)
      else
        Include(FSetValue, EnumValue);
      PropValue := Integer(FSetValue);
    end
    else
      PropValue := FValueCombo.Text;

    for i := 0 to SelectionCount - 1 do
    begin
      try
        DoSetPropValueIncludeSub(Selections[i], PropName, PropValue);
        CnOtaNotifyFormDesignerModified(CnOtaGetCurrentFormEditor);
      except
        Application.HandleException(Self);
      end;   
    end;
    
    if FUseHistory then
    begin
      AddComboBoxTextToItems(FValueCombo);
      PInfo := GetPropInfoIncludeSub(Selections[0], PropName)^.PropType^;
      with Wizard.CreateIniFile do
      try
        WriteString(csPropBarHistory, TypeInfoName(PInfo), FValueCombo.Items.CommaText);
      finally
        Free;
      end;
    end;

    UpdateProperty(True);
    if FValueCombo.Focused and (FValueCombo.SelLength = 0) then
      FValueCombo.SelectAll;
  end;
end;

procedure TCnFormFloatPropBar.SetIsSetProp(const Value: Boolean);
begin
  FIsSetProp := Value;
  FValueCombo.OwnerDrawList := FIsSetProp;
end;

procedure TCnFormFloatPropBar.OnDropDown(Sender: TObject);
begin
  if IsSetProp then
    FSetValue := TIntegerSet(StrToSetValue(FValueCombo.Text, FTypeInfo));
end;

procedure TCnFormFloatPropBar.OnDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  IsChecked: Boolean;
  Text: string;
begin
  Text := FValueCombo.Items[Index];
  IsChecked := GetEnumValue(GetTypeData(FTypeInfo).CompType^, Text) in FSetValue;
  DrawBoolCheckBox(FValueCombo.Canvas, Rect, IsChecked, Text);
end;

procedure TCnFormFloatPropBar.OnMeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
begin
  if Height < CheckBoxHeight then
    Height := CheckBoxHeight;
end;

procedure TCnFormFloatPropBar.OnNameClick(Sender: TObject);
begin
  UpdateProperty(False);
end;

procedure TCnFormFloatPropBar.WMModified(var Msg: TMessage);
begin
  ModifyProperty(True);
end;

procedure TCnFormFloatPropBar.OnValueClick(Sender: TObject);
begin
  // ֱûᵼ Text 
  PostMessage(Handle, WM_PROPBARMODIFIED, 0, 0);
end;

procedure TCnFormFloatPropBar.OnButtonClick(Sender: TObject);
begin
  // ַԱ༭
  with TCnMultiLineEditorForm.Create(nil) do
  try
    Caption := FStrCaption;
    memEdit.Text := FValueCombo.Text;
    memEdit.Modified := False;
    tbtSep9.Visible := False;
    tbtCodeEditor.Visible := False;
    case ShowModal of
      mrOK: FValueCombo.Text := memEdit.Text;
    end;
  finally
    Free;
  end;
end;  

procedure TCnFormFloatPropBar.OnKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_TAB) and (ssCtrl in Shift) and Assigned(DsnForm) then
  begin
    DsnForm.BringToFront;
  end;
end;

procedure TCnFormFloatPropBar.OnKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #9 then
  begin
    Windows.SetFocus(FNameCombo.Handle);
  end
  else if Key = #27 then
  begin
    UpdateProperty(True);
    if FValueCombo.SelLength = 0 then
      FValueCombo.SelectAll;
  end
  else if Key = #13 then
  begin
    ModifyProperty(False);
    Key := #0;
  end;
end;

procedure TCnFormFloatPropBar.OnKillFocus(Sender: TObject);
begin
  if Modified then
    ModifyProperty(False);
end;

procedure TCnFormFloatPropBar.OnNameKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = #9 then
    Windows.SetFocus(FValueCombo.Handle);
end;

//------------------------------------------------------------------------------
// öд
//------------------------------------------------------------------------------

procedure TCnFormFloatPropBar.LoadSettings(Ini: TCustomIniFile);
begin
  inherited;
  if AllowDrag then
  begin
    Left := Ini.ReadInteger(csPropBar, csLeft, Left);
    Top := Ini.ReadInteger(csPropBar, csTop, Top);
  end;
  FNameComboWidth := Ini.ReadInteger(csPropBar, csNameComboWidth, 100);
  FValueComboWidth := Ini.ReadInteger(csPropBar, csValueComboWidth, 150);
  FIsFilter := Ini.ReadBool(csPropBar, csIsFilter, True);
  WizOptions.LoadUserFile(FFreqProp, SCnFloatPropBarFileName);
  RecreateControls;
end;

procedure TCnFormFloatPropBar.SaveSettings(Ini: TCustomIniFile);
begin
  inherited;
  Ini.WriteInteger(csPropBar, csLeft, Left);
  Ini.WriteInteger(csPropBar, csTop, Top);
  Ini.WriteInteger(csPropBar, csNameComboWidth, FNameComboWidth);
  Ini.WriteInteger(csPropBar, csValueComboWidth, FValueComboWidth);
  Ini.WriteBool(csPropBar, csIsFilter, FIsFilter);
  WizOptions.SaveUserFile(FFreqProp, SCnFloatPropBarFileName);
end;

//------------------------------------------------------------------------------
// ˵ť¼
//------------------------------------------------------------------------------

procedure TCnFormFloatPropBar.OnMenuConfig(Sender: TObject);
begin
  Wizard.Config;
end;

function TCnFormFloatPropBar.CanRename: Boolean;

  function IsRootControl(Comp: TPersistent): Boolean;
  begin
    Result := (Comp is TDataModule) or (Comp is TCustomFrame) or
      (Comp is TCustomForm);
  end;
begin
  Result := (SelectionCount > 0) and (Selections[0] is TComponent) and
    (Trim(TComponent(Selections[0]).Name) <> '');
     // and not IsRootControl(Selections[0]);
end;

procedure TCnFormFloatPropBar.OnFreq(Sender: TObject);
begin
  FIsFilter := not FIsFilter;
  UpdateControls;
end;

procedure TCnFormFloatPropBar.OnRename(Sender: TObject);
begin
  if CanRename then
  begin
    if Assigned(RenameProc) then
      RenameProc(TComponent(Selections[0]))
    else
      ErrorDlg(SCnPrefixWizardNotExist);
  end;
end;

//==============================================================================
// չ
//==============================================================================

{ TCnFormEnhanceWizard }

constructor TCnFormEnhanceWizard.Create;
begin
  inherited;
  FPropBar := TCnFormFloatPropBar.Create(nil);
  FPropBar.Caption := 'FloatPropBar';
  FIsEmbeddedDesigner := IdeGetIsEmbeddedDesigner;

  FList := TObjectList.Create;
  FDefCount := 0;
  while FileExists(WizOptions.DataPath + GetFlatPanelFileName(FDefCount)) do
    Inc(FDefCount);

  CnWizNotifierServices.AddApplicationMessageNotifier(OnAppMessage);
  CnWizNotifierServices.AddCallWndProcRetNotifier(OnCallWndProcRet,
    [WM_ACTIVATE, WM_NCACTIVATE, WM_WINDOWPOSCHANGED, WM_SHOWWINDOW]);
  CnWizNotifierServices.AddFormEditorNotifier(FormEditorNotify);
  CnWizNotifierServices.AddApplicationIdleNotifier(ApplicationIdle);
  CnWizNotifierServices.AddActiveFormNotifier(ActiveFormChanged);
end;

destructor TCnFormEnhanceWizard.Destroy;
begin
  CnWizNotifierServices.RemoveApplicationMessageNotifier(OnAppMessage);
  CnWizNotifierServices.RemoveCallWndProcRetNotifier(OnCallWndProcRet);
  CnWizNotifierServices.RemoveFormEditorNotifier(FormEditorNotify);
  CnWizNotifierServices.RemoveApplicationIdleNotifier(ApplicationIdle);
  CnWizNotifierServices.RemoveActiveFormNotifier(ActiveFormChanged);
  FPropBar.Free;
  FList.Free;
  inherited;
end;

procedure TCnFormEnhanceWizard.UpdateFlatPanelsPosition;
var
  Container: TWinControl;
  i: Integer;
  SnapForm: TCustomForm;
begin
  if FUpdating then
    Exit;

  if not Active or FIsEmbeddedDesigner then
  begin
    for i := 0 to FlatToolBarCount - 1 do
    begin
      FlatToolBars[i].SnapForm := nil;
      FlatToolBars[i].Hide;
    end;
    PropBar.SnapForm := nil;
    PropBar.Hide;
    Exit;
  end;

  FUpdating := True;
  try
    Container := CnOtaGetCurrentDesignContainer;
    if Assigned(Container) and CurrentIsForm and
      not (csDestroying in Container.ComponentState) and
      not (csDestroyingHandle in Container.ControlState) and
      IsWindowVisible(Container.Handle) and
      not IsIconic(Container.Handle) then
    begin
      SnapForm := TCustomForm(Container);
    end
    else
      SnapForm := nil;

    for i := 0 to FlatToolBarCount - 1 do
    begin
      FlatToolBars[i].SnapForm := SnapForm;
      FlatToolBars[i].UpdatePosition;
    end;
    PropBar.SnapForm := SnapForm;
    PropBar.UpdatePosition;
  finally
    FUpdating := False;
  end;
end;

procedure TCnFormEnhanceWizard.OnAppMessage(var Msg: TMsg; var Handled: Boolean);
var
  Control: TWinControl;
begin
  if Active and not FIsEmbeddedDesigner and not FUpdating and
    (Msg.message = WM_KEYDOWN) and (Msg.wParam = VK_TAB) and IsCtrlDown and
    FPropBar.AllowShow then
  begin
    Control := FindControl(Msg.hwnd);
    if (Control <> nil) and (Control = CnOtaGetCurrentDesignContainer) then
    begin
      Windows.SetFocus(FPropBar.FValueCombo.Handle);
      Handled := True;
    end;      
  end;
end;

procedure TCnFormEnhanceWizard.OnCallWndProcRet(hwnd: HWND; Control: TWinControl;
  Msg: TMessage);
begin
  if not Active or FIsEmbeddedDesigner or FUpdating then
    Exit;

  if (Msg.Msg = WM_ACTIVATE) or (Msg.Msg = WM_NCACTIVATE) then
  begin
    UpdateFlatPanelsPosition;
  end
  else if ((Msg.Msg = WM_WINDOWPOSCHANGED) or (Msg.Msg = WM_SHOWWINDOW)) and
    (Control <> nil) and (csDesigning in Control.ComponentState) and
    (Control.Parent = nil) and (Control = CnOtaGetCurrentDesignContainer) then
  begin
    if Msg.Msg = WM_WINDOWPOSCHANGED then
      UpdateFlatPanelsPosition
    else
      CnWizNotifierServices.ExecuteOnApplicationIdle(ExecOnIdle);
  end;
end;

procedure TCnFormEnhanceWizard.FormEditorNotify(FormEditor: IOTAFormEditor;
  NotifyType: TCnWizFormEditorNotifyType; ComponentHandle: TOTAHandle;
  Component: TComponent; const OldName, NewName: string);
begin
  if not Active or FIsEmbeddedDesigner or FUpdating then
    Exit;

  if NotifyType in [fetOpened, fetClosing, fetActivated] then
  begin
    CnWizNotifierServices.ExecuteOnApplicationIdle(ExecOnIdle);
  end
  else if NotifyType = fetModified then
  begin
    if not PropBar.Modified then
      PropBar.UpdateProperty(True);
  end;
end;

procedure TCnFormEnhanceWizard.ActiveFormChanged(Sender: TObject);
begin
  CnWizNotifierServices.ExecuteOnApplicationIdle(ExecOnIdle);
end;

procedure TCnFormEnhanceWizard.ExecOnIdle(Sender: TObject);
begin
  if Active and not FUpdating and not FIsEmbeddedDesigner then
  begin
    UpdateFlatPanelsPosition;
  end;
end;

procedure TCnFormEnhanceWizard.ApplicationIdle(Sender: TObject);
var
  i: Integer;
begin
  if not Active or FIsEmbeddedDesigner or FUpdating then
    Exit;

  if GetTickCount - FLastUpdateTick > csUpdateInterval then
  begin
    // ڹʱûָ Parent Action Ҫֹˢ
    for i := 0 to FlatToolBarCount - 1 do
      FlatToolBars[i].UpdateActions;
    PropBar.UpdateActions;
    FLastUpdateTick := GetTickCount;
  end;
end;

//------------------------------------------------------------------------------
// ȡ
//------------------------------------------------------------------------------

function TCnFormEnhanceWizard.GetFlatPanelFileName(Index: Integer): string;
begin
  Result := SCnFlatPanelFileName + IntToStr(Index) + '.' + SCnFlatToolBarDataExt;
end;

function TCnFormEnhanceWizard.AddFlatToolBar: TCnFormFloatToolBar;
begin
  Result := TCnFormFloatToolBar.Create(nil);
  FList.Add(Result);
  Result.Caption := 'FloatToolBar' + IntToStr(FlatToolBarCount - 1);
  Result.LoadActions;
end;

procedure TCnFormEnhanceWizard.RemoveFlatToolBar(
  FlatToolBar: TCnFormFloatToolBar);
begin
  FList.Remove(FlatToolBar);
end;

procedure TCnFormEnhanceWizard.CleanDataFile;
var
  i: Integer;
begin
  i := FlatToolBarCount;
  while FileExists(WizOptions.UserPath + GetFlatPanelFileName(i)) do
  begin
    DeleteFile(WizOptions.UserPath + GetFlatPanelFileName(i));
    Inc(i);
  end;
end;

procedure TCnFormEnhanceWizard.LoadSettings(Ini: TCustomIniFile);
var
  i: Integer;
  Count: Integer;
begin
  FList.Clear;
  Count := Ini.ReadInteger('', csCount, FDefCount);
  for i := 0 to Count - 1 do
  begin
    with AddFlatToolBar do
    begin
      if AllowDrag then
      begin
        Left := Ini.ReadInteger(GetFlatPanelFileName(i), csLeft, Left);
        Top := Ini.ReadInteger(GetFlatPanelFileName(i), csTop, Top);
      end;
    end;
  end;
  PropBar.LoadSettings(Ini);
  UpdateFlatPanelsPosition;
end;

procedure TCnFormEnhanceWizard.SaveSettings(Ini: TCustomIniFile);
var
  i: Integer;
begin
  if FlatToolBarCount = FDefCount then
    Ini.DeleteKey('', csCount)
  else
    Ini.WriteInteger('', csCount, FlatToolBarCount);

  for i := 0 to FlatToolBarCount - 1 do
  begin
    FlatToolBars[i].SaveActions;
    Ini.WriteInteger(GetFlatPanelFileName(i), csLeft, FlatToolBars[i].Left);
    Ini.WriteInteger(GetFlatPanelFileName(i), csTop, FlatToolBars[i].Top);
  end;
  PropBar.SaveSettings(Ini);

  CleanDataFile;
end;

procedure TCnFormEnhanceWizard.RestoreDefault;
begin
  FList.Clear;
  CleanDataFile;
  with CreateIniFile do
  try
    DeleteKey('', csCount);
  finally
    Free;
  end;
  DoLoadSettings;
end;

function TCnFormEnhanceWizard.GetFlatToolBar(
  Index: Integer): TCnFormFloatToolBar;
begin
  Result := TCnFormFloatToolBar(FList[Index]);
end;

function TCnFormEnhanceWizard.GetFlatToolBarCount: Integer;
begin
  Result := FList.Count;
end;

//------------------------------------------------------------------------------
// רط
//------------------------------------------------------------------------------

function TCnFormEnhanceWizard.GetHasConfig: Boolean;
begin
  Result := True;
end;

procedure TCnFormEnhanceWizard.Config;
begin
  if FIsEmbeddedDesigner then
  begin
    ErrorDlg(SCnEmbeddedDesignerNotSupport);
    Exit;
  end;

  with TCnFormEnhanceConfigForm.Create(nil) do
  try
    ShowModal;
    DoSaveSettings;
    UpdateFlatPanelsPosition;
  finally
    Free;
  end;
end;

procedure TCnFormEnhanceWizard.SetActive(Value: Boolean);
begin
  inherited;
  UpdateFlatPanelsPosition;
end;

procedure TCnFormEnhanceWizard.LanguageChanged(Sender: TObject);
var
  i: Integer;
begin
  inherited;
  for i := 0 to FlatToolBarCount - 1 do
    FlatToolBars[i].LanguageChanged(Sender);
  PropBar.LanguageChanged(Sender);
end;

class procedure TCnFormEnhanceWizard.GetWizardInfo(var Name, Author, Email,
  Comment: string);
begin
  Name := SCnFormEnhanceWizardName;
  Author := SCnPack_Zjy + ';' + SCnPack_LiuXiao;
  Email := SCnPack_ZjyEmail + ';' + SCnPack_LiuXiaoEmail;
  Comment := SCnFormEnhanceWizardComment;
end;

//==============================================================================
// ô
//==============================================================================

{ TCnFormEnhanceConfigForm }

procedure TCnFormEnhanceConfigForm.FormCreate(Sender: TObject);
begin
  Wizard := TCnFormEnhanceWizard(CnWizardMgr.WizardByClass(TCnFormEnhanceWizard));
  Assert(Wizard <> nil);
  InitControls;
  UpdateListView;
  UpdateControls(nil);
end;

function TCnFormEnhanceConfigForm.GetHelpTopic: string;
begin
  Result := 'CnFlatToolbarConfigForm';
end;

procedure TCnFormEnhanceConfigForm.InitControls;
var
  Pos: TSnapPos;
begin
  cbbSnapPos.Items.Clear;
  cbbSnapPosPropBar.Items.Clear;
  for Pos := Low(TSnapPos) to High(TSnapPos) do
  begin
    cbbSnapPos.Items.Add(StripHotkey(csFlatFormPosCaptions[Pos]^));
    cbbSnapPosPropBar.Items.Add(StripHotkey(csFlatFormPosCaptions[Pos]^));
  end;
end;

function TCnFormEnhanceConfigForm.CurrItem: TCnFormFloatToolBar;
begin
  if ListView.Selected <> nil then
    Result := TCnFormFloatToolBar(ListView.Selected.Data)
  else
    Result := nil;
end;

procedure TCnFormEnhanceConfigForm.UpdateControls(Sender: TObject);
begin
  if FUpdating then Exit;
  FUpdating := True;
  try
    cbAllowShow.Enabled := ListView.Selected <> nil;
    edtName.Enabled := ListView.Selected <> nil;
    rbAllowDrag.Enabled := ListView.Selected <> nil;
    rbAutoSnap.Enabled := ListView.Selected <> nil;
    btnCustomize.Enabled := ListView.Selected <> nil;
    btnExport.Enabled := ListView.Selected <> nil;
    btnImport.Enabled := ListView.Selected <> nil;
    btnDelete.Enabled := ListView.Selected <> nil;
    cbbSnapPos.Enabled := rbAutoSnap.Enabled and rbAutoSnap.Checked;
    seOffsetX.Enabled := rbAutoSnap.Enabled and rbAutoSnap.Checked;
    seOffsetY.Enabled := rbAutoSnap.Enabled and rbAutoSnap.Checked;

    seNameWidth.Enabled := chkShowPropBar.Checked;
    seValueWidth.Enabled := chkShowPropBar.Checked;
    cbbSnapPosPropBar.Enabled := rbAutoSnapPropBar.Checked;
    sePropBarX.Enabled := rbAutoSnapPropBar.Checked;
    sePropBarY.Enabled := rbAutoSnapPropBar.Checked;
  finally
    FUpdating := False;
  end;
  
  GetFromControl;
end;

procedure TCnFormEnhanceConfigForm.UpdateListView;
var
  i: Integer;
begin
  ListView.Items.BeginUpdate;
  try
    ListView.Items.Clear;
    for i := 0 to Wizard.FlatToolBarCount - 1 do
    begin
      with ListView.Items.Add do
      begin
        Caption := IntToStr(i);
        SubItems.Add(Wizard.FlatToolBars[i].Caption);
        SubItems.Add(StripHotkey(csFlatFormPosCaptions[Wizard.FlatToolBars[i].SnapPos]^));
        Data := Wizard.FlatToolBars[i];
      end;
    end;
    if ListView.Items.Count > 0 then
      ListView.Selected := ListView.Items[0];
  finally
    ListView.Items.EndUpdate;
  end;
end;

procedure TCnFormEnhanceConfigForm.GetFromControl;
begin
  if FUpdating then Exit;
  FUpdating := True;
  try
    if CurrItem <> nil then
    begin
      CurrItem.AllowShow := cbAllowShow.Checked;
      CurrItem.Caption := edtName.Text;
      CurrItem.AllowDrag := rbAllowDrag.Checked;
      CurrItem.SnapPos := TSnapPos(cbbSnapPos.ItemIndex);
      CurrItem.OffsetX := seOffsetX.Value;
      CurrItem.OffsetY := seOffsetY.Value;
      ListView.Selected.SubItems[0] := edtName.Text;
      ListView.Selected.SubItems[1] := StripHotkey(csFlatFormPosCaptions[CurrItem.SnapPos]^);
    end;

    Wizard.FPropBar.AllowShow := chkShowPropBar.Checked;
    Wizard.FPropBar.FNameComboWidth := seNameWidth.Value;
    Wizard.FPropBar.FValueComboWidth := seValueWidth.Value;
    Wizard.FPropBar.AllowDrag := rbAllowDragPropBar.Checked;
    Wizard.FPropBar.SnapPos := TSnapPos(cbbSnapPosPropBar.ItemIndex);
    Wizard.FPropBar.OffsetX := sePropBarX.Value;
    Wizard.FPropBar.OffsetY := sePropBarY.Value;
    Wizard.FPropBar.FFreqProp.Assign(mmoFreq.Lines);
    Wizard.FPropBar.AlignSubControls;
  finally
    FUpdating := False;
  end;
end;

procedure TCnFormEnhanceConfigForm.SetToControl;
begin
  if FUpdating then Exit;
  FUpdating := True;
  try
    if CurrItem <> nil then
    begin
      cbAllowShow.Checked := CurrItem.FAllowShow;
      edtName.Text := CurrItem.Caption;
      rbAllowDrag.Checked := CurrItem.FAllowDrag;
      rbAutoSnap.Checked := not CurrItem.FAllowDrag;
      cbbSnapPos.ItemIndex := Ord(CurrItem.FSnapPos);
      seOffsetX.Value := CurrItem.FOffsetX;
      seOffsetY.Value := CurrItem.FOffsetY;
    end;

    chkShowPropBar.Checked := Wizard.FPropBar.AllowShow;
    seNameWidth.Value := Wizard.FPropBar.FNameComboWidth;
    seValueWidth.Value := Wizard.FPropBar.FValueComboWidth;
    rbAllowDragPropBar.Checked := Wizard.FPropBar.AllowDrag;
    rbAutoSnapPropBar.Checked := not Wizard.FPropBar.AllowDrag;
    cbbSnapPosPropBar.ItemIndex := Ord(Wizard.FPropBar.SnapPos);
    sePropBarX.Value := Wizard.FPropBar.OffsetX;
    sePropBarY.Value := Wizard.FPropBar.OffsetY;
    mmoFreq.Lines.Assign(Wizard.FPropBar.FFreqProp);
  finally
    FUpdating := False;
  end;
end;

procedure TCnFormEnhanceConfigForm.ListViewSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
begin
  SetToControl;
  UpdateControls(nil);
end;

procedure TCnFormEnhanceConfigForm.btnCustomizeClick(Sender: TObject);
begin
  if CurrItem <> nil then
    CurrItem.Customize;
end;

procedure TCnFormEnhanceConfigForm.btnExportClick(Sender: TObject);
begin
  if CurrItem <> nil then
    CurrItem.ExportToFile;
end;

procedure TCnFormEnhanceConfigForm.btnImportClick(Sender: TObject);
begin
  if CurrItem <> nil then
    CurrItem.ImportFromFile;
end;

procedure TCnFormEnhanceConfigForm.btnHelpClick(Sender: TObject);
begin
  ShowFormHelp;
end;

procedure TCnFormEnhanceConfigForm.btnAddClick(Sender: TObject);
var
  NewPanel: TCnFormFloatToolBar;
begin
  NewPanel := Wizard.AddFlatToolBar;
  with TCnFlatToolbarConfigForm.Create(nil) do
  try
    SetStyle(tbsForm, '', 'CnFlatToolbarConfigForm');
    ToolbarActions := NewPanel.Actions;
    LineCount := NewPanel.LineCount;
    VertOrder := NewPanel.VertOrder;
    if (ShowModal = mrOk) and (ToolbarActions.Count > 0) then
    begin
      NewPanel.Actions.Assign(ToolbarActions);
      NewPanel.LineCount := LineCount;
      NewPanel.VertOrder := VertOrder;
      NewPanel.SaveActions;
      NewPanel.RecreateButtons;
    end
    else
      Wizard.RemoveFlatToolBar(NewPanel);
    UpdateListView;
    if ListView.Items.Count > 0 then
      ListView.Selected := ListView.Items[ListView.Items.Count - 1];
  finally
    Free;
  end;
end;

procedure TCnFormEnhanceConfigForm.btnDeleteClick(Sender: TObject);
var
  Save: Integer;
begin
  if ListView.Selected <> nil then
  begin
    Save := ListView.Selected.Index;
    Wizard.RemoveFlatToolBar(TCnFormFloatToolBar(ListView.Selected.Data));
    UpdateListView;
    if ListView.Items.Count > 0 then
      ListView.Selected := ListView.Items[Min(ListView.Items.Count - 1, Save)];
  end;
end;

procedure TCnFormEnhanceConfigForm.btnDefaultClick(Sender: TObject);
begin
  if QueryDlg(SCnFlatToolBarRestoreDefault, True) then
  begin
    Wizard.RestoreDefault;
    UpdateListView;
  end;
end;

initialization
  RegisterCnWizard(TCnFormEnhanceWizard);

{$ENDIF CNWIZARDS_CNFORMENHANCEWIZARD}
end.
