{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizShortCut;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣIDE ݼ͹ʵֵԪ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪΪ CnWizards ܵһ֣ʵ IDE ݼ󶨺Ϳݼб
*           ĹܡⲿֹҪ CnWizMenuAction רҲ˵Action ʹ
*           ãͨרҲɵÿݼԼĿݼ
*             - Ҫ IDE עһݼʹ WizShortCutMgr.Add(...) 
*               һݼ
*             - ʱĿݼԣԶ¡
*             - һθ´ԣʹ BeginUpdate  EndUpdate ֹ
*               £ EndUpdate ʱһΡ
*             - Ҫݼʱ WizShortCutMgr.Delete(...) ɾ
*               ҪԼȥͷſݼ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* Ԫʶ$Id$
* ޸ļ¼2007.05.21 V1.4
*               ȥ PushKeyboard ãΪ޸ AddKeyBinding ĳЩ
*               ݼЧ⡣
*           2007.05.10 V1.3
*               ε PushKeyboard Ĵ󣬸ܵʹ Alt+G 
*               ༭ʧЧл Dans ṩ
*           2003.07.31 V1.2
*               ݼΪдб
*           2003.06.08 V1.1
*               ĬֵͬĿݼ
*           2002.09.17 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Messages, Classes, SysUtils, Menus, ExtCtrls, ToolsAPI,
  CnWizConsts, CnCommon;

type
//==============================================================================
// IDE ݼ
//==============================================================================

{ TCnWizShortCut }

  TCnWizShortCutMgr = class;

  TCnWizShortCut = class(TObject)
  {* IDE ݼ࣬ CnWizards ʹã˿ݼԺ͹ܡ
     ÿһĿݼʵԶڴʱעؿݼͷʱ
     б档벻ҪֱӴͷŸʵӦʹÿݼ
     WizShortCutMgr  Add  Delete ʵ֡}
  private
    FDefShortCut: TShortCut;
    FOwner: TCnWizShortCutMgr;
    FShortCut: TShortCut;
    FKeyProc: TNotifyEvent;
    FMenuName: string;
    FName: string;
    FTag: Integer;
    procedure SetKeyProc(const Value: TNotifyEvent);
    procedure SetShortCut(const Value: TShortCut);
    procedure SetMenuName(const Value: string);
    function ReadShortCut(const Name: string; DefShortCut: TShortCut): TShortCut;
    procedure WriteShortCut(const Name: string; AShortCut: TShortCut);
  protected
    procedure Changed; virtual;
  public
    constructor Create(AOwner: TCnWizShortCutMgr; const AName: string;
      AShortCut: TShortCut; AKeyProc: TNotifyEvent; const AMenuName: string;
      ATag: Integer = 0);
    {* ๹벻Ҫֱӵø÷ʵӦÿݼ
       WizShortCutMgr.Add  Delete ɾ}
    destructor Destroy; override;
    {* 벻ҪֱͷŸʵӦÿݼ
       WizShortCutMgr.Delete ɾһ IDE ݼ}

    property Name: string read FName;
    {* ݼ֣ͬʱҲǱעеļֵΪգÿݼ
       עС}
    property ShortCut: TShortCut read FShortCut write SetShortCut;
    {* ݼֵ}
    property KeyProc: TNotifyEvent read FKeyProc write SetKeyProc;
    {* ݼ֪ͨ¼ݼʱø¼}
    property MenuName: string read FMenuName write SetMenuName;
    {* ݼ IDE ˵}
    property Tag: Integer read FTag write FTag;
    {* ݼǩ}
  end;

//==============================================================================
// IDE ݼ󶨽ӿʵ
//==============================================================================

{ TCnKeyBinding }

  TCnKeyBinding = class(TNotifierObject, IOTAKeyboardBinding)
  {* IDE ݼ󶨽ӿʵ࣬ CnWizards ڲʹá
     ʵ IOTAKeyboardBinding ӿڣɱ IDE Զ IDE Ŀݼ󶨡
      IDE ݼ TCnWizShortCutMgr ڲʹã벻Ҫֱʹá}
  private
    FOwner: TCnWizShortCutMgr;
  protected
    procedure KeyProc(const Context: IOTAKeyContext; KeyCode: TShortcut;
      var BindingResult: TKeyBindingResult);
    property Owner: TCnWizShortCutMgr read FOwner;
  public
    constructor Create(AOwner: TCnWizShortCutMgr);
    {* ๹ IDE ݼΪ}
    destructor Destroy; override;

    // IOTAKeyboardBinding methods
    function GetBindingType: TBindingType;
    {* ȡͣʵֵ IOTAKeyboardBinding }
    function GetDisplayName: string;
    {* ȡݼʾƣʵֵ IOTAKeyboardBinding }
    function GetName: string;
    {* ȡݼƣʵֵ IOTAKeyboardBinding }
    procedure BindKeyboard(const BindingServices: IOTAKeyBindingServices);
    {* ݼ󶨹̣ʵֵ IOTAKeyboardBinding }
  end;

//==============================================================================
// IDE ݼ
//==============================================================================

{ TCnWizShortCutMgr }

  TCnWizShortCutMgr = class(TObject)
  {* IDE ݼ࣬ά IDE а󶨵Ŀݼб
     벻ҪֱӴʵӦʹ WizShortCutMgr õǰĹʵ}
  private
    FShortCuts: TList;
    FKeyBindingIndex: Integer;
    FUpdateCount: Integer;
    FUpdated: Boolean;
    FSaveMenus: TList;
    FSaveShortCuts: TList;
    FMenuTimer: TTimer;
    function GetShortCuts(Index: Integer): TCnWizShortCut;
    function GetCount: Integer;
    procedure InstallKeyBinding;
    procedure RemoveKeyBinding;
    procedure SaveMainMenuShortCuts;
    procedure RestoreMainMenuShortCuts;
    procedure DoRestoreMainMenuShortCuts(Sender: TObject);
  public
    constructor Create;
    {* ๹벻ҪֱӴʵӦʹ WizShortCutMgr õǰ
       Ĺʵ}
    destructor Destroy; override;
    {* }
    function IndexOfShortCut(AWizShortCut: TCnWizShortCut): Integer;
    {*  IDE ݼţΪݼڷ-1}
    function IndexOfName(const AName: string): Integer; 
    {* ݿݼƲţڷ-1}
    function Add(const AName: string; AShortCut: TShortCut; AKeyProc:
      TNotifyEvent; const AMenuName: string = ''; ATag: Integer = 0): TCnWizShortCut;
    {* һݼ
     |<PRE>
       AName: string           - ݼƣΪմÿݼ浽ע
       AShortCut: TShortCut    - ݼĬϼֵ AName ЧʵʹõļֵǴעжȡ
       AKeyProc: TNotifyEvent  - ݼ֪ͨ¼
       AMenuName: string       - ݼӦ IDE ˵ûпΪ
       Result: Integer;        - ӵĿݼţҪĿݼѴڷ-1
     |</PRE>}
    procedure Delete(Index: Integer);
    {* ɾһݼ󣬲Ϊݼš}
    procedure DeleteShortCut(var AWizShortCut: TCnWizShortCut); 
    {* ɾһݼ󣬲Ϊݼ󣬵óɹΪ nil}
    procedure Clear;
    {* տݼб}
    procedure BeginUpdate;
    {* ʼ¿ݼбڴ֮ԿݼбĸĶԶаˢ£
       ֻе½ŻԶ°󶨡
       ʹʱ EndUpdate ԡ}
    procedure EndUpdate;
    {* Կݼбĸ£һεãԶ° IDE ݼ
       ʹʱ BeginUpdate ԡ}
    function Updating: Boolean;
    {* ݼб״̬ BeginUpdate  EndUpdate}
    procedure UpdateBinding;
    {* Ѱ󶨵Ŀݼб}

    property Count: Integer read GetCount;
    {* ݼ}
    property ShortCuts[Index: Integer]: TCnWizShortCut read GetShortCuts;
    {* ݼ}
  end;

function WizShortCutMgr: TCnWizShortCutMgr;
{* صǰ IDE ݼʵҪʹÿݼ벻ҪֱӴ
   TCnWizShortCutMgr ʵӦøúʡ}

procedure FreeWizShortCutMgr;
{* ͷ IDE ݼʵ}

implementation

uses
{$IFDEF Debug}
  CnDebug,
{$ENDIF Debug}
  IniFiles, Registry, CnWizUtils, CnWizOptions;

const
  csInvalidIndex = -1;

//==============================================================================
// IDE ݼ
//==============================================================================

{ TCnWizShortCut }

// ݼѱ֪ͨ°
procedure TCnWizShortCut.Changed;
begin
{$IFDEF Debug}
  CnDebugger.LogFmt('TCnWizShortCut.Changed: %s', [Name]);
{$ENDIF Debug}
  if FOwner <> nil then
    FOwner.UpdateBinding;
end;

// ๹
constructor TCnWizShortCut.Create(AOwner: TCnWizShortCutMgr;
  const AName: string; AShortCut: TShortCut; AKeyProc: TNotifyEvent;
  const AMenuName: string; ATag: Integer);
begin
  inherited Create;
  FOwner := AOwner;
  FName := AName;
  FDefShortCut := AShortCut;
  FShortCut := ReadShortCut(FName, AShortCut); // עжȡʵʹõļֵ
  FKeyProc := AKeyProc;
  FMenuName := AMenuName;
  FTag := ATag;
end;

// 
destructor TCnWizShortCut.Destroy;
begin
  FOwner := nil;
  FKeyProc := nil;
  inherited;
end;

// עȡһݼıֵ
function TCnWizShortCut.ReadShortCut(const Name: string; DefShortCut: TShortCut):
  TShortCut;
begin
  Result := DefShortCut;
  if Name = '' then Exit;

  with WizOptions.CreateRegIniFile do
  try
    if ValueExists(SCnShortCutsSection, Name) then
    begin
      if ReadInteger(SCnShortCutsSection, Name, -1) <> -1 then
        Result := ReadInteger(SCnShortCutsSection, Name, DefShortCut)
      else  // ݾɵıʽݼ
        Result := TextToShortCut(ReadString(SCnShortCutsSection, Name,
          ShortCutToText(DefShortCut)));
    end;
  finally
    Free;
  end;
end;

// һݼע
procedure TCnWizShortCut.WriteShortCut(const Name: string; AShortCut: TShortCut);
begin
  if Name = '' then Exit;
  
  with WizOptions.CreateRegIniFile do 
  try
    DeleteKey(SCnShortCutsSection, Name);
    if AShortCut <> FDefShortCut then  // ĬֵͬĿݼ
      WriteInteger(SCnShortCutsSection, Name, AShortCut);
  finally
    Free;
  end;
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

// KeyProc д
procedure TCnWizShortCut.SetKeyProc(const Value: TNotifyEvent);
begin
  if not SameMethod(TMethod(FKeyProc), TMethod(Value)) then
  begin
    FKeyProc := Value;
    Changed;
  end;
end;

// MenuName д
procedure TCnWizShortCut.SetMenuName(const Value: string);
begin
  if FMenuName <> Value then
  begin
    FMenuName := Value;
    Changed;
  end;
end;

// ShortCut д
procedure TCnWizShortCut.SetShortCut(const Value: TShortCut);
begin
  if FShortCut <> Value then
  begin
    FShortCut := Value;
    // ÿݼʱͬʱ棬 IDE 쳣رʱʧ
    WriteShortCut(FName, FShortCut);
    Changed;
  end;
end;

//==============================================================================
// IDE ݼ󶨽ӿʵ
//==============================================================================

{ TCnKeyBinding }

// ๹
constructor TCnKeyBinding.Create(AOwner: TCnWizShortCutMgr);
begin
  inherited Create;
  FOwner := AOwner;
end;

// 
destructor TCnKeyBinding.Destroy;
begin
  FOwner := nil;
  inherited;
end;

// ݼ֪ͨ¼ַ
procedure TCnKeyBinding.KeyProc(const Context: IOTAKeyContext;
  KeyCode: TShortcut; var BindingResult: TKeyBindingResult);
begin
{$IFDEF Debug}
  CnDebugger.LogFmt('TCnKeyBinding.KeyProc, KeyCode: %s', [ShortCutToText(KeyCode)]);
  CnDebugger.LogMsg('Call: ' + TCnWizShortCut(Context.GetContext).Name);
{$ENDIF Debug}
  // עݼʱѽݼ󴫵ݸ
  if Assigned(TCnWizShortCut(Context.GetContext).KeyProc) then
    TCnWizShortCut(Context.GetContext).KeyProc(TObject(Context.GetContext))
  else
  begin
  {$IFDEF Debug}
    CnDebugger.LogMsgWithType('KeyProc is nil', cmtWarning);
  {$ENDIF Debug}
  end;
  BindingResult := krHandled; // ¼ѱ
end;

//------------------------------------------------------------------------------
// ʵֵ IOTAKeyboardBinding 
//------------------------------------------------------------------------------

{ TCnKeyBinding.IOTAKeyboardBinding }

// ȡ
function TCnKeyBinding.GetBindingType: TBindingType;
begin
  Result := btPartial;
end;

// ݼ󶨹
procedure TCnKeyBinding.BindKeyboard(
  const BindingServices: IOTAKeyBindingServices);
var
  i: Integer;
  KeyboardName: string;
begin
{$IFDEF COMPILER7_UP}
  KeyboardName := '';
{$ELSE}
  KeyboardName := SCnKeyBindingName;
{$ENDIF}
{$IFDEF Debug}
  CnDebugger.LogFmt('TCnKeyBinding.BindKeyboard, Count: %d', [Owner.Count]);
{$ENDIF Debug}
  // עݼʱݼ󴫵ݸ
  for i := 0 to Owner.Count - 1 do
    if Owner.ShortCuts[i].ShortCut <> 0 then
      BindingServices.AddKeyBinding([Owner.ShortCuts[i].ShortCut], KeyProc,
        Owner.ShortCuts[i], kfImplicitShift or kfImplicitModifier or
        kfImplicitKeypad, KeyboardName, Owner.ShortCuts[i].MenuName);
end;

// ȡݼʾ
function TCnKeyBinding.GetDisplayName: string;
begin
  Result := SCnKeyBindingDispName;
end;

// ȡݼ
function TCnKeyBinding.GetName: string;
begin
  Result := SCnKeyBindingName;
end;

//==============================================================================
// IDE ݼ
//==============================================================================

{ TCnWizShortCutMgr }

// ๹
constructor TCnWizShortCutMgr.Create;
begin
{$IFDEF Debug}
  CnDebugger.LogEnter('TCnWizShortCutMgr.Create');
{$ENDIF Debug}

  inherited;
  FShortCuts := TList.Create;
  FUpdateCount := 0;
  FUpdated := False;
  FKeyBindingIndex := csInvalidIndex;

  FSaveMenus := TList.Create;
  FSaveShortCuts := TList.Create;

{$IFDEF Debug}
  CnDebugger.LogLeave('TCnWizShortCutMgr.Create');
{$ENDIF Debug}
end;

// 
destructor TCnWizShortCutMgr.Destroy;
begin
{$IFDEF Debug}
  CnDebugger.LogEnter('TCnWizShortCutMgr.Destroy');
  if Count > 0 then
    CnDebugger.LogFmtWithType('WizShortCutMgr.Count = %d', [Count], cmtWarning);
{$ENDIF Debug}

  Clear;
  FSaveMenus.Free;
  FSaveShortCuts.Free;
  FShortCuts.Free;
  if Assigned(FMenuTimer) then FMenuTimer.Free;
  inherited;
  
{$IFDEF Debug}
  CnDebugger.LogLeave('TCnWizShortCutMgr.Destroy');
{$ENDIF Debug}
end;

//------------------------------------------------------------------------------
// ¿Ʒ
//------------------------------------------------------------------------------

// ʼ¿ݼб
procedure TCnWizShortCutMgr.BeginUpdate;
begin
  if not Updating then
    FUpdated := False;
  Inc(FUpdateCount);
end;

// 
procedure TCnWizShortCutMgr.EndUpdate;
begin
  Dec(FUpdateCount);
  if not Updating and FUpdated then
  begin
    UpdateBinding; // °
    FUpdated := False;
  end;
end;

// ȡǰĸ״̬
function TCnWizShortCutMgr.Updating: Boolean;
begin
  Result := FUpdateCount > 0;
end;

//------------------------------------------------------------------------------
// бĿ
//------------------------------------------------------------------------------

// һݼ壬ؿݼʵ
function TCnWizShortCutMgr.Add(const AName: string; AShortCut: TShortCut;
  AKeyProc: TNotifyEvent; const AMenuName: string; ATag: Integer): TCnWizShortCut;
begin
{$IFDEF Debug}
  CnDebugger.LogFmt('TCnWizShortCutMgr.Add: %s (%s)', [AName,
    ShortCutToText(AShortCut)]);
{$ENDIF Debug}
  if IndexOfName(AName) >= 0 then // Ϊ
    raise ECnDuplicateShortCutName.CreateFmt(SCnDuplicateShortCutName, [AName]);
  Result := TCnWizShortCut.Create(Self, AName, AShortCut, AKeyProc, AMenuName, ATag);
  FShortCuts.Add(Result);
  if Result.FShortCut <> 0 then   // ڿݼʱ°
    UpdateBinding;
end;

// ɾָŵĿݼ
procedure TCnWizShortCutMgr.Delete(Index: Integer);
var
  NeedUpdate: Boolean;
begin
  if (Index >= 0) and (Index <= Count - 1) then
  begin
  {$IFDEF Debug}
    CnDebugger.LogFmt('TCnWizShortCutMgr.Delete(%d): %s', [Index,
      ShortCuts[Index].Name]);
  {$ENDIF Debug}
    NeedUpdate := ShortCuts[Index].FShortCut <> 0;
    ShortCuts[Index].Free;
    FShortCuts.Delete(Index);
    if NeedUpdate then           // ڿݼʱ°
      UpdateBinding;
  end;
end;

// ɾָĿݼ
procedure TCnWizShortCutMgr.DeleteShortCut(var AWizShortCut: TCnWizShortCut);
begin
  Delete(IndexOfShortCut(AWizShortCut));
  AWizShortCut := nil;
end;

// տݼб
procedure TCnWizShortCutMgr.Clear;
begin
  while Count > 0 do
  begin
    ShortCuts[0].Free;
    FShortCuts.Delete(0);
  end;
  
  RemoveKeyBinding;
end;

// ȡݼƶӦ
function TCnWizShortCutMgr.IndexOfName(const AName: string): Integer;
var
  i: Integer;
begin
  Result := -1;
  if AName = '' then Exit;
  for i := 0 to Count - 1 do
    if ShortCuts[i].Name = AName then
    begin
      Result := i;
      Exit;
    end;
end;

// ȡݼӦ
function TCnWizShortCutMgr.IndexOfShortCut(AWizShortCut: TCnWizShortCut): 
    Integer;
var
  i: Integer;
begin
  Result := -1;
  for i := 0 to Count - 1 do
    if ShortCuts[i] = AWizShortCut then
    begin
      Result := i;
      Exit;
    end;
end;

//------------------------------------------------------------------------------
// ̰ط
//------------------------------------------------------------------------------

// ĳЩڵרң DelForEx ûʹ OTA ļֿ̰֧ݼʹ
// ʱ IDE ò˵Ŀݼעᡣ°󶨼ʱܵ
// ݼʧЧ˴Ƚб棬עɺٻָָʱʹöʱʱ

procedure TCnWizShortCutMgr.DoRestoreMainMenuShortCuts(Sender: TObject);
var
  i: Integer;
begin
  FreeAndNil(FMenuTimer);

  for i := 0 to FSaveMenus.Count - 1 do
  begin
    TMenuItem(FSaveMenus[i]).ShortCut := TShortCut(FSaveShortCuts[i]);
  {$IFDEF Debug}
    CnDebugger.LogMsg(Format('MenuItem ShortCut Restored: %s (%s)',
      [TMenuItem(FSaveMenus[i]).Caption, ShortCutToText(TShortCut(FSaveShortCuts[i]))]));
  {$ENDIF Debug}
  end;

  FSaveMenus.Clear;
  FSaveShortCuts.Clear;
end;

procedure TCnWizShortCutMgr.RestoreMainMenuShortCuts;
begin
  if FMenuTimer = nil then
  begin
    FMenuTimer := TTimer.Create(nil);
    FMenuTimer.Interval := 1000;
    FMenuTimer.OnTimer := DoRestoreMainMenuShortCuts;
  end;
  FMenuTimer.Enabled := False;
  FMenuTimer.Enabled := True;
end;

procedure TCnWizShortCutMgr.SaveMainMenuShortCuts;
var
  Svcs40: INTAServices40;
  MainMenu: TMainMenu;

  procedure DoSaveMenu(MenuItem: TMenuItem);
  var
    i: Integer;
  begin
    if (MenuItem.Action = nil) and (MenuItem.ShortCut <> 0) then
    begin
      FSaveMenus.Add(MenuItem);
      FSaveShortCuts.Add(Pointer(MenuItem.ShortCut));
    {$IFDEF Debug}
      //CnDebugger.LogMsg(Format('MenuItem ShortCut Saved: %s (%s)',
      //  [MenuItem.Caption, ShortCutToText(MenuItem.ShortCut)]));
    {$ENDIF Debug}
    end;
    
    for i := 0 to MenuItem.Count - 1 do
      DoSaveMenu(MenuItem.Items[i]);
  end;
begin
  FSaveMenus.Clear;
  FSaveShortCuts.Clear;
  QuerySvcs(BorlandIDEServices, INTAServices40, Svcs40);
  MainMenu := Svcs40.MainMenu;
  DoSaveMenu(MainMenu.Items);
end;

// װ̰
procedure TCnWizShortCutMgr.InstallKeyBinding;
var
  KeySvcs: IOTAKeyboardServices;
  i: Integer;
  IsEmpty: Boolean;
begin
  Assert(FKeyBindingIndex = csInvalidIndex);
  IsEmpty := True;
  for i := 0 to Count - 1 do    // жǷڿݼ
    if ShortCuts[i].FShortCut <> 0 then
    begin
      IsEmpty := False;
      Break;
    end;
  if not IsEmpty then
  begin
    QuerySvcs(BorlandIDEServices, IOTAKeyboardServices, KeySvcs);
    SaveMainMenuShortCuts;
    try
      try
        FKeyBindingIndex := KeySvcs.AddKeyboardBinding(TCnKeyBinding.Create(Self));
      {$IFNDEF COMPILER7_UP}
        // todo: Delphi 5/6 ² PushKeyboard ᵼĳЩݼʧЧ
        // ֻᵼ° Alt+G ʧЧʱȵ
        KeySvcs.PushKeyboard(SCnKeyBindingName);
      {$ENDIF}
      except
        ;
      end;
    finally
      RestoreMainMenuShortCuts;
    end;
  end;
end;

// װ̰
procedure TCnWizShortCutMgr.RemoveKeyBinding;
var
  KeySvcs: IOTAKeyboardServices;
begin
  if FKeyBindingIndex <> csInvalidIndex then
  begin
    SaveMainMenuShortCuts;
    try
      QuerySvcs(BorlandIDEServices, IOTAKeyboardServices, KeySvcs);
    {$IFNDEF COMPILER7_UP}
      KeySvcs.PopKeyboard(SCnKeyBindingName);
    {$ENDIF}
      KeySvcs.RemoveKeyboardBinding(FKeyBindingIndex);
      FKeyBindingIndex := csInvalidIndex;
    finally
      RestoreMainMenuShortCuts;
    end;
  end;
end;

//  IDE ݼ
procedure TCnWizShortCutMgr.UpdateBinding;
begin
  if Updating then
  begin
    FUpdated := True;
    Exit;
  end;
  
  if IdeClosing then
    Exit;

{$IFDEF Debug}
  CnDebugger.LogMsg('TCnWizShortCutMgr.UpdateBinding');
{$ENDIF Debug}
  RemoveKeyBinding;
{$IFDEF Debug}
  CnDebugger.LogMsg('RemoveKeyBinding succeed');
{$ENDIF Debug}
  InstallKeyBinding;
{$IFDEF Debug}
  CnDebugger.LogMsg('InstallKeyBinding succeed');
{$ENDIF Debug}
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

// Count Զ
function TCnWizShortCutMgr.GetCount: Integer;
begin
  Result := FShortCuts.Count;
end;

// ShortCuts Զ
function TCnWizShortCutMgr.GetShortCuts(Index: Integer): TCnWizShortCut;
begin
  Result := nil; // Խ緵ؿָ
  if (Index >= 0) and (Index <= Count - 1) then
    Result := TCnWizShortCut(FShortCuts[Index]);
end;

var
  FWizShortCutMgr: TCnWizShortCutMgr = nil;

// صǰ IDE ݼʵ
function WizShortCutMgr: TCnWizShortCutMgr;
begin
  if FWizShortCutMgr = nil then
    FWizShortCutMgr := TCnWizShortCutMgr.Create;
  Result := FWizShortCutMgr;
end;

// ͷ IDE ݼʵ
procedure FreeWizShortCutMgr;
begin
  if FWizShortCutMgr <> nil then
    FreeAndNil(FWizShortCutMgr);
end;

end.
