{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program IncProjBuild;

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolsAPI, CnCommon, CnWizUtils;

var
  Options: IOTAProjectOptions;
  Project: IOTAProject;
  MajorVer, MinorVer, ReleaseNo, BuildNo: Integer;

begin
  Options := CnOtaGetActiveProjectOptions(nil);
  if Options = nil then Exit;
  Project := CnOtaGetCurrentProject;
  if Project = nil then Exit;

  if (Compiler = cnDelphi5) or (Compiler = cnBCB5) then
  begin
    if not QueryDlg('This function maybe can NOT run correctly in Delphi 5 or C++Builder 5 for an OTA Bug.'
      + #13#10#13#10 + 'Do you want to Continue?', False) then
      Exit;
  end;

  // Get the Versions
  MajorVer := Options.GetOptionValue('MajorVersion');
  MinorVer := Options.GetOptionValue('MinorVersion');
  ReleaseNo  := Options.GetOptionValue('Release');
  BuildNo := Options.GetOptionValue('Build');

  if QueryDlg(Format('Current Project Version is %d.%d.%d.%d. Inc the Build Number?',
    [MajorVer, MinorVer, ReleaseNo, BuildNo]), False) then
  begin
    BuildNo := BuildNo + 1;
    CnOtaSetProjectOptionValue(Options, 'Build', Format('%d', [BuildNo]));

    // Re-Get the Versions.
    MajorVer := Options.GetOptionValue('MajorVersion');
    MinorVer := Options.GetOptionValue('MinorVersion');
    ReleaseNo  := Options.GetOptionValue('Release');
    BuildNo := Options.GetOptionValue('Build');

    // Note: In Delphi 5/C++Builder 5, there's a BUG.
    // Nubers are correct here, but maybe unchanged in Project Options Dialog.
    InfoDlg(Format('Current Project Version is %d.%d.%d.%d.',
      [MajorVer, MinorVer, ReleaseNo, BuildNo]));
  end;
end.
 
