{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnIniLangFileStorage;
{* |<PRE>
================================================================================
* ƣCnPack 
* ԪƣIni 洢Ԫ
* ԪߣCnPack
*     עõԪʵ Ini 洢࣬ڲʹ HashMap
* ƽ̨PWin2000 + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   õԪеַϱػʽ
* Ԫʶ$Id$
* ޸ļ¼2008.11.19 V1.1
*               Efeis  Ini 
*           2003.08.20 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, IniFiles, Dialogs, FileCtrl, CnCommon,
  CnConsts, CnIniStrUtils, CnWideStrings, CnLangStorage, CnHashLangStorage;

const
  SCnGlobalSectionName = SystemNamePrefix + 'Global';
  SCnStringsSectionName = SystemNamePrefix + 'Strings';

type
  TCnCustomIniLangFileStorage = class(TCnCustomHashLangStorage)
  private
    FIniFile: TIniFile;
  protected
    procedure InternalInit; override;
    procedure CreateCurrentLanguage; override;
    procedure InitFromAFile(const AFileName: WideString); override;
    procedure GetComponentInfo(var AName, Author, Email, Comment: string); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    class function GetLanguageFileExt: WideString; override;
    {* ضļչ.INI }

    function IsLanguageFile(const FileName: WideString): Boolean; override;
    {* жһļǷϷļ }
    function LoadCurrentLanguage: Boolean; override;
    {*  Ini ļ뵱ǰĿΪִ׼ }
    procedure SaveCurrentLanguage; override;
    {* 浱ǰļ }

  published
    property StorageMode;
    {* ļ洢ģʽĿ¼洢ǰļ洢 }
    property LanguagePath;
    {* ļ洢ͳһ· }
    property FileName;
    {* ļ洢ʱͳһļ }
    property Languages;
    {* Զб }
    property AutoDetect;
    {* LanguagePath ıʱǷԶ }    
  end;

  TCnIniLangFileStorage = class(TCnCustomIniLangFileStorage)
  end;

implementation

uses
  CnLangConsts;

{ TCnCustomIniLangFileStorage}

constructor TCnCustomIniLangFileStorage.Create(AOwner: TComponent);
begin
  inherited;
end;

destructor TCnCustomIniLangFileStorage.Destroy;
begin
  if Assigned(FIniFile) then
    FreeAndNil(FIniFile);
  inherited;
end;

procedure TCnCustomIniLangFileStorage.CreateCurrentLanguage;
begin

end;

class function TCnCustomIniLangFileStorage.GetLanguageFileExt: WideString;
begin
  Result := '.ini';
end;

procedure TCnCustomIniLangFileStorage.InternalInit;
begin
  inherited;

end;

function TCnCustomIniLangFileStorage.IsLanguageFile(const FileName: WideString): Boolean;
var
  IniFile: TIniFile;
begin
  Result := True;
  IniFile := TIniFile.Create(FileName);
  try
    if not IniFile.SectionExists(SCnGlobalSectionName) then
      Result := False
    else if not IniFile.ValueExists(SCnGlobalSectionName, SystemNamePrefix
      + SCnLanguageID) then
        Result := False;
  finally
    IniFile.Free;
  end;
end;

function TCnCustomIniLangFileStorage.LoadCurrentLanguage: Boolean;
var
  S: string;
  Sections, Lines: TStrings;
  I, J: Integer;
begin
  Result := True;
  if Assigned(FIniFile) then
    FreeAndNil(FIniFile);

  //Added by Efeis on 2008-11-18 ûлڸеĹУӦҪʼһµ
  InitHashMap;

  try
    // ֵļ洢Ŀ¼浽Ŀ¼
    if (csDesigning in ComponentState) and (LanguagePath = '') and (DesignLangPath <> '') then
      S := IncludeTrailingBackslash(DesignLangPath) + GetCurrentLanguageFileName
    else
      S := IncludeTrailingBackslash(LanguagePath) + GetCurrentLanguageFileName;

    if not ForceDirectories(_CnExtractFilePath(S)) then
      raise ELanguageStorageError.Create(SCnCanNotCreateDir + _CnExtractFilePath(S));

    FIniFile := TIniFile.Create(S);
    Sections := TStringList.Create;
    Lines := TStringList.Create;
    FIniFile.ReadSections(Sections);

    try
      for I := 0 to Sections.Count - 1 do
      begin
        if (Sections[I] = SCnGlobalSectionName) or
          (Sections[I] = SCnStringsSectionName) then // ڲ
        begin
          FIniFile.ReadSection(Sections[I], Lines);
          for J := 0 to Lines.Count - 1 do
          begin
            //Modified by Efeis on 2008-11-18 ԭ߽ReadSection˰ɣҳҲܸдӰ
            AddStringToHashMap(Lines[J], FIniFile.ReadString(Sections[I], Lines[J], ''));
          end;
        end
        else // ͨ
        begin
          FIniFile.ReadSection(Sections[I], Lines);
          for J := 0 to Lines.Count - 1 do
          begin
            //Modified by Efeis on 2008-11-18 ͬϣReadSectionĴ⼰IniFileʹ
            AddStringToHashMap(Sections[I] + DefDelimeter + Lines[J], FIniFile.ReadString(Sections[I], Lines[J], ''));
          end;
        end;
      end;
    finally
      Sections.Free;
      Lines.Free;
    end;
  except
    Result := False;
  end;
end;

procedure TCnCustomIniLangFileStorage.SaveCurrentLanguage;
var
  Sections, List: TStringList;
  Key, Value, Sec: WideString;
  I, EPos: Integer;
begin
  if Assigned(FIniFile) then
  begin
    Sections := TStringList.Create;
    try
      FIniFile.ReadSections(Sections);
      for I := 0 to Sections.Count - 1 do
        FIniFile.EraseSection(Sections[I]);
    finally
      Sections.Free;
    end;

    List := TStringList.Create;
    HashMap.StartEnum;
    while HashMap.GetNext(Key, Value) do
      List.Add(Key + DefEqual + Value);
    List.Sort;

    for I := 0 to List.Count - 1 do
    begin
      if Pos(SystemNamePrefix, List[I]) = 1 then // жϵһǲǸ̾
      begin
        Sec := SCnGlobalSectionName;
      end
      else  // ж޵
      begin
        EPos := Pos(DefDelimeter, List[I]);
        if EPos > 0 then  // еţȡһǰ Section 
        begin
          Sec := Copy(List[I], 1, EPos - 1);
          List[I] := Copy(List[I], EPos + 1, MaxInt);
        end
        else
          Sec := SCnStringsSectionName; // ޵ţַ
      end;

      // 
      EPos := Pos(DefEqual, List[I]);
      if EPos > 0 then // еȺ
      begin
        Key := Copy(List[I], 1, EPos - 1);
        Value := Copy(List[I], EPos + 1, MaxInt);
      end
      else
      begin
        Key := List[I];
        Value := '';
      end;
      FIniFile.WriteString(Sec, Key, Value);
    end;
    FIniFile.UpdateFile;
  end;
end;

procedure TCnCustomIniLangFileStorage.InitFromAFile(const AFileName: WideString);
begin
  // һļ
  if Assigned(FIniFile) then
    FreeAndNil(FIniFile);

  with Languages.Add do
  begin
    LanguageFileName := _CnExtractFileName(_CnChangeFileExt(AFileName, ''));

    FIniFile := TIniFile.Create(AFileName);
    try
      LanguageID := StrToIntDef(FIniFile.ReadString(SCnGlobalSectionName, SystemNamePrefix + SCnLanguageID, ''), 0);
    except
      LanguageID := 0;
    end;

    if LanguageID <> 0 then
    begin
      LanguageName := FIniFile.ReadString(SCnGlobalSectionName, SystemNamePrefix + SCnLanguageName, '');
      Author := FIniFile.ReadString(SCnGlobalSectionName, SystemNamePrefix + SCnAuthor, '');
      AuthorEmail := FIniFile.ReadString(SCnGlobalSectionName, SystemNamePrefix + SCnAuthorEmail, '');
      if FIniFile.ReadString(SCnGlobalSectionName, SystemNamePrefix + SCnDefaultFont, '') <> '' then
        StringToFont(FIniFile.ReadString(SCnGlobalSectionName, SystemNamePrefix + SCnDefaultFont, ''), DefaultFont);
    end
    else
    begin
      Self.FCurrentLanguageIndex := -1;
      Languages.Delete(Index);
    end;
  end;
end;

procedure TCnCustomIniLangFileStorage.GetComponentInfo(var AName, Author,
  Email, Comment: string);
begin
  AName := SCnIniLangStorageName;
  Author := SCnPack_LiuXiao;
  Email := SCnPack_LiuXiaoEmail;
  Comment := SCnIniLangStorageComment;
end;

end.
