{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnSkinMagic;
{* |<PRE>
================================================================================
* ƣӹԪ
* ԪƣڻƤܣƤЧʵ
* ԪߣCnPack savetime
            (savetime2k@hotmail.com, http://savetime.delphibbs.com)
*     עԪԭȨ CnPack ֲѱԭ߰ȨϢ
* ƽ̨
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   õԪеַϱػʽ
* Ԫʶ$Id$
* ޸ļ¼2007.07.27 V1.0
*                ֲԪ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  CnNativeDecl, CnClasses, CnConsts, CnCompConsts, CnGraphConsts;

type

  TControlSubClass = class(TObject)
  {* ؼ SubClass ֮ĶSkin Ҫ˽ public }
  private
    FControl: TControl;
    FSkinWindowProc: TWndMethod;
    FOldWindowProc: TWndMethod;
    FIsWinControl: Boolean;
    FMouseInControl: Boolean;
    constructor Create(AControl: TControl);
    {* Skin ,Խ private }
    procedure WindowProc(var Message: TMessage);
  public
    property Control: TControl read FControl;
    {*  SubClass Ŀؼ(ֻ) }
    property OldWindowProc: TWndMethod read FOldWindowProc;
    {* ؼԭʼ WindowProc }
    property IsWinControl: Boolean read FIsWinControl;
    {* ǰؼǷ TWinControl  }
    property MouseInControl: Boolean read FMouseInControl;
    {* Ƿڵǰؼ }    
  end;

  TCnSkinMagic = class(TCnComponent)
  {* ڻƤɲʵֱʹ෽ }
  private
    function GetSkinActive: Boolean;
  protected
    class procedure RefreshControls;
    {* ˢпؼ}
    procedure GetComponentInfo(var AName, Author, Email, Comment: string); override;
  public
    class procedure EnableSkin;
    {* ʹ CnSkinMagic Ĵڹ̹ҽ }
    class procedure DisableSkin;
    {*  CnSkinMagic Ĵڹ̹ҽ }
    class procedure RegisterClass(AClass: TControlClass; AWindowProc: Pointer);
    {* עҪҽӵ CnSkinMagic Class, עʧ, 쳣
       : AClass     SubClass , Ϊ TControlClass 
             AWndProc  SubClass  WindowProc, û
       ע⣺AWindowProc µĸʽ
       procedure AWindowProc(Self: TControlSubClass; var Message: TMessage);
    }
  published
    property SkinActive: Boolean read GetSkinActive;
    {* صǰ Skin Ƿ񼤻,  EnableSkin  DisableSkin }
  end;

{==============================================================================}
{ IMPLEMENTATION - Ǿʵ, Skin ߿Բ´             }
{==============================================================================}

implementation

type
  TAfterConstruction = procedure(Self: Pointer);
  TBeforeDestruction = procedure(Self: Pointer);
  // TObject.AfterConstruction & BeforeDestruction 

  TCnClassList = class(TList)
  {* ڹû ClassData }
  protected
    procedure Notify(Ptr: Pointer; Action: TListNotification); override;
  end;

  PClassData = ^TClassData;
  TClassData = record
  {* TCnClassList е }
    ClassType: TClass;
    WindowProc: Pointer;
    OldAfterConstruction: Pointer;
    OldBeforeDestruction: Pointer;
  end;

var
  FClassList: TCnClassList;
  {* (ȫ)ûϢ(TClassData)б }
  FSkinActive: Boolean;
  {* ǰ Skin Ƿ񼤻,  EnableSkin  DisableSkin   }
  CN_MSG_BEFORE_DESTRUCTION: Cardinal;
  {* CN_MSG_BEFORE_DESTRUCTION Ϣ, ֪ͨ TControlSubClass }

{==============================================================================}
{ Ǹ                                                               }
{==============================================================================}

{------------------------------------------------------------------------------}
// FindClassData -  FClassList ҵؼ TClassData Ϣ
{------------------------------------------------------------------------------}
function FindClassData(AClass: TClass): PClassData;
var
  I: Integer;
begin
  for I := 0 to FClassList.Count - 1 do
  begin
    Result := PClassData(FClassList.Items[I]);
    if AClass = Result.ClassType then Exit;
  end;
  raise Exception.Create(SCNE_FINDCLASSDATAFAILED);
end;

{------------------------------------------------------------------------------}
// MakeMethod - һ㾲̬תΪ TMethod 
{------------------------------------------------------------------------------}
function MakeMethod(Self: Pointer; FuncAddr: Pointer): TMethod;
begin
  Result.Code := FuncAddr;
  Result.Data := Self;
end;

{------------------------------------------------------------------------------}
// CnAfterConstruction - 滻 AfterConstruction , ڿؼ
// ˺ú󴴽 TControlSubClass ¹Ŀؼһ
// 󻹵ԭʼ AfterConstruction 
{------------------------------------------------------------------------------}
procedure CnAfterConstruction(Self: TControl);
var
  OldAfterConstruction: TAfterConstruction;
  ClassDataPtr: PClassData;
begin
  // ½һ ControlSubClass , ڿƵǰؼΪ
  TControlSubClass.Create(Self);

  // ҵǰؼ(û)
  ClassDataPtr := FindClassData(Self.ClassType);
  // (û)гʼ AfterConstruction 
  OldAfterConstruction := ClassDataPtr^.OldAfterConstruction;
  //  AfterConstruction , ִ
  if Assigned(OldAfterConstruction) then OldAfterConstruction(Self);
end;

{------------------------------------------------------------------------------}
// CnBeforeDestruction - 滻 BeforeDestruction , ڿؼǰ
// ˺úϢ TControlSubClass , ʹ֮ͬʱ
// 󻹵ԭʼ BeforeDestruction 
{------------------------------------------------------------------------------}
procedure CnBeforeDestruction(Self: TControl);
var
  OldBeforeDestruction: TBeforeDestruction;
  ClassDataPtr: PClassData;
begin
  // Ϣ֪ͨ TControlSubClass 
  Self.Perform(CN_MSG_BEFORE_DESTRUCTION, 0, 0);

  // ҵǰؼ(û)
  ClassDataPtr := FindClassData(Self.ClassType);
  // (û)гʼ BeforeDestruction 
  OldBeforeDestruction := ClassDataPtr^.OldBeforeDestruction;
  //  BeforeDestruction , ִ
  if Assigned(OldBeforeDestruction) then
    OldBeforeDestruction(Self);
end;

{------------------------------------------------------------------------------}
// WriteVmtPtr - д vmt ֵָ (д)
{------------------------------------------------------------------------------}
procedure WriteVmtPtr(VmtPtrAddr: Pointer; AFuncAddr: Pointer);
var
  ProcessHandle: THandle;
  WriteBytesCount: TCnNativeUInt;
begin
  ProcessHandle := OpenProcess(PROCESS_VM_OPERATION or PROCESS_VM_WRITE,
    False, GetCurrentProcessId());
  {TODO: ǲҪһ ProcessHandle }

  WriteProcessMemory(ProcessHandle, VmtPtrAddr, @AFuncAddr, 4, WriteBytesCount);

  CloseHandle(ProcessHandle);

  if WriteBytesCount <> 4 then
    raise Exception.Create(SCNE_WRITEVMTFAILED);
end;

{------------------------------------------------------------------------------}
// TCnClassList.Notify -  Item ɾʱԶ TClassData 
{------------------------------------------------------------------------------}
procedure TCnClassList.Notify(Ptr: Pointer; Action: TListNotification);
begin
  inherited;
  if Action = lnDeleted then
    Dispose(Ptr);
end;

{------------------------------------------------------------------------------}
// TControlSubClass.Create -  SubClass ؼһ
{------------------------------------------------------------------------------}
constructor TControlSubClass.Create(AControl: TControl);
var
  ClassDataPtr: PClassData;
begin
  // ҵǰؼ(û)
  ClassDataPtr := FindClassData(AControl.ClassType);
  //  ControlSubClass б浱ǰؼָ
  FControl := AControl;
  //  ControlSubClass д洢ǰؼǷ TWinControl
  FIsWinControl := AControl is TWinControl;
  // ϳ FSkinWindowProc;
  FSkinWindowProc := TWndMethod(MakeMethod(Self, ClassDataPtr^.WindowProc));
  //  ControlSubClass б浱ǰؼĴڹ
  FOldWindowProc := AControl.WindowProc;
  // õǰĴڹΪ(û)еĴڹ
  AControl.WindowProc := Self.WindowProc;
end;

{------------------------------------------------------------------------------}
// TControlSubClass.WindowProc -  SubClass ʱһõ WindowProc
{------------------------------------------------------------------------------}
procedure TControlSubClass.WindowProc(var Message: TMessage);
begin
  if Message.Msg = CN_MSG_BEFORE_DESTRUCTION then  // ؼ
  begin
    Destroy;
    Exit;
  end;

  if not FSkinActive then
  begin
    OldWindowProc(Message);
    Exit;
  end;

  case Message.Msg of
    CM_MOUSEENTER:  // ؼ
      begin
        FMouseInControl := True;
      end;
    CM_MOUSELEAVE:  // 뿪ؼ
      begin
        FMouseInControl := False;
      end;
  end;

  FSkinWindowProc(Message);   // ִ Skin WindowProc 
end;

{ TCnSkinMagic }

{------------------------------------------------------------------------------}
// RegisterClass - ע SkinMagic Class, עʧ, 쳣
//
// : AClass     SubClass , Ϊ TControlClass 
//       AWndProc  SubClass  WindowProc, û
{------------------------------------------------------------------------------}
class procedure TCnSkinMagic.RegisterClass(AClass: TControlClass;
  AWindowProc: Pointer);
var
  ConstructionPtr, DestructionPtr: Pointer;
  OldConstruction, OldDestruction: Pointer;
  ClassDataPtr: PClassData;
begin
  // ȡԭʼ AfterConstruction vmt ָ
  ConstructionPtr := Pointer(Integer(AClass) + vmtAfterConstruction);
  // ȡԭʼ AfterConstruction ַ
  OldConstruction := Pointer(PInteger(ConstructionPtr)^);
  // д vmt ָ
  WriteVmtPtr(ConstructionPtr, @CnAfterConstruction);

  // ȡԭʼ BeforeDestruction vmt ָ
  DestructionPtr := Pointer(Integer(AClass) + vmtBeforeDestruction);
  // ȡԭʼ BeforeDestruction ַ
  OldDestruction := Pointer(PInteger(DestructionPtr)^);
  // д vmt ָ
  WriteVmtPtr(DestructionPtr, @CnBeforeDestruction);

  // Ϣȫ List
  New(ClassDataPtr);
  ClassDataPtr^.ClassType := AClass;
  ClassDataPtr^.WindowProc := AWindowProc;
  ClassDataPtr^.OldAfterConstruction := OldConstruction;
  ClassDataPtr^.OldBeforeDestruction := OldDestruction;
  FClassList.Add(ClassDataPtr);
end;

class procedure TCnSkinMagic.RefreshControls;
var
  I, J: Integer;
  Form: TForm;          // ʹʱԷʵĿ
  Control: TControl;
begin
  if not Assigned(Screen) then Exit;

  for I := 0 to Screen.FormCount - 1 do
  begin
    Form := Screen.Forms[I];
    if not Form.Visible then Continue;
    for J := 0 to Form.ControlCount - 1 do
    begin
      Control := Form.Controls[J];
      if not Control.Visible then Continue;
      Control.Visible := False;
      Control.Visible := True;
    end;
  end;
end;

class procedure TCnSkinMagic.EnableSkin;
begin
  if not FSkinActive then
  begin
    FSkinActive := True;
    RefreshControls;
  end;
end;

class procedure TCnSkinMagic.DisableSkin;
begin
  if FSkinActive then
  begin
    FSkinActive := False;
    RefreshControls;
  end;
end;

function TCnSkinMagic.GetSkinActive: Boolean;
begin
  Result := FSkinActive;
end;

procedure TCnSkinMagic.GetComponentInfo(var AName, Author, Email,
  Comment: string);
begin
  AName := SCnSkinMagicName;
  Author := SCnPack_Savetime;
  Email := SCnPack_SavetimeEmail;
  Comment := SCnSkinMagicComment;
end;

initialization
  // ȫ TCnClassList , ڹ TClassData Ϣ
  FClassList := TCnClassList.Create;

  // עȫϢ, ֪ͨʱ TControlSubClass ͬʱ
  CN_MSG_BEFORE_DESTRUCTION := RegisterWindowMessage('CnSkinMagic_BeforeDestruction');
  if CN_MSG_BEFORE_DESTRUCTION = 0 then
    raise Exception.Create(SCNE_REGISTERMESSAGEFAILED);

finalization
  // ͷ FClassList 
  FClassList.Free;

end.
