{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnGraphUtils;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣͼ̿ⵥԪ
* ԪߣCnPack
*     ע
* ƽ̨PWin98SE + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* Ԫʶ$Id$
* ޸ļ¼2002.10.20 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, Graphics, Math;


//==============================================================================
// չɫʽת
//==============================================================================

var
  HSLRange: Integer = 240;

//------------------------------------------------------------------------------
// HSL ɫ RGB ɫת
//------------------------------------------------------------------------------

function HSLToRGB(H, S, L: Double): TColor;
{* HSL ɫתΪ RGB ɫ
 |<PRE>
   H, S, L: Double   - ֱΪɫͶȡȷΪ"0""1"֮С
   Result: TColor    - RGBɫֵ
 |</PRE>}
function HSLRangeToRGB(H, S, L: Integer): TColor;
{* HSL ɫתΪ RGB ɫ
 |<PRE>
   H, S, L: Integer  - ֱΪɫͶȡȷ0..240
   Result: TColor    - RGBɫֵ
 |</PRE>}
procedure RGBToHSL(Color: TColor; out H, S, L: Double);
{* RGB ɫתΪ HSL ɫ
 |<PRE>
  Color: TColor         - RGBɫֵ
  H, S, L: Integer      - ֱΪɫͶȡȷΪ"0""1"֮С
 |</PRE>}
procedure RGBToHSLRange(Color: TColor; out H, S, L: Integer);
{* RGB ɫתΪ HSL ɫ
 |<PRE>
   Color: TColor        - RGBɫֵ
   H, S, L: Integer     - ֱΪɫͶȡȷ0..240
 |</PRE>}

function ChangeHue(Color: TColor; Hue: Double): TColor;
{* 滻ɫеɫֵµɫ}
function ChangeSaturation(Color: TColor; Saturation: Double): TColor;
{* 滻ɫеıͶֵµɫ}
function ChangeLighteness(Color: TColor; Lighteness: Double): TColor;
{* 滻ɫеֵµɫ}

function AdjustHue(Color: TColor; Added: Double): TColor;
{* ɫеɫֵµɫ}
function AdjustSaturation(Color: TColor; Added: Double): TColor;
{* ɫеıͶֵµɫ}
function AdjustLighteness(Color: TColor; Added: Double): TColor;
{* ɫеֵµɫ}

//------------------------------------------------------------------------------
// CMY ɫ RGB ɫת
//------------------------------------------------------------------------------

function CMYToRGB(const C, M, Y: Byte): TColor;
{* CMYɫתΪRGBɫ
 |<PRE>
  C, M, Y: Byte         - ֱΪCyanࡢMagentaƷ졢YellowƷ0..255
  Result: TColor        - RGBɫֵ
 |</PRE>}
procedure RGBToCMY(const RGB: TColor; out C, M, Y: Byte);
{* RGBɫתΪCMYɫ
 |<PRE>
 |<BR> Color: TColorRGBɫֵ
 |<BR> C, M, Y: ByteֱΪCyanࡢMagentaƷ졢YellowƷ0..255
 |</PRE>}

//------------------------------------------------------------------------------
// CMYK ɫ RGB ɫת
//------------------------------------------------------------------------------

function CMYKToRGB(const C, M, Y, K: Byte): TColor;
{* CMYKɫתΪRGBɫ
 |<PRE>
   C, M, Y, K: Byte     - ֱΪCyanࡢMagentaƷ졢YellowơBlackڷ0..255
   Result: TColor       - RGBɫֵ
 |</PRE>}
procedure RGBToCMYK(const RGB: TColor; out C, M, Y, K: Byte);
{* RGBɫתΪCMYɫ
 |<PRE>
   Color: TColor        - RGBɫֵ
   C, M, Y, K: Byte     - ֱΪCyanࡢMagentaƷ졢YellowơBlackڷ0..255
 |</PRE>}

//==============================================================================
// ǿɫ
//==============================================================================

function Gray(Intensity: Byte): TColor;
{* һҶ RGB ɫֵ}
function Intensity(Color: TColor): Byte;
{* RGBɫֵĻҶֵ}
function RandomColor: TColor;
{* һ RGB ɫֵ}
procedure DeRGB(Color: TColor; var r, g, b: Byte);
{*  Color ֽΪ rgb ɫ}

//==============================================================================
// չλͼ
//==============================================================================

function CreateEmptyBmp24(Width, Height: Integer; Color: TColor): TBitmap;
{* һ Color ΪɫָС 24λλͼ }

implementation

//==============================================================================
// չɫʽת
//==============================================================================

//------------------------------------------------------------------------------
// HSL ɫ RGB ɫת
// 㷨Դ
// http:/www.r2m.com/win-developer-faq/graphics/8.html
// Grahame Marsh 12 October 1997
//------------------------------------------------------------------------------

// HSLɫתΪ RGB ɫ
function HSLToRGB(H, S, L: Double): TColor;
var
  M1, M2: Double;

  procedure CheckInput(var V: Double);
  begin
    if V < 0 then V := 0;
    if V > 1 then V := 1;
  end;

  function HueToColourValue(Hue: Double): Byte;
  var
    V: Double;
  begin
    if Hue < 0 then
      Hue := Hue + 1
    else if Hue > 1 then
      Hue := Hue - 1;
    if 6 * Hue < 1 then
      V := M1 + (M2 - M1) * Hue * 6
    else if 2 * Hue < 1 then
      V := M2
    else if 3 * Hue < 2 then
      V := M1 + (M2 - M1) * (2 / 3 - Hue) * 6
    else
      V := M1;
    Result := Round(255 * V)
  end;
var
  r, g, b: Byte;
begin
  H := H - Floor(H);                   // ֤ɫ 0..1 ֮
  CheckInput(S);
  CheckInput(L);
  if S = 0 then
  begin
    r := Round(255 * L);
    g := r;
    b := r
  end else
  begin
    if L <= 0.5 then
      M2 := L * (1 + S)
    else
      M2 := L + S - L * S;
    M1 := 2 * L - M2;
    r := HueToColourValue(H + 1 / 3);
    g := HueToColourValue(H);
    b := HueToColourValue(H - 1 / 3)
  end;
  Result := RGB(r, g, b);
end;

// HSL ɫΧתΪ RGB ɫ
function HSLRangeToRGB(H, S, L: Integer): TColor;
begin
  Assert(HSLRange > 1);
  Result := HSLToRGB(H / (HSLRange - 1), S / HSLRange, L / HSLRange)
end;

// RGB ɫתΪ HSL ɫ
procedure RGBToHSL(Color: TColor; out H, S, L: Double);
var
  r, g, b, D, Cmax, Cmin: Double;
begin
  Color := ColorToRGB(Color);
  r := GetRValue(Color) / 255;
  g := GetGValue(Color) / 255;
  b := GetBValue(Color) / 255;
  Cmax := Max(r, Max(g, b));
  Cmin := Min(r, Min(g, b));
  L := (Cmax + Cmin) / 2;
  if Cmax = Cmin then
  begin
    H := 0;
    S := 0
  end else
  begin
    D := Cmax - Cmin;
    if L < 0.5 then
      S := D / (Cmax + Cmin)
    else
      S := D / (2 - Cmax - Cmin);
    if r = Cmax then
      H := (g - b) / D
    else if g = Cmax then
      H := 2 + (b - r) / D
    else
      H := 4 + (r - g) / D;
    H := H / 6;
    if H < 0 then
      H := H + 1
  end
end;

// RGB ɫתΪ HSL ɫΧ
procedure RGBToHSLRange(Color: TColor; out H, S, L: Integer);
var
  Hd, Sd, Ld: Double;
begin
  RGBToHSL(Color, Hd, Sd, Ld);
  H := Round(Hd * (HSLRange - 1));
  S := Round(Sd * HSLRange);
  L := Round(Ld * HSLRange);
end;

// 滻ɫеɫֵµɫ
function ChangeHue(Color: TColor; Hue: Double): TColor;
var
  H, S, L: Double;
begin
  RGBToHSL(Color, H, S, L);
  Result := HSLToRGB(Hue, S, L);
end;

// 滻ɫеıͶֵµɫ
function ChangeSaturation(Color: TColor; Saturation: Double): TColor;
var
  H, S, L: Double;
begin
  RGBToHSL(Color, H, S, L);
  Result := HSLToRGB(H, Saturation, L);
end;

// 滻ɫеֵµɫ
function ChangeLighteness(Color: TColor; Lighteness: Double): TColor;
var
  H, S, L: Double;
begin
  RGBToHSL(Color, H, S, L);
  Result := HSLToRGB(H, S, Lighteness);
end;

// ɫеɫֵµɫ
function AdjustHue(Color: TColor; Added: Double): TColor;
var
  H, S, L: Double;
begin
  RGBToHSL(Color, H, S, L);
  Result := HSLToRGB(H + Added, S, L);
end;

// ɫеıͶֵµɫ
function AdjustSaturation(Color: TColor; Added: Double): TColor;
var
  H, S, L: Double;
begin
  RGBToHSL(Color, H, S, L);
  Result := HSLToRGB(H, S + Added, L);
end;

// ɫеֵµɫ
function AdjustLighteness(Color: TColor; Added: Double): TColor;
var
  H, S, L: Double;
begin
  RGBToHSL(Color, H, S, L);
  Result := HSLToRGB(H, S, L + Added);
end;

//------------------------------------------------------------------------------
// CMY ɫ RGB ɫת
// 㷨ṩCnPack 
//------------------------------------------------------------------------------

// CMYɫתΪRGB
function CMYToRGB(const C, M, Y: Byte): TColor;
var
  r, g, b: Byte;
begin
  r := 255 - C;
  g := 255 - M;
  b := 255 - Y;
  Result := RGB(r, g, b);
end;

// RGBɫתΪCMY
procedure RGBToCMY(const RGB: TColor; out C, M, Y: Byte);
var
  r, g, b: Byte;
begin
  DeRGB(RGB, r, g, b);
  C := 255 - r;
  M := 255 - g;
  Y := 255 - b;
end;

//------------------------------------------------------------------------------
// CMYK ɫ RGB ɫת
// 㷨ṩCnPack 
//------------------------------------------------------------------------------

// CMYK ɫתΪ RGB
function CMYKtoRGB(const C, M, Y, K: Byte): TColor;
var
  r, g, b: Byte;
begin
  r := 255 - (C + K);
  g := 255 - (M + K);
  b := 255 - (Y + K);
  Result := RGB(r, g, b);
end;

// RGB ɫתΪ CMYK
procedure RGBToCMYK(const RGB: TColor; out C, M, Y, K: Byte);
begin
  RGBToCMY(RGB, C, M, Y);
  K := MinIntValue([C, M, Y]);
  C := C - K;
  M := M - K;
  Y := Y - K;
end;

//==============================================================================
// ǿɫ
//==============================================================================

// Ҷɫ
function Gray(Intensity: Byte): TColor;
begin
  Result := Intensity shl 16 + Intensity shl 8 + Intensity;
end;

// ɫֵ
// 㷨ԴGraphic32
// 㷨޸ģܾ
function Intensity(Color: TColor): Byte;
asm
// :  RGB --> EAX
// :  (R * 61 + G * 174 + B * 20) / 256 --> AL
        MOV     ECX,EAX
        AND     EAX,$00FF00FF      // EAX <-   0 B 0 R
        IMUL    EAX,$0014003D
        AND     ECX,$0000FF00      // ECX <-   0 0 G 0
        IMUL    ECX,$0000AE00
        MOV     EDX,EAX
        SHR     ECX,8
        SHR     EDX,16
        ADD     EAX,ECX
        ADD     EAX,EDX
        SHR     EAX,8
end;

// ɫ
function RandomColor: TColor;
begin
  Result := HSLToRGB(Random, 0.75 + Random * 0.25, 0.3 + Random * 0.25);
end;

// ȡɫRGB
procedure DeRGB(Color: TColor; var r, g, b: Byte);
begin
  Color := ColorToRGB(Color);
  r := GetRValue(Color);
  g := GetGValue(Color);
  b := GetBValue(Color);
end;

//==============================================================================
// չλͼ
//==============================================================================

// һ Color ΪɫָС 24λλͼ
function CreateEmptyBmp24(Width, Height: Integer; Color: TColor): TBitmap;
type
  TRGBArray = array[0..65535] of TRGBTriple;
var
  r, g, b: Byte;
  x, y: Integer;
  P: ^TRGBArray;
begin
  Result := TBitmap.Create;
  Result.PixelFormat := pf24bit;
  Result.Width := Width;
  Result.Height := Height;
  DeRGB(Color, r, g, b);
  for y := 0 to Height - 1 do
  begin
    P := Result.ScanLine[y];
    for x := 0 to Width - 1 do
    begin
      with P[x] do
      begin
        rgbtBlue := b;
        rgbtGreen := g;
        rgbtRed := r;
      end;
    end;
  end;
end;

end.
