// 插入电头 消息尾插件
UE.registerUI('dateline',function(editor,uiName){

	dateline_title="电头";
	
	editor.registerCommand(uiName,{
		execCommand:function(cmdName,value){
			this.execCommand('insertHtml', value);
		},
		queryCommandValue:function(){
			return 0;
		}
	});
	
	var dateline_content = G_Options["format"]["dateline"];
	var dateline_content_split = dateline_content.split("|-|");


	var items = [];
	for (var key in dateline_content_split) {
		items.push({
			label: dateline_content_split[key],
			value: dateline_content_split[key],
			renderLabelHtml:function () {
				return '<div class="edui-label %%-label" style="height:20px;font-size:14px;line-height:20px;margin:5px 0;">' + this.label + '</div>';
			}
		});
	}
	var combox = new UE.ui.Combox({
		editor:editor,
		items:items,
		onselect:function (t, index) {
			editor.execCommand(uiName, this.items[index].value);
		},
		title:dateline_title,
		initValue:dateline_title
	});

	editor.addListener('selectionchange', function (type, causeByUi, uiReady) {
		if (!uiReady) {
			var state = editor.queryCommandState(uiName);
			if (state == -1) {
				combox.setDisabled(true);
			} else {
				combox.setDisabled(false);
				var value = editor.queryCommandValue(uiName);
				if(!value){
					//combox.setValue(dateline_title);
					return;
				}
				//ie下从源码模式切换回来时，字体会带单引号，而且会有逗号
				value && (value = value.replace(/['"]/g, '').split(',')[0]);
				combox.setValue(dateline_title);

			}
		}

	});
	return combox;
},6,0);


UE.registerUI('editorname',function(editor,uiName){

	dateline_title="新闻采编";
	
	editor.registerCommand(uiName,{
		execCommand:function(cmdName,value){
			this.execCommand('insertHtml', value);
		},
		queryCommandValue:function(){
			return 0;
		}
	});
	
	var editorname_content = G_Options["format"]["editorname"];
	var editorname_content_split = editorname_content.split("|-|");


	var items = [];
	for (var key in editorname_content_split) {
		items.push({
			label: editorname_content_split[key],
			value: editorname_content_split[key],
			renderLabelHtml:function () {
				return '<div class="edui-label %%-label" style="height:20px;font-size:14px;line-height:20px;margin:5px 0;">' + this.label + '</div>';
			}
		});
	}
	var combox = new UE.ui.Combox({
		editor:editor,
		items:items,
		onselect:function (t, index) {
			editor.execCommand(uiName, this.items[index].value);
		},
		title:dateline_title,
		initValue:dateline_title
	});

	editor.addListener('selectionchange', function (type, causeByUi, uiReady) {
		if (!uiReady) {
			var state = editor.queryCommandState(uiName);
			if (state == -1) {
				combox.setDisabled(true);
			} else {
				combox.setDisabled(false);
				var value = editor.queryCommandValue(uiName);
				if(!value){
					//combox.setValue(dateline_title);
					return;
				}
				//ie下从源码模式切换回来时，字体会带单引号，而且会有逗号
				value && (value = value.replace(/['"]/g, '').split(',')[0]);
				combox.setValue(dateline_title);

			}
		}

	});
	return combox;
},7,0);