/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.NSRegistry;
import com.sun.deploy.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class NSPreferences {
    private static String parseValue(String string) {
        int n;
        int n2 = string.indexOf(",");
        if (n2 != -1 && (n = string.lastIndexOf(")")) != -1 && n2 + 1 < n) {
            return string.substring(n2 + 1, n).trim();
        }
        return null;
    }

    private static String parseString(String string) {
        String string2 = NSPreferences.parseValue(string);
        if (string2 != null && string2.length() > 1 && string2.startsWith("\"") && string2.endsWith("\"")) {
            return string2.substring(1, string2.length() - 1);
        }
        return null;
    }

    private static int parseInt(String string) {
        String string2 = NSPreferences.parseValue(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static List parseList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(NSPreferences.parseString(string), ", ");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add("*" + stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private static boolean isKeyword(String string, String string2) {
        int n = string.indexOf("(");
        return n != -1 && string.substring(n + 1, string.length()).startsWith("\"" + string2 + "\"");
    }

    private static boolean getDeaultValue(File file) {
        boolean bl = false;
        try {
            if (file.exists()) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("pref") || !NSPreferences.isKeyword(string, "config.use_system_prefs")) continue;
                    bl = NSPreferences.parseValue(string).equals("true");
                    break;
                }
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        return bl;
    }

    private static boolean getDefaultValueOfUseSystemPrefs() {
        boolean bl = false;
        File file = new File("/usr/sfw/lib/mozilla/greprefs/all.js");
        File file2 = new File("/usr/lib/mozilla/greprefs/all.js");
        bl = NSPreferences.getDeaultValue(file) || NSPreferences.getDeaultValue(file2);
        return bl;
    }

    protected static void parseFile(File file, BrowserProxyInfo browserProxyInfo, float f, boolean bl) {
        block39: {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                String string2 = null;
                String string3 = null;
                int n = -1;
                int n2 = -1;
                boolean bl2 = NSPreferences.getDefaultValueOfUseSystemPrefs();
                while ((string = bufferedReader.readLine()) != null) {
                    URL uRL;
                    if (!string.startsWith("user_pref")) continue;
                    if (NSPreferences.isKeyword(string, "network.proxy.type")) {
                        n = NSPreferences.parseInt(string);
                        if (n == 3 && System.getProperty("os.name").equals("SunOS") && f >= 4.0f) {
                            browserProxyInfo.setType(0);
                            n = 0;
                        } else {
                            browserProxyInfo.setType(n);
                        }
                        Trace.msgNetPrintln("net.proxy.browser.proxyEnable", new Object[]{new Integer(n)});
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.http")) {
                        string2 = NSPreferences.parseString(string);
                        try {
                            URL uRL2 = new URL(string2);
                            string2 = uRL2.getHost();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.http=" + string2);
                        browserProxyInfo.setHttpHost(string2);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.http_port")) {
                        n2 = NSPreferences.parseInt(string);
                        Trace.netPrintln("    network.proxy.http_port=" + n2);
                        browserProxyInfo.setHttpPort(n2);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.ssl")) {
                        String string4 = NSPreferences.parseString(string);
                        try {
                            uRL = new URL(string4);
                            string4 = uRL.getHost();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.ssl=" + string4);
                        browserProxyInfo.setHttpsHost(string4);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.ssl_port")) {
                        int n3 = NSPreferences.parseInt(string);
                        Trace.netPrintln("    network.proxy.ssl_port=" + n3);
                        browserProxyInfo.setHttpsPort(n3);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.ftp")) {
                        String string5 = NSPreferences.parseString(string);
                        try {
                            uRL = new URL(string5);
                            string5 = uRL.getHost();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.ftp=" + string5);
                        browserProxyInfo.setFtpHost(string5);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.ftp_port")) {
                        int n4 = NSPreferences.parseInt(string);
                        Trace.netPrintln("    network.proxy.ftp_port=" + n4);
                        browserProxyInfo.setFtpPort(n4);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.gopher")) {
                        String string6 = NSPreferences.parseString(string);
                        try {
                            uRL = new URL(string6);
                            string6 = uRL.getHost();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.gopher=" + string6);
                        browserProxyInfo.setGopherHost(string6);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.gopher_port")) {
                        int n5 = NSPreferences.parseInt(string);
                        Trace.netPrintln("    network.proxy.gopher_port=" + n5);
                        browserProxyInfo.setGopherPort(n5);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.socks")) {
                        String string7 = NSPreferences.parseString(string);
                        try {
                            uRL = new URL(string7);
                            string7 = uRL.getHost();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.socks=" + string7);
                        browserProxyInfo.setSocksHost(string7);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.socks_port")) {
                        int n6 = NSPreferences.parseInt(string);
                        Trace.netPrintln("    network.proxy.socks_port=" + n6);
                        browserProxyInfo.setSocksPort(n6);
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.no_proxies_on")) {
                        Trace.msgNetPrintln("net.proxy.browser.proxyOverride", new Object[]{NSPreferences.parseString(string)});
                        browserProxyInfo.setOverrides(NSPreferences.parseList(string));
                        continue;
                    }
                    if (NSPreferences.isKeyword(string, "network.proxy.autoconfig_url")) {
                        string3 = NSPreferences.parseString(string);
                        Trace.msgNetPrintln("net.proxy.browser.autoConfigURL", new Object[]{string3});
                        browserProxyInfo.setAutoConfigURL(string3);
                        continue;
                    }
                    if (!NSPreferences.isKeyword(string, "config.use_system_prefs")) continue;
                    if (NSPreferences.parseValue(string).equals("true")) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                }
                bufferedReader.close();
                if (bl && bl2) {
                    browserProxyInfo.setType(4);
                    return;
                }
                if (n == -1 && System.getProperty("os.name").equals("SunOS") && f >= 6.0f) {
                    browserProxyInfo.setType(2);
                    return;
                }
                if (n == -1 && System.getProperty("os.name").equals("Linux") && f >= 4.0f) {
                    browserProxyInfo.setType(0);
                    return;
                }
                if (n == -1 && System.getProperty("os.name").indexOf("Windows") != -1 && f >= 4.0f && f < 5.0f) {
                    browserProxyInfo.setType(0);
                    return;
                }
                if (string2 != null && n2 == -1 && System.getProperty("os.name").indexOf("Windows") != -1 && f >= 6.0f) {
                    n2 = 8080;
                    browserProxyInfo.setHttpPort(8080);
                }
                if (string2 != null && n2 != -1 && n == -1 && System.getProperty("os.name").indexOf("Windows") != -1 && f >= 6.0f) {
                    n = 1;
                    browserProxyInfo.setType(1);
                }
                if (n == -1 && string3 != null) {
                    browserProxyInfo.setType(2);
                }
                if (n == 4 && f >= 6.0f) {
                    browserProxyInfo.setType(2);
                    browserProxyInfo.setAutoProxyDetectionEnabled(true);
                }
            }
            catch (IOException iOException) {
                if (bufferedReader == null) break block39;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
    }

    public static File getNS6PrefsFile(File file) throws IOException {
        return new File(NSPreferences.getNS6UserProfileDirectory(file), "prefs.js");
    }

    public static String getNS6UserProfileDirectory(File file) throws IOException {
        NSRegistry nSRegistry = new NSRegistry().open(file);
        String string = null;
        String string2 = null;
        if (nSRegistry != null) {
            string2 = nSRegistry.get("Common/Profiles/CurrentProfile");
            if (string2 != null) {
                string = nSRegistry.get("Common/Profiles/" + string2 + "/directory");
            }
            nSRegistry.close();
        }
        if (string == null) {
            throw new IOException();
        }
        return string;
    }

    public static String getFireFoxUserProfileDirectory(File file) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        boolean bl2 = false;
        if (file.exists()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().toLowerCase().equals("[profile0]")) {
                    bl2 = true;
                    continue;
                }
                if (bl2 && string2.toLowerCase().startsWith("isrelative=")) {
                    try {
                        int n = Integer.parseInt(string2.substring("isrelative=".length()));
                        bl = n != 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                    }
                    continue;
                }
                if (!bl2 || !string2.toLowerCase().startsWith("path=")) continue;
                string = string2.substring("path=".length());
                break;
            }
        }
        if (string != null) {
            if (bl) {
                int n = file.toString().length() - 12;
                string3 = file.toString().substring(0, n) + string;
            } else {
                string3 = string;
            }
        }
        if (string3 == null) {
            throw new IOException();
        }
        return string3;
    }
}

