/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class WindowsIconFactory
implements Serializable {
    private static Icon frame_closeIcon;
    private static Icon frame_iconifyIcon;
    private static Icon frame_maxIcon;
    private static Icon frame_minIcon;
    private static Icon frame_resizeIcon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon createFrameCloseIcon() {
        if (frame_closeIcon == null) {
            frame_closeIcon = new FrameButtonIcon(TMSchema.Part.WP_CLOSEBUTTON);
        }
        return frame_closeIcon;
    }

    public static Icon createFrameIconifyIcon() {
        if (frame_iconifyIcon == null) {
            frame_iconifyIcon = new FrameButtonIcon(TMSchema.Part.WP_MINBUTTON);
        }
        return frame_iconifyIcon;
    }

    public static Icon createFrameMaximizeIcon() {
        if (frame_maxIcon == null) {
            frame_maxIcon = new FrameButtonIcon(TMSchema.Part.WP_MAXBUTTON);
        }
        return frame_maxIcon;
    }

    public static Icon createFrameMinimizeIcon() {
        if (frame_minIcon == null) {
            frame_minIcon = new FrameButtonIcon(TMSchema.Part.WP_RESTOREBUTTON);
        }
        return frame_minIcon;
    }

    public static Icon createFrameResizeIcon() {
        if (frame_resizeIcon == null) {
            frame_resizeIcon = new ResizeIcon();
        }
        return frame_resizeIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                TMSchema.State state;
                if (buttonModel.isSelected()) {
                    state = TMSchema.State.CHECKEDNORMAL;
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.CHECKEDDISABLED;
                    } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        state = TMSchema.State.CHECKEDPRESSED;
                    } else if (buttonModel.isRollover()) {
                        state = TMSchema.State.CHECKEDHOT;
                    }
                } else {
                    state = TMSchema.State.UNCHECKEDNORMAL;
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.UNCHECKEDDISABLED;
                    } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        state = TMSchema.State.UNCHECKEDPRESSED;
                    } else if (buttonModel.isRollover()) {
                        state = TMSchema.State.UNCHECKEDHOT;
                    }
                }
                TMSchema.Part part = TMSchema.Part.BP_CHECKBOX;
                xPStyle.getSkin(component, part).paintSkin(graphics, n, n2, state);
            } else {
                if (!jCheckBox.isBorderPaintedFlat()) {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                    graphics.drawLine(n, n2, n + 11, n2);
                    graphics.drawLine(n, n2 + 1, n, n2 + 11);
                    graphics.setColor(UIManager.getColor("CheckBox.highlight"));
                    graphics.drawLine(n + 12, n2, n + 12, n2 + 12);
                    graphics.drawLine(n, n2 + 12, n + 11, n2 + 12);
                    graphics.setColor(UIManager.getColor("CheckBox.darkShadow"));
                    graphics.drawLine(n + 1, n2 + 1, n + 10, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 10);
                    graphics.setColor(UIManager.getColor("CheckBox.light"));
                    graphics.drawLine(n + 1, n2 + 11, n + 11, n2 + 11);
                    graphics.drawLine(n + 11, n2 + 1, n + 11, n2 + 10);
                    if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                        graphics.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        graphics.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    graphics.fillRect(n + 2, n2 + 2, 9, 9);
                } else {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                    graphics.drawRect(n + 1, n2 + 1, 10, 10);
                    if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                        graphics.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        graphics.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    graphics.fillRect(n + 2, n2 + 2, 9, 9);
                }
                if (buttonModel.isEnabled()) {
                    graphics.setColor(UIManager.getColor("CheckBox.foreground"));
                } else {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                }
                if (buttonModel.isSelected()) {
                    graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 3);
                    graphics.drawLine(n + 8, n2 + 4, n + 9, n2 + 4);
                    graphics.drawLine(n + 7, n2 + 5, n + 9, n2 + 5);
                    graphics.drawLine(n + 6, n2 + 6, n + 8, n2 + 6);
                    graphics.drawLine(n + 3, n2 + 7, n + 7, n2 + 7);
                    graphics.drawLine(n + 4, n2 + 8, n + 6, n2 + 8);
                    graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                    graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                    graphics.drawLine(n + 3, n2 + 6, n + 4, n2 + 6);
                }
            }
        }

        public int getIconWidth() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin(null, TMSchema.Part.BP_CHECKBOX).getWidth();
            }
            return 13;
        }

        public int getIconHeight() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin(null, TMSchema.Part.BP_CHECKBOX).getHeight();
            }
            return 13;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = buttonModel.isSelected();
            if (bl) {
                graphics.drawLine(n + 9, (n2 -= this.getIconHeight() / 2) + 3, n + 9, n2 + 3);
                graphics.drawLine(n + 8, n2 + 4, n + 9, n2 + 4);
                graphics.drawLine(n + 7, n2 + 5, n + 9, n2 + 5);
                graphics.drawLine(n + 6, n2 + 6, n + 8, n2 + 6);
                graphics.drawLine(n + 3, n2 + 7, n + 7, n2 + 7);
                graphics.drawLine(n + 4, n2 + 8, n + 6, n2 + 8);
                graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                graphics.drawLine(n + 3, n2 + 6, n + 4, n2 + 6);
            }
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class FrameButtonIcon
    implements Icon,
    Serializable {
        private TMSchema.Part part;

        private FrameButtonIcon(TMSchema.Part part) {
            this.part = part;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                boolean bl;
                XPStyle.Skin skin = xPStyle.getSkin(component, this.part);
                JButton jButton = (JButton)component;
                ButtonModel buttonModel = jButton.getModel();
                JInternalFrame jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, jButton);
                boolean bl2 = bl = jInternalFrame != null && jInternalFrame.isSelected();
                TMSchema.State state = bl ? (!buttonModel.isEnabled() ? TMSchema.State.DISABLED : (buttonModel.isArmed() && buttonModel.isPressed() ? TMSchema.State.PUSHED : (buttonModel.isRollover() ? TMSchema.State.HOT : TMSchema.State.NORMAL))) : (!buttonModel.isEnabled() ? TMSchema.State.INACTIVEDISABLED : (buttonModel.isArmed() && buttonModel.isPressed() ? TMSchema.State.INACTIVEPUSHED : (buttonModel.isRollover() ? TMSchema.State.INACTIVEHOT : TMSchema.State.INACTIVENORMAL)));
                skin.paintSkin(graphics, 0, 0, n3, n4, state);
            } else {
                graphics.setColor(Color.black);
                int n5 = n3 / 12 + 2;
                int n6 = n4 / 5;
                int n7 = n4 - n6 * 2 - 1;
                int n8 = n3 * 3 / 4 - 3;
                int n9 = Math.max(n4 / 8, 2);
                int n10 = Math.max(n3 / 15, 1);
                if (this.part == TMSchema.Part.WP_CLOSEBUTTON) {
                    int n11 = n3 > 47 ? 6 : (n3 > 37 ? 5 : (n3 > 26 ? 4 : (n3 > 16 ? 3 : (n3 > 12 ? 2 : 1))));
                    n6 = n4 / 12 + 2;
                    if (n11 == 1) {
                        if (n8 % 2 == 1) {
                            ++n5;
                            ++n8;
                        }
                        graphics.drawLine(n5, n6, n5 + n8 - 2, n6 + n8 - 2);
                        graphics.drawLine(n5 + n8 - 2, n6, n5, n6 + n8 - 2);
                    } else if (n11 == 2) {
                        if (n8 > 6) {
                            ++n5;
                            --n8;
                        }
                        graphics.drawLine(n5, n6, n5 + n8 - 2, n6 + n8 - 2);
                        graphics.drawLine(n5 + n8 - 2, n6, n5, n6 + n8 - 2);
                        graphics.drawLine(n5 + 1, n6, n5 + n8 - 1, n6 + n8 - 2);
                        graphics.drawLine(n5 + n8 - 1, n6, n5 + 1, n6 + n8 - 2);
                    } else {
                        graphics.drawLine(n5 += 2, ++n6, n5 + (n8 -= 2) - 1, n6 + n8 - 1);
                        graphics.drawLine(n5 + n8 - 1, n6, n5, n6 + n8 - 1);
                        graphics.drawLine(n5 + 1, n6, n5 + n8 - 1, n6 + n8 - 2);
                        graphics.drawLine(n5 + n8 - 2, n6, n5, n6 + n8 - 2);
                        graphics.drawLine(n5, n6 + 1, n5 + n8 - 2, n6 + n8 - 1);
                        graphics.drawLine(n5 + n8 - 1, n6 + 1, n5 + 1, n6 + n8 - 1);
                        for (int i = 4; i <= n11; ++i) {
                            graphics.drawLine(n5 + i - 2, n6, n5 + n8 - 1, n6 + n8 - i + 1);
                            graphics.drawLine(n5, n6 + i - 2, n5 + n8 - i + 1, n6 + n8 - 1);
                            graphics.drawLine(n5 + n8 - i + 1, n6, n5, n6 + n8 - i + 1);
                            graphics.drawLine(n5 + n8 - 1, n6 + i - 2, n5 + i - 2, n6 + n8 - 1);
                        }
                    }
                } else if (this.part == TMSchema.Part.WP_MINBUTTON) {
                    graphics.fillRect(n5, n6 + n7 - n9, n8 - n8 / 3, n9);
                } else if (this.part == TMSchema.Part.WP_MAXBUTTON) {
                    graphics.fillRect(n5, n6, n8, n9);
                    graphics.fillRect(n5, n6, n10, n7);
                    graphics.fillRect(n5 + n8 - n10, n6, n10, n7);
                    graphics.fillRect(n5, n6 + n7 - n10, n8, n10);
                } else if (this.part == TMSchema.Part.WP_RESTOREBUTTON) {
                    graphics.fillRect(n5 + n8 / 3, n6, n8 - n8 / 3, n9);
                    graphics.fillRect(n5 + n8 / 3, n6, n10, n7 / 3);
                    graphics.fillRect(n5 + n8 - n10, n6, n10, n7 - n7 / 3);
                    graphics.fillRect(n5 + n8 - n8 / 3, n6 + n7 - n7 / 3 - n10, n8 / 3, n10);
                    graphics.fillRect(n5, n6 + n7 / 3, n8 - n8 / 3, n9);
                    graphics.fillRect(n5, n6 + n7 / 3, n10, n7 - n7 / 3);
                    graphics.fillRect(n5 + n8 - n8 / 3 - n10, n6 + n7 / 3, n10, n7 - n7 / 3);
                    graphics.fillRect(n5, n6 + n7 - n10, n8 - n8 / 3, n10);
                }
            }
        }

        public int getIconWidth() {
            int n;
            if (XPStyle.getXP() != null) {
                n = UIManager.getInt("InternalFrame.titleButtonHeight") - 2;
                Dimension dimension = XPStyle.getPartSize(TMSchema.Part.WP_CLOSEBUTTON, TMSchema.State.NORMAL);
                if (dimension != null && dimension.width != 0 && dimension.height != 0) {
                    n = (int)((float)n * (float)dimension.width / (float)dimension.height);
                }
            } else {
                n = UIManager.getInt("InternalFrame.titleButtonWidth") - 2;
            }
            if (XPStyle.getXP() != null) {
                n -= 2;
            }
            return n;
        }

        public int getIconHeight() {
            int n = UIManager.getInt("InternalFrame.titleButtonHeight") - 4;
            return n;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            if (WindowsGraphicsUtils.isLeftToRight(component)) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemCheckIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                TMSchema.State state;
                TMSchema.Part part = TMSchema.Part.BP_RADIOBUTTON;
                XPStyle.Skin skin = xPStyle.getSkin(abstractButton, part);
                boolean bl = false;
                if (buttonModel.isSelected()) {
                    state = TMSchema.State.CHECKEDNORMAL;
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.CHECKEDDISABLED;
                    } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        state = TMSchema.State.CHECKEDPRESSED;
                    } else if (buttonModel.isRollover()) {
                        state = TMSchema.State.CHECKEDHOT;
                    }
                } else {
                    state = TMSchema.State.UNCHECKEDNORMAL;
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.UNCHECKEDDISABLED;
                    } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        state = TMSchema.State.UNCHECKEDPRESSED;
                    } else if (buttonModel.isRollover()) {
                        state = TMSchema.State.UNCHECKEDHOT;
                    }
                }
                skin.paintSkin(graphics, n, n2, state);
            } else {
                if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                    graphics.setColor(UIManager.getColor("RadioButton.background"));
                } else {
                    graphics.setColor(UIManager.getColor("RadioButton.interiorBackground"));
                }
                graphics.fillRect(n + 2, n2 + 2, 8, 8);
                graphics.setColor(UIManager.getColor("RadioButton.shadow"));
                graphics.drawLine(n + 4, n2 + 0, n + 7, n2 + 0);
                graphics.drawLine(n + 2, n2 + 1, n + 3, n2 + 1);
                graphics.drawLine(n + 8, n2 + 1, n + 9, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 3);
                graphics.drawLine(n + 0, n2 + 4, n + 0, n2 + 7);
                graphics.drawLine(n + 1, n2 + 8, n + 1, n2 + 9);
                graphics.setColor(UIManager.getColor("RadioButton.highlight"));
                graphics.drawLine(n + 2, n2 + 10, n + 3, n2 + 10);
                graphics.drawLine(n + 4, n2 + 11, n + 7, n2 + 11);
                graphics.drawLine(n + 8, n2 + 10, n + 9, n2 + 10);
                graphics.drawLine(n + 10, n2 + 9, n + 10, n2 + 8);
                graphics.drawLine(n + 11, n2 + 7, n + 11, n2 + 4);
                graphics.drawLine(n + 10, n2 + 3, n + 10, n2 + 2);
                graphics.setColor(UIManager.getColor("RadioButton.darkShadow"));
                graphics.drawLine(n + 4, n2 + 1, n + 7, n2 + 1);
                graphics.drawLine(n + 2, n2 + 2, n + 3, n2 + 2);
                graphics.drawLine(n + 8, n2 + 2, n + 9, n2 + 2);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
                graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 7);
                graphics.drawLine(n + 2, n2 + 8, n + 2, n2 + 8);
                graphics.setColor(UIManager.getColor("RadioButton.light"));
                graphics.drawLine(n + 2, n2 + 9, n + 3, n2 + 9);
                graphics.drawLine(n + 4, n2 + 10, n + 7, n2 + 10);
                graphics.drawLine(n + 8, n2 + 9, n + 9, n2 + 9);
                graphics.drawLine(n + 9, n2 + 8, n + 9, n2 + 8);
                graphics.drawLine(n + 10, n2 + 7, n + 10, n2 + 4);
                graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 3);
                if (buttonModel.isSelected()) {
                    if (buttonModel.isEnabled()) {
                        graphics.setColor(UIManager.getColor("RadioButton.foreground"));
                    } else {
                        graphics.setColor(UIManager.getColor("RadioButton.shadow"));
                    }
                    graphics.fillRect(n + 4, n2 + 5, 4, 2);
                    graphics.fillRect(n + 5, n2 + 4, 2, 4);
                }
            }
        }

        public int getIconWidth() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin(null, TMSchema.Part.BP_RADIOBUTTON).getWidth();
            }
            return 13;
        }

        public int getIconHeight() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin(null, TMSchema.Part.BP_RADIOBUTTON).getHeight();
            }
            return 13;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isSelected()) {
                graphics.fillRoundRect(n + 3, n2 + 3, this.getIconWidth() - 6, this.getIconHeight() - 6, 4, 4);
            }
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }
    }

    private static class ResizeIcon
    implements Icon,
    Serializable {
        private ResizeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("InternalFrame.resizeIconHighlight"));
            graphics.drawLine(0, 11, 11, 0);
            graphics.drawLine(4, 11, 11, 4);
            graphics.drawLine(8, 11, 11, 8);
            graphics.setColor(UIManager.getColor("InternalFrame.resizeIconShadow"));
            graphics.drawLine(1, 11, 11, 1);
            graphics.drawLine(2, 11, 11, 2);
            graphics.drawLine(5, 11, 11, 5);
            graphics.drawLine(6, 11, 11, 6);
            graphics.drawLine(9, 11, 11, 9);
            graphics.drawLine(10, 11, 11, 10);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }
}

