/*
 * spectrogram.vsh
 *
 * Copyright (c) 2012 SuperMegaUltraGroovy, Inc.
 */
 
#version 150

vec3 HUEtoRGB( in float h ) {
    float r = abs( h * 6.0 - 3.0 ) - 1.0;
    float g = 2.0 - abs( h * 6.0 - 2.0 );
    float b = 2.0 - abs( h * 6.0 - 4.0 );
    return clamp( vec3( r, g, b ), vec3( 0, 0, 0 ), vec3( 1, 1, 1 ) );
}

vec3 HSLtoRGB( in vec3 hsl ) {
    vec3 rgb = HUEtoRGB( hsl.x );
    float c = ( 1.0 - abs( 2.0 * hsl.z - 1.0 ) ) * hsl.y;
    return ( rgb - 0.5 ) * c + hsl.z;
}

uniform sampler2DRect tex;
uniform float intensity;
uniform vec4 color;

in vec2 texCoordV;
out vec4 fragColor;

//const float hue = 210.0 / 360.0;
//HSLtoRGB( vec3( hue, 0.3, 0.36 ) )

void main()
{
    float value = ( ( texture(tex, texCoordV).r ) * intensity );
    vec4 foreColor = vec4( color.rgb, clamp( value, 0.0, 1.0 ) * color.a );
    fragColor = foreColor;
}
