/*
 * gradient.vsh
 *
 * Copyright (c) 2012 SuperMegaUltraGroovy, Inc.
 */

#version 150

uniform mat4 posMatrix;

in vec2 position;
in float texCoord;
in vec4 color;

out vec2 texCoordV;
out vec4 colorV;

void main() {
    colorV = color;

    vec4 pos = vec4( position, 0, 1 ) * posMatrix;
    texCoordV = vec2( texCoord, ( pos.y + 1.0 ) * 0.5 );
    
    gl_Position = pos;
}