﻿//------------------------------------------------------------------------------
// A simple demo extension to add a new page in the sidebar.
// Written by Rickard Johansson
//------------------------------------------------------------------------------

TElPageControl aPage;
TElTabSheet aTab;
TComboBox aBox;
TListBox aList;

// This function is called from RJ TextEd to free objects
void ExitExtension() 
{
	// Free objects. First free added objects to the new tab, then
	// the tab sheet.
	aList.Free;
	aBox.Free;
	aPage.RemovePage(aTab);
}

void FillComboBox()
{
	aBox.Items.Add("Item 1");
	aBox.Items.Add("Item 2");
}

void FillListBox(int index)
{
	aList.Items.Clear;
	if (index == 0)
	{
		aList.Items.Add("List item 1");
		aList.Items.Add("List item 2");
		aList.Items.Add("List item 3");
		aList.Items.Add("List item 4");
	}
	else if (index == 1)
	{
		aList.Items.Add("List item 5");
		aList.Items.Add("List item 6");
		aList.Items.Add("List item 7");
		aList.Items.Add("List item 8");
	};
}

// Executed when the user click the sub menu
void OnComboBoxClick(TObject Sender) 
{
	TComboBox b = TComboBox(Sender);
	FillListBox(b.ItemIndex);
}

void OnListBoxClick(TObject Sender) 
{
	TListBox l = TListBox(Sender);
	int n = l.ItemIndex;
	string s = l.Items[n];
	ShowMessage(s);
}

// Main function
{
	// Create a page in sidebar
	aPage = MainApp.GetSidebarPageControl;
	aTab = aPage.NewPage;
	aTab.Name = "aTabSheet";
	aTab.ImageIndex = 48;
	aTab.Caption = "Test";
		
	// Add a drop down box
	aBox = TComboBox.Create(aTab);
	aBox.Parent = aTab;
	aBox.OnClick = &OnComboBoxClick;
	aBox.Name = "aComboBox";
	aBox.Align = alTop;
	FillComboBox;
	
	// Add a list box
	aList = TListBox.Create(aTab);
	aList.Parent = aTab;
	aList.OnClick = &OnListBoxClick;
	aList.Name = "aListBox";
	aList.Align = alClient;
	
	// Select first item in drop down list
	aBox.ItemIndex = 0;
	FillListBox(0);
}



