// Wrap with Abbreviation script for use in RJ TextEd
// Usage: >jx emWrapWithAbbreviation.js <abbr> <syntax> <infilepath>
var editor = require('./lib/editor');
var parser = require('./lib/parser/abbreviation');
var action = require('./lib/action/wrapWithAbbreviation');
var utils  = require('./lib/utils/common');  
var expression = process.argv[2];
var type = process.argv[3];
var path = process.argv[4];

var run = function(abbr, content) {
	if (abbr && content) {
		content = utils.escapeText(content);
		return parser.expand(abbr, {
			pastedContent: content, 
			syntax: type, 
			profile: 'plain'
		});
	}

	editor.setPromptOutput(abbr);
	action.wrapWithAbbreviationAction(editor);
}; 

// Read file content to string
var fs = require('fs');
var seltext = fs.readFileSync(path, "utf8");	

// Create a selection in the editor object
editor.replaceContent(seltext);
var len = editor.getContent().length;
editor.createSelection(0, len); 

// Execute abbreviation
run(expression); 

// Get the expanded selection
var text = editor.getContent();

// Output the result
console.log(text);
