﻿//------------------------------------------------------------------------------
// A simple demo extension to add a new menu after the "Help" menu.
// Written by Rickard Johansson
//------------------------------------------------------------------------------

TElMenuItem mMain;
TElMenuItem mSub1,mSub2;
TTimer tm;

// This function is called from RJ TextEd to free objects
void ExitExtension() 
{
	// Free objects in reverse order they 
	// were added to the menu.
	mSub2.Free;
	mSub1.Free;
	mMain.Free;
	tm.Free;
}

// Executed by the timer
void OnTimerMessage(TObject Sender) 
{
	tm.Enabled = false;
	ShowMessage("Hello World!");
}

// Executed when the user click the sub menu
void OnShowMessage(TObject Sender) 
{
	ShowMessage("Hello World!!!");
}

// Executed when the user click the sub menu
void OnShowTimerMessage(TObject Sender) 
{
	// Start timer. After ~4 seconds the function OnTimerMessage is executed.
	tm.Enabled = true;
}

// Main function
{
	// Create a timer component
	tm = TTimer.Create(nil);
	tm.Interval = 4000; // Interval in milli seconds
	tm.OnTimer = &OnTimerMessage;
	
	// Create a main menu item "Test Menu"
	TElMainMenu M = MainApp.GetMainMenu;
	mMain = TElMenuItem.Create(M);
	mMain.Caption = "Test Menu";
	mMain.Name = "mTestMenu";
	M.Items.Add(mMain);
	
	// Add a sub menu to "Test Menu"
	mSub1 = TElMenuItem.Create(mMain);
	mSub1.Caption = "Show message...";
	mSub1.OnClick = &OnShowMessage;
	mSub1.Name = "ShowMessage";
	mMain.Add(mSub1);
	
	// Add a sub menu to "Test Menu"
	mSub2 = TElMenuItem.Create(mMain);
	mSub2.Caption = "Show message after 4 seconds...";
	mSub2.OnClick = &OnShowTimerMessage;
	mSub2.Name = "ShowTimerMessage";
	mMain.Add(mSub2);
}

