/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.IdFunctionObject;
import sun.org.mozilla.javascript.internal.IdScriptableObject;
import sun.org.mozilla.javascript.internal.NativeArray;
import sun.org.mozilla.javascript.internal.NativeBoolean;
import sun.org.mozilla.javascript.internal.NativeNumber;
import sun.org.mozilla.javascript.internal.NativeObject;
import sun.org.mozilla.javascript.internal.NativeString;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.json.JsonParser;

final class NativeJSON
extends IdScriptableObject {
    private static final Object JSON_TAG = "JSON";
    private static final int MAX_STRINGIFY_GAP_LENGTH = 10;
    private static final int Id_toSource = 1;
    private static final int Id_parse = 2;
    private static final int Id_stringify = 3;
    private static final int LAST_METHOD_ID = 3;
    private static final int MAX_ID = 3;

    static void init(Scriptable scriptable, boolean bl) {
        NativeJSON nativeJSON = new NativeJSON();
        nativeJSON.activatePrototypeMap(3);
        nativeJSON.setPrototype(NativeJSON.getObjectPrototype(scriptable));
        nativeJSON.setParentScope(scriptable);
        if (bl) {
            nativeJSON.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "JSON", nativeJSON, 2);
    }

    private NativeJSON() {
    }

    @Override
    public String getClassName() {
        return "JSON";
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n <= 3) {
            switch (n) {
                case 1: {
                    n2 = 0;
                    string = "toSource";
                    break;
                }
                case 2: {
                    n2 = 2;
                    string = "parse";
                    break;
                }
                case 3: {
                    n2 = 3;
                    string = "stringify";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(n));
                }
            }
        } else {
            throw new IllegalStateException(String.valueOf(n));
        }
        this.initPrototypeMethod(JSON_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(JSON_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return "JSON";
            }
            case 2: {
                String string = ScriptRuntime.toString(objectArray, 0);
                Object object = null;
                if (objectArray.length > 1) {
                    object = objectArray[1];
                }
                if (object instanceof Callable) {
                    return NativeJSON.parse(context, scriptable, string, (Callable)object);
                }
                return NativeJSON.parse(context, scriptable, string);
            }
            case 3: {
                Object object = null;
                Object object2 = null;
                Object object3 = null;
                switch (objectArray.length) {
                    default: {
                        object3 = objectArray[2];
                    }
                    case 2: {
                        object2 = objectArray[1];
                    }
                    case 1: {
                        object = objectArray[0];
                    }
                    case 0: 
                }
                return NativeJSON.stringify(context, scriptable, object, object2, object3);
            }
        }
        throw new IllegalStateException(String.valueOf(n));
    }

    private static Object parse(Context context, Scriptable scriptable, String string) {
        try {
            return new JsonParser(context, scriptable).parseValue(string);
        }
        catch (JsonParser.ParseException parseException) {
            throw ScriptRuntime.constructError("SyntaxError", parseException.getMessage());
        }
    }

    public static Object parse(Context context, Scriptable scriptable, String string, Callable callable) {
        Object object = NativeJSON.parse(context, scriptable, string);
        Scriptable scriptable2 = context.newObject(scriptable);
        scriptable2.put("", scriptable2, object);
        return NativeJSON.walk(context, scriptable, callable, scriptable2, "");
    }

    private static Object walk(Context context, Scriptable scriptable, Callable callable, Scriptable scriptable2, Object object) {
        Object object2;
        block8: {
            object2 = object instanceof Number ? scriptable2.get(((Number)object).intValue(), scriptable2) : scriptable2.get((String)object, scriptable2);
            if (!(object2 instanceof Scriptable)) break block8;
            Scriptable scriptable3 = (Scriptable)object2;
            if (scriptable3 instanceof NativeArray) {
                int n = (int)((NativeArray)scriptable3).getLength();
                for (int i = 0; i < n; ++i) {
                    Object object3 = NativeJSON.walk(context, scriptable, callable, scriptable3, i);
                    if (object3 == Undefined.instance) {
                        scriptable3.delete(i);
                        continue;
                    }
                    scriptable3.put(i, scriptable3, object3);
                }
            } else {
                Object[] objectArray;
                for (Object object4 : objectArray = scriptable3.getIds()) {
                    Object object5 = NativeJSON.walk(context, scriptable, callable, scriptable3, object4);
                    if (object5 == Undefined.instance) {
                        if (object4 instanceof Number) {
                            scriptable3.delete(((Number)object4).intValue());
                            continue;
                        }
                        scriptable3.delete((String)object4);
                        continue;
                    }
                    if (object4 instanceof Number) {
                        scriptable3.put(((Number)object4).intValue(), scriptable3, object5);
                        continue;
                    }
                    scriptable3.put((String)object4, scriptable3, object5);
                }
            }
        }
        return callable.call(context, scriptable, scriptable2, new Object[]{object, object2});
    }

    private static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static Object stringify(Context context, Scriptable scriptable, Object object, Object object2, Object object3) {
        Object object4;
        String string = "";
        String string2 = "";
        LinkedList<Object> linkedList = null;
        Callable callable = null;
        if (object2 instanceof Callable) {
            callable = (Callable)object2;
        } else if (object2 instanceof NativeArray) {
            linkedList = new LinkedList<Object>();
            NativeArray nativeArray = (NativeArray)object2;
            object4 = nativeArray.getIndexIds();
            int n = ((Integer[])object4).length;
            for (int i = 0; i < n; ++i) {
                int n2 = object4[i];
                Object object5 = nativeArray.get(n2, (Scriptable)nativeArray);
                if (object5 instanceof String || object5 instanceof Number) {
                    linkedList.add(object5);
                    continue;
                }
                if (!(object5 instanceof NativeString) && !(object5 instanceof NativeNumber)) continue;
                linkedList.add(ScriptRuntime.toString(object5));
            }
        }
        if (object3 instanceof NativeNumber) {
            object3 = ScriptRuntime.toNumber(object3);
        } else if (object3 instanceof NativeString) {
            object3 = ScriptRuntime.toString(object3);
        }
        if (object3 instanceof Number) {
            int n = (int)ScriptRuntime.toInteger(object3);
            string2 = (n = Math.min(10, n)) > 0 ? NativeJSON.repeat(' ', n) : "";
            object3 = n;
        } else if (object3 instanceof String && (string2 = (String)object3).length() > 10) {
            string2 = string2.substring(0, 10);
        }
        StringifyState stringifyState = new StringifyState(context, scriptable, string, string2, callable, linkedList, object3);
        object4 = new NativeObject();
        ((ScriptableObject)object4).setParentScope(scriptable);
        ((ScriptableObject)object4).setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        ((ScriptableObject)object4).defineProperty("", object, 0);
        return NativeJSON.str("", (Scriptable)object4, stringifyState);
    }

    private static Object str(Object object, Scriptable scriptable, StringifyState stringifyState) {
        Object object2;
        Object object3 = null;
        object3 = object instanceof String ? NativeJSON.getProperty(scriptable, (String)object) : NativeJSON.getProperty(scriptable, ((Number)object).intValue());
        if (object3 instanceof Scriptable && (object2 = NativeJSON.getProperty((Scriptable)object3, "toJSON")) instanceof Callable) {
            object3 = NativeJSON.callMethod(stringifyState.cx, (Scriptable)object3, "toJSON", new Object[]{object});
        }
        if (stringifyState.replacer != null) {
            object3 = stringifyState.replacer.call(stringifyState.cx, stringifyState.scope, scriptable, new Object[]{object, object3});
        }
        if (object3 instanceof NativeNumber) {
            object3 = ScriptRuntime.toNumber(object3);
        } else if (object3 instanceof NativeString) {
            object3 = ScriptRuntime.toString(object3);
        } else if (object3 instanceof NativeBoolean) {
            object3 = ((NativeBoolean)object3).getDefaultValue(ScriptRuntime.BooleanClass);
        }
        if (object3 == null) {
            return "null";
        }
        if (object3.equals(Boolean.TRUE)) {
            return "true";
        }
        if (object3.equals(Boolean.FALSE)) {
            return "false";
        }
        if (object3 instanceof String) {
            return NativeJSON.quote((String)object3);
        }
        if (object3 instanceof Number) {
            double d = ((Number)object3).doubleValue();
            if (d == d && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                return ScriptRuntime.toString(object3);
            }
            return "null";
        }
        if (object3 instanceof Scriptable && !(object3 instanceof Callable)) {
            if (object3 instanceof NativeArray) {
                return NativeJSON.ja((NativeArray)object3, stringifyState);
            }
            return NativeJSON.jo((Scriptable)object3, stringifyState);
        }
        return Undefined.instance;
    }

    private static String join(Collection<Object> collection, String string) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Iterator<Object> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(iterator.next().toString());
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next().toString());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String jo(Scriptable scriptable, StringifyState stringifyState) {
        void var5_9;
        if (stringifyState.stack.search(scriptable) != -1) {
            throw ScriptRuntime.typeError0("msg.cyclic.value");
        }
        stringifyState.stack.push(scriptable);
        String string = stringifyState.indent;
        stringifyState.indent = stringifyState.indent + stringifyState.gap;
        Object[] objectArray = null;
        objectArray = stringifyState.propertyList != null ? stringifyState.propertyList.toArray() : scriptable.getIds();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : objectArray) {
            Object object2 = NativeJSON.str(object, scriptable, stringifyState);
            if (object2 == Undefined.instance) continue;
            String string2 = NativeJSON.quote(object.toString()) + ":";
            if (stringifyState.gap.length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + object2;
            linkedList.add(string2);
        }
        if (linkedList.isEmpty()) {
            String string3 = "{}";
        } else if (stringifyState.gap.length() == 0) {
            String string4 = '{' + NativeJSON.join(linkedList, ",") + '}';
        } else {
            String string5 = ",\n" + stringifyState.indent;
            String string6 = NativeJSON.join(linkedList, string5);
            String string7 = "{\n" + stringifyState.indent + string6 + '\n' + string + '}';
        }
        stringifyState.stack.pop();
        stringifyState.indent = string;
        return var5_9;
    }

    private static String ja(NativeArray nativeArray, StringifyState stringifyState) {
        String string;
        Object object;
        if (stringifyState.stack.search(nativeArray) != -1) {
            throw ScriptRuntime.typeError0("msg.cyclic.value");
        }
        stringifyState.stack.push(nativeArray);
        String string2 = stringifyState.indent;
        stringifyState.indent = stringifyState.indent + stringifyState.gap;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = (int)nativeArray.getLength();
        for (int i = 0; i < n; ++i) {
            object = NativeJSON.str(i, nativeArray, stringifyState);
            if (object == Undefined.instance) {
                linkedList.add("null");
                continue;
            }
            linkedList.add(object);
        }
        if (linkedList.isEmpty()) {
            string = "[]";
        } else if (stringifyState.gap.length() == 0) {
            string = '[' + NativeJSON.join(linkedList, ",") + ']';
        } else {
            object = ",\n" + stringifyState.indent;
            String string3 = NativeJSON.join(linkedList, (String)object);
            string = "[\n" + stringifyState.indent + string3 + '\n' + string2 + ']';
        }
        stringifyState.stack.pop();
        stringifyState.indent = string2;
        return string;
    }

    private static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        stringBuffer.append("\\u");
                        String string2 = String.format("%04x", c);
                        stringBuffer.append(string2);
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    @Override
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 5: {
                string2 = "parse";
                n = 2;
                break;
            }
            case 8: {
                string2 = "toSource";
                n = 1;
                break;
            }
            case 9: {
                string2 = "stringify";
                n = 3;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    private static class StringifyState {
        Stack<Scriptable> stack = new Stack();
        String indent;
        String gap;
        Callable replacer;
        List<Object> propertyList;
        Object space;
        Context cx;
        Scriptable scope;

        StringifyState(Context context, Scriptable scriptable, String string, String string2, Callable callable, List<Object> list, Object object) {
            this.cx = context;
            this.scope = scriptable;
            this.indent = string;
            this.gap = string2;
            this.replacer = callable;
            this.propertyList = list;
            this.space = object;
        }
    }
}

