/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    private static final int NORMAL = -1;
    private static final int CANCELLED = -2;
    private static final int EXCEPTIONAL = -3;
    private static final int SIGNAL = 1;
    private static final ExceptionNode[] exceptionTable;
    private static final ReentrantLock exceptionTableLock;
    private static final ReferenceQueue<Object> exceptionTableRefQueue;
    private static final int EXCEPTION_MAP_CAPACITY = 32;
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe UNSAFE;
    private static final long statusOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setCompletion(int n) {
        int n2;
        do {
            if ((n2 = this.status) >= 0) continue;
            return n2;
        } while (!UNSAFE.compareAndSwapInt(this, statusOffset, n2, n));
        if (n2 != 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryAwaitDone(long l) {
        block6: {
            try {
                int n = this.status;
                if (n <= 0 && (n != 0 || !UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1)) || this.status <= 0) break block6;
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (this.status > 0) {
                        this.wait(l);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalAwaitDone() {
        int n = this.status;
        if (n >= 0) {
            boolean bl = false;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                while ((n = this.status) >= 0) {
                    if (n == 0) {
                        UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1);
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalInterruptibleAwaitDone(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int n = this.status;
        if (n >= 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                while ((n = this.status) >= 0) {
                    if (n == 0) {
                        UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1);
                        continue;
                    }
                    this.wait(l);
                    if (l <= 0L) continue;
                }
            }
        }
        return n;
    }

    final void doExec() {
        if (this.status >= 0) {
            boolean bl;
            try {
                bl = this.exec();
            }
            catch (Throwable throwable) {
                this.setExceptionalCompletion(throwable);
                return;
            }
            if (bl) {
                this.setCompletion(-1);
            }
        }
    }

    private int doJoin() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            int n = this.status;
            if (n < 0) {
                return n;
            }
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            if (forkJoinWorkerThread.unpushTask(this)) {
                boolean bl;
                try {
                    bl = this.exec();
                }
                catch (Throwable throwable) {
                    return this.setExceptionalCompletion(throwable);
                }
                if (bl) {
                    return this.setCompletion(-1);
                }
            }
            return forkJoinWorkerThread.joinTask(this);
        }
        return this.externalAwaitDone();
    }

    private int doInvoke() {
        boolean bl;
        int n = this.status;
        if (n < 0) {
            return n;
        }
        try {
            bl = this.exec();
        }
        catch (Throwable throwable) {
            return this.setExceptionalCompletion(throwable);
        }
        if (bl) {
            return this.setCompletion(-1);
        }
        return this.doJoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setExceptionalCompletion(Throwable throwable) {
        int n = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        reentrantLock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            ExceptionNode[] exceptionNodeArray = exceptionTable;
            int n2 = n & exceptionNodeArray.length - 1;
            ExceptionNode exceptionNode = exceptionNodeArray[n2];
            while (true) {
                if (exceptionNode == null) {
                    exceptionNodeArray[n2] = new ExceptionNode(this, throwable, exceptionNodeArray[n2]);
                    break;
                }
                if (exceptionNode.get() == this) {
                    break;
                }
                exceptionNode = exceptionNode.next;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return this.setCompletion(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExceptionalCompletion() {
        int n = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        reentrantLock.lock();
        try {
            ExceptionNode[] exceptionNodeArray = exceptionTable;
            int n2 = n & exceptionNodeArray.length - 1;
            ExceptionNode exceptionNode = exceptionNodeArray[n2];
            ExceptionNode exceptionNode2 = null;
            while (exceptionNode != null) {
                ExceptionNode exceptionNode3 = exceptionNode.next;
                if (exceptionNode.get() == this) {
                    if (exceptionNode2 == null) {
                        exceptionNodeArray[n2] = exceptionNode3;
                        break;
                    }
                    exceptionNode2.next = exceptionNode3;
                    break;
                }
                exceptionNode2 = exceptionNode;
                exceptionNode = exceptionNode3;
            }
            ForkJoinTask.expungeStaleExceptions();
            this.status = 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getThrowableException() {
        ExceptionNode exceptionNode;
        Object object;
        if (this.status != -3) {
            return null;
        }
        int n = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        reentrantLock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            object = exceptionTable;
            exceptionNode = object[n & ((ExceptionNode[])object).length - 1];
            while (exceptionNode != null && exceptionNode.get() != this) {
                exceptionNode = exceptionNode.next;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (exceptionNode == null || (object = exceptionNode.ex) == null) {
            return null;
        }
        if (exceptionNode.thrower != Thread.currentThread().getId()) {
            Class<?> clazz = object.getClass();
            try {
                Constructor<?> constructor = null;
                Constructor<?>[] constructorArray = clazz.getConstructors();
                for (int i = 0; i < constructorArray.length; ++i) {
                    Constructor<?> constructor2 = constructorArray[i];
                    Class<?>[] classArray = constructor2.getParameterTypes();
                    if (classArray.length == 0) {
                        constructor = constructor2;
                        continue;
                    }
                    if (classArray.length != 1 || classArray[0] != Throwable.class) continue;
                    return (Throwable)constructor2.newInstance(object);
                }
                if (constructor != null) {
                    Throwable throwable = (Throwable)constructor.newInstance(new Object[0]);
                    throwable.initCause((Throwable)object);
                    return throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    private static void expungeStaleExceptions() {
        Reference<Object> reference;
        block0: while ((reference = exceptionTableRefQueue.poll()) != null) {
            if (!(reference instanceof ExceptionNode)) continue;
            ForkJoinTask forkJoinTask = (ForkJoinTask)((ExceptionNode)reference).get();
            ExceptionNode[] exceptionNodeArray = exceptionTable;
            int n = System.identityHashCode(forkJoinTask) & exceptionNodeArray.length - 1;
            ExceptionNode exceptionNode = exceptionNodeArray[n];
            ExceptionNode exceptionNode2 = null;
            while (exceptionNode != null) {
                ExceptionNode exceptionNode3 = exceptionNode.next;
                if (exceptionNode == reference) {
                    if (exceptionNode2 == null) {
                        exceptionNodeArray[n] = exceptionNode3;
                        continue block0;
                    }
                    exceptionNode2.next = exceptionNode3;
                    continue block0;
                }
                exceptionNode2 = exceptionNode;
                exceptionNode = exceptionNode3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void helpExpungeStaleExceptions() {
        ReentrantLock reentrantLock = exceptionTableLock;
        if (reentrantLock.tryLock()) {
            try {
                ForkJoinTask.expungeStaleExceptions();
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    private V reportResult() {
        Throwable throwable;
        int n = this.status;
        if (n == -2) {
            throw new CancellationException();
        }
        if (n == -3 && (throwable = this.getThrowableException()) != null) {
            UNSAFE.throwException(throwable);
        }
        return this.getRawResult();
    }

    public final ForkJoinTask<V> fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
        return this;
    }

    public final V join() {
        if (this.doJoin() != -1) {
            return this.reportResult();
        }
        return this.getRawResult();
    }

    public final V invoke() {
        if (this.doInvoke() != -1) {
            return this.reportResult();
        }
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> forkJoinTask, ForkJoinTask<?> forkJoinTask2) {
        forkJoinTask2.fork();
        forkJoinTask.invoke();
        forkJoinTask2.join();
    }

    public static void invokeAll(ForkJoinTask<?> ... forkJoinTaskArray) {
        ForkJoinTask<?> forkJoinTask;
        int n;
        int n2;
        Throwable throwable = null;
        for (n2 = n = forkJoinTaskArray.length - 1; n2 >= 0; --n2) {
            forkJoinTask = forkJoinTaskArray[n2];
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n2 != 0) {
                forkJoinTask.fork();
                continue;
            }
            if (super.doInvoke() >= -1 || throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            forkJoinTask = forkJoinTaskArray[n2];
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            if (super.doJoin() >= -1 || throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            UNSAFE.throwException(throwable);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> collection) {
        ForkJoinTask forkJoinTask;
        int n;
        int n2;
        if (!(collection instanceof RandomAccess) || !(collection instanceof List)) {
            ForkJoinTask.invokeAll(collection.toArray(new ForkJoinTask[collection.size()]));
            return collection;
        }
        List list = (List)collection;
        Throwable throwable = null;
        for (n2 = n = list.size() - 1; n2 >= 0; --n2) {
            forkJoinTask = (ForkJoinTask)list.get(n2);
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n2 != 0) {
                forkJoinTask.fork();
                continue;
            }
            if (forkJoinTask.doInvoke() >= -1 || throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            forkJoinTask = (ForkJoinTask)list.get(n2);
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            if (forkJoinTask.doJoin() >= -1 || throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            UNSAFE.throwException(throwable);
        }
        return collection;
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.setCompletion(-2) == -2;
    }

    final void cancelIgnoringExceptions() {
        try {
            this.cancel(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return this.status == -2;
    }

    public final boolean isCompletedAbnormally() {
        return this.status < -1;
    }

    public final boolean isCompletedNormally() {
        return this.status == -1;
    }

    public final Throwable getException() {
        int n = this.status;
        return n >= -1 ? null : (n == -2 ? new CancellationException() : this.getThrowableException());
    }

    public void completeExceptionally(Throwable throwable) {
        this.setExceptionalCompletion(throwable instanceof RuntimeException || throwable instanceof Error ? throwable : new RuntimeException(throwable));
    }

    public void complete(V v) {
        try {
            this.setRawResult(v);
        }
        catch (Throwable throwable) {
            this.setExceptionalCompletion(throwable);
            return;
        }
        this.setCompletion(-1);
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        Throwable throwable;
        int n;
        int n2 = n = Thread.currentThread() instanceof ForkJoinWorkerThread ? this.doJoin() : this.externalInterruptibleAwaitDone(0L);
        if (n == -2) {
            throw new CancellationException();
        }
        if (n == -3 && (throwable = this.getThrowableException()) != null) {
            throw new ExecutionException(throwable);
        }
        return this.getRawResult();
    }

    @Override
    public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            long l2 = timeUnit.toNanos(l);
            if (this.status >= 0) {
                boolean bl = false;
                if (forkJoinWorkerThread.unpushTask(this)) {
                    try {
                        bl = this.exec();
                    }
                    catch (Throwable throwable) {
                        this.setExceptionalCompletion(throwable);
                    }
                }
                if (bl) {
                    this.setCompletion(-1);
                } else if (this.status >= 0 && l2 > 0L) {
                    forkJoinWorkerThread.pool.timedAwaitJoin(this, l2);
                }
            }
        } else {
            long l3 = timeUnit.toMillis(l);
            if (l3 > 0L) {
                this.externalInterruptibleAwaitDone(l3);
            }
        }
        int n = this.status;
        if (n != -1) {
            if (n == -2) {
                throw new CancellationException();
            }
            if (n != -3) {
                throw new TimeoutException();
            }
            Throwable throwable = this.getThrowableException();
            if (throwable != null) {
                throw new ExecutionException(throwable);
            }
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        this.doJoin();
    }

    public final void quietlyInvoke() {
        this.doInvoke();
    }

    public static void helpQuiesce() {
        ((ForkJoinWorkerThread)Thread.currentThread()).helpQuiescePool();
    }

    public void reinitialize() {
        if (this.status == -3) {
            this.clearExceptionalCompletion();
        } else {
            this.status = 0;
        }
    }

    public static ForkJoinPool getPool() {
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)thread).pool : null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this);
    }

    public static int getQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getQueueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getEstimatedSurplusTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollLocalTask();
    }

    protected static ForkJoinTask<?> pollTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollTask();
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new AdaptedRunnable<Object>(runnable, null);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T t) {
        return new AdaptedRunnable<T>(runnable, t);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.setExceptionalCompletion((Throwable)object);
        }
    }

    static {
        exceptionTableLock = new ReentrantLock();
        exceptionTableRefQueue = new ReferenceQueue();
        exceptionTable = new ExceptionNode[32];
        try {
            UNSAFE = Unsafe.getUnsafe();
            statusOffset = UNSAFE.objectFieldOffset(ForkJoinTask.class.getDeclaredField("status"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        final T resultOnCompletion;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T t) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.resultOnCompletion = t;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            this.result = this.resultOnCompletion;
            return true;
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static final class ExceptionNode
    extends WeakReference<ForkJoinTask<?>> {
        final Throwable ex;
        ExceptionNode next;
        final long thrower;

        ExceptionNode(ForkJoinTask<?> forkJoinTask, Throwable throwable, ExceptionNode exceptionNode) {
            super(forkJoinTask, exceptionTableRefQueue);
            this.ex = throwable;
            this.next = exceptionNode;
            this.thrower = Thread.currentThread().getId();
        }
    }
}

