/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij.props;

import dnl.confij.BaseConfigurationSource;
import dnl.confij.ConfigException;
import dnl.confij.ConfigParam;
import dnl.confij.ConfigSection;
import dnl.confij.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesConfigurationSource
extends BaseConfigurationSource {
    private Properties properties = new Properties();
    private String charset;

    public PropertiesConfigurationSource(File propertiesFile) {
        super(propertiesFile);
    }

    public PropertiesConfigurationSource(File propertiesFile, String charset) {
        super(propertiesFile);
        this.charset = charset;
    }

    protected void loadConfigurationImpl(Configuration config) throws ConfigException {
        this.properties.clear();
        try {
            if (this.charset == null) {
                this.properties.load(new FileReader(this.getConfigFile()));
            } else {
                this.properties.load(new InputStreamReader((InputStream)new FileInputStream(this.getConfigFile()), this.charset));
            }
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
        Set<Map.Entry<Object, Object>> entrySet = this.properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String sectionName = "";
            int ind = key.lastIndexOf(46);
            if (ind <= 0) continue;
            sectionName = key.substring(0, ind);
            ConfigSection cs = config.getOrCreateSection(sectionName);
            config.addSection(cs);
            String paramKey = key.substring(ind + 1);
            cs.setParamValue(paramKey, val);
        }
    }

    protected void saveConfigurationImpl(Configuration config) throws ConfigException {
        this.properties.clear();
        Collection<ConfigSection> sections = config.getSections();
        for (ConfigSection section : sections) {
            String sectionKey = section.getName() + ".";
            Collection<ConfigParam> configParameters = section.getConfigParameters();
            for (ConfigParam configParam : configParameters) {
                this.properties.put(sectionKey + configParam.getName(), configParam.getValue());
            }
        }
        try {
            if (this.charset == null) {
                this.properties.store(new FileWriter(this.getConfigFile()), "");
            } else {
                this.properties.store(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getConfigFile()), this.charset), "");
            }
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }
}

