/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij;

import dnl.confij.ConfigParam;
import dnl.confij.ConvertersRegistry;
import dnl.confij.ParameterType;
import dnl.confij.ValueConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSection {
    private Map<String, ConfigParam> paramsMap = new HashMap<String, ConfigParam>();
    private String name;

    public ConfigSection(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getParamValue(String paramName) {
        ConfigParam configParam = this.paramsMap.get(paramName);
        if (configParam == null) {
            return null;
        }
        return configParam.getValue();
    }

    public void setParam(String paramName, String value, ParameterType parameterType) {
        ConfigParam configParam = this.paramsMap.get(paramName);
        if (configParam == null) {
            configParam = new ConfigParam(paramName, parameterType);
            this.paramsMap.put(paramName, configParam);
        }
        configParam.setValue(value);
    }

    public void setParamValue(String paramName, String value) {
        this.setParam(paramName, value, ParameterType.STRING);
    }

    public void setParamValue(String paramName, boolean value) {
        this.setParam(paramName, Boolean.toString(value), ParameterType.BOOLEAN);
    }

    public void setParamValue(String paramName, int value) {
        this.setParam(paramName, Integer.toString(value), ParameterType.INTEGER);
    }

    public void setParamValue(String paramName, double value) {
        this.setParam(paramName, Double.toString(value), ParameterType.DOUBLE);
    }

    public Collection<ConfigParam> getConfigParameters() {
        return this.paramsMap.values();
    }

    public Integer getInt(String paramName) {
        Integer i = Integer.parseInt(this.getParamValue(paramName));
        return (int)i;
    }

    public Double getDouble(String paramName) {
        Double d = Double.parseDouble(this.getParamValue(paramName));
        return d;
    }

    public Boolean getBoolean(String paramName) {
        Boolean b = Boolean.parseBoolean(this.getParamValue(paramName));
        return b;
    }

    public String getString(String paramName) {
        return this.getParamValue(paramName);
    }

    public Object get(String paramName, Class<?> clazz) {
        String stringVal = this.getParamValue(paramName);
        ValueConverter converter = ConvertersRegistry.getInstance().getConverter(clazz);
        if (converter == null) {
            throw new IllegalStateException("No converter for class: " + clazz.getName());
        }
        return converter.parse(stringVal);
    }

    public <T extends Enum<T>> T getEnum(String paramName, Class<T> enumClass) {
        String pval = this.getParamValue(paramName);
        return Enum.valueOf(enumClass, pval);
    }

    public void setInt(String paramName, int value) {
        this.setParam(paramName, Integer.toString(value), ParameterType.INTEGER);
    }

    public void setDouble(String paramName, double value) {
        this.setParam(paramName, Double.toString(value), ParameterType.DOUBLE);
    }

    public void setBoolean(String paramName, boolean value) {
        this.setParam(paramName, Boolean.toString(value), ParameterType.BOOLEAN);
    }

    public void setString(String paramName, String value) {
        this.setParamValue(paramName, value);
    }

    public void set(String paramName, Object value) {
        ValueConverter converter = ConvertersRegistry.getInstance().getConverter(value.getClass());
        if (converter == null) {
            this.setParamValue(paramName, String.valueOf(value));
        } else {
            this.setParamValue(paramName, converter.format(value));
        }
    }

    public <T extends Enum<T>> void setEnum(String paramName, Enum<T> value) {
        this.setParamValue(paramName, value.name());
    }
}

