/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import miui.imagefilters.BlendImageFilter;
import miui.imagefilters.ColorMatrixFilter;
import miui.imagefilters.ConvolutionFilter;
import miui.imagefilters.EdgesFilter;
import miui.imagefilters.GrayScaleFilter;
import miui.imagefilters.HslWrapFilter;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.LevelsFilter;
import miui.imagefilters.SpreadFilter;
import miui.imagefilters.ThresholdFilter;
import miui.imagefilters.TransformFilter;

public class ImageFilterBuilder {
    private static final String TAG = "ImageFilterBuilder";
    private String mFilterName;
    private boolean mIgnoreWhenNotSupported = false;
    private List<ParamData> mParams = new ArrayList<ParamData>();

    public void setIgnoreWhenNotSupported(boolean bl) {
        this.mIgnoreWhenNotSupported = bl;
    }

    public void setFilterName(String string) {
        this.mFilterName = string;
    }

    public void addParam(final String string, final List<Object> list, final boolean bl) {
        this.mParams.add(new ParamData(){
            {
                this.mParamName = string;
                this.mParamValues = list;
                this.mIgnoreWhenNotSupported = bl;
            }
        });
    }

    public IImageFilter createImageFilter() throws NoSupportException {
        IImageFilter.AbstractImageFilter abstractImageFilter = null;
        if ("Hsl".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new HslWrapFilter();
        } else if ("Edges".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new EdgesFilter();
        } else if ("Levels".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new LevelsFilter();
        } else if ("GrayScale".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new GrayScaleFilter();
        } else if ("BlendImage".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new BlendImageFilter();
        } else if ("ColorMatrix".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new ColorMatrixFilter();
        } else if ("Convolution".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new ConvolutionFilter();
        } else if ("Threshold".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new ThresholdFilter();
        } else if ("Spread".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new SpreadFilter();
        } else if ("Transform".equalsIgnoreCase(this.mFilterName)) {
            abstractImageFilter = new TransformFilter();
        } else {
            Log.w(TAG, "unknown filter:" + this.mFilterName);
            if (!this.mIgnoreWhenNotSupported) {
                throw new NoSupportException("filter:" + this.mFilterName + " not support.");
            }
            return null;
        }
        for (ParamData paramData : this.mParams) {
            if (abstractImageFilter.initParams(paramData.mParamName, paramData.mParamValues) || paramData.mIgnoreWhenNotSupported) continue;
            if (this.mIgnoreWhenNotSupported) {
                return null;
            }
            throw new NoSupportException("param:" + paramData.mParamName + " not support.");
        }
        return abstractImageFilter;
    }

    private static class ParamData {
        String mParamName;
        List<Object> mParamValues;
        boolean mIgnoreWhenNotSupported = false;

        private ParamData() {
        }
    }

    public static class NoSupportException
    extends Exception {
        public NoSupportException(String string) {
            super(string);
        }
    }
}

