/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.HslFilter;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;

public class HslWrapFilter
extends IImageFilter.AbstractImageFilter {
    private HslFilter mHsl;
    private HslFilter mHsv;

    private void ensureHsl() {
        if (this.mHsl == null) {
            this.mHsl = new HslFilter();
            this.mHsl.useHsv = false;
        }
    }

    private void ensureHsv() {
        if (this.mHsv == null) {
            this.mHsv = new HslFilter();
            this.mHsv.useHsv = true;
        }
    }

    public void setHueModify(float f) {
        this.ensureHsl();
        this.mHsl.setHueModify(f);
    }

    public void setSaturationModify(float f) {
        this.ensureHsl();
        this.mHsl.setSaturationModify(f);
    }

    public void setLightnessModify(float f) {
        if (f > 0.0f) {
            this.ensureHsl();
            this.mHsl.setLightnessModify(f);
        } else {
            this.ensureHsv();
            this.mHsv.setLightnessModify(f);
        }
    }

    public void setHueAdjust(float f) {
        this.ensureHsl();
        this.mHsl.setHueAdjust(f);
    }

    public void setSaturationAdjust(float f) {
        this.ensureHsl();
        this.mHsl.setSaturationAdjust(f);
    }

    public void setLightnessAdjust(float f) {
        if (f > 0.0f) {
            this.ensureHsl();
            this.mHsl.setLightnessAdjust(f);
        } else {
            this.ensureHsv();
            this.mHsv.setLightnessAdjust(f);
        }
    }

    @Override
    public void processData(ImageData imageData) {
        if (this.mHsl != null) {
            this.mHsl.process(imageData);
        }
        if (this.mHsv != null) {
            this.mHsv.process(imageData);
        }
    }
}

