/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.compressor.ZipCompressor;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.FullResolutionMatchManager;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeEditorConstants;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.json.JSONObject;

public class ThemeHelper
extends ThemeEditorConstants {
    public static String NINE_PATCH_SUFFIX = ".9.png";
    public static final String COMPLETE_FLAG_FILE = "complete";

    public static String getUserDir() {
        return System.getProperty("user.dir").trim();
    }

    public static String getRootPath() {
        return new File(ThemeHelper.getUserDir()).getParentFile().getAbsolutePath();
    }

    public static String getResourceCatalogPath() {
        String string = ThemeHelper.getRootPath() + File.separator + "resourceCatalog_" + ThemeHelper.getThemeUIVersion();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static String getImportResourceCatalogPath() {
        String string;
        File file;
        int n = ThemeHelper.getRomUIVersion();
        if (n == -1) {
            n = ThemeManager.getInstance().getThemeInfoData().mUIVersion;
        }
        if (!(file = new File(string = new File(ThemeHelper.getUserDir()).getParentFile().getAbsolutePath() + File.separator + "resourceCatalog_" + (String)sUiVersionMap.get(n))).exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static int getRomUIVersion() {
        int n = -1;
        String string = ThemeHelper.getBuildProp("ro.miui.ui.version.code");
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return n;
        }
    }

    public static int getAndroidSDKVersion() {
        int n = -1;
        String string = ThemeHelper.getBuildProp("ro.build.version.sdk");
        if (string != null) {
            n = Integer.valueOf(string);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildProp(String string) {
        File file;
        String string2 = ThemeHelper.getTmpFolder().getAbsolutePath();
        String string3 = string2 + File.separator + "build.prop";
        String string4 = ConfigUtil.get("device", "getPropTime");
        long l = new Date().getTime();
        System.out.println("last get prop file time: " + string4);
        if (!new File(string3).exists() || string4.equals("") || l - Long.valueOf(string4) > 300000L) {
            OS.rmFile(string3);
            boolean bl = CmdUtils.adb_pull("/system/build.prop", string2);
            if (!bl) {
                return null;
            }
            ConfigUtil.put("device", "getPropTime", Long.toString(l));
        }
        if ((file = new File(string3)).exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String string5 = bufferedReader.readLine();
                while (string5 != null && !string5.contains(string)) {
                    string5 = bufferedReader.readLine();
                }
                if (string5 != null && string5.contains("=")) {
                    String string6 = string5.substring(string5.indexOf("=") + 1, string5.length());
                    return string6;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getRomIncrementalVersion() {
        String string = ThemeHelper.getBuildProp("ro.build.version.incremental");
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(File file, File file2) {
        FilterOutputStream filterOutputStream = null;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            fileInputStream = new FileInputStream(file);
            zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                File file3 = new File(file2 + File.separator + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file3.mkdirs();
                    continue;
                }
                byte[] byArray = new byte[1024];
                file3.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                file3.setLastModified(zipEntry.getTime());
                filterOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
                while ((n = zipInputStream.read(byArray, 0, 1024)) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
                filterOutputStream.close();
                fileOutputStream.close();
            }
            zipInputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return true;
    }

    public static void zip(String string, String string2) {
        ZipCompressor zipCompressor = new ZipCompressor(string2);
        zipCompressor.compressContent(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String string) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(File file) {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            String string = IOUtils.toString((Reader)inputStreamReader);
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static File getDataFolder() {
        return new File(ThemeHelper.getUserDir() + File.separator + "data");
    }

    public static String assurePath(String string) {
        return ThemeHelper.assurePath(string, File.separator);
    }

    public static String assurePath(String string, String string2) {
        string = string.replace("\\", string2);
        string = string.replace("/", string2);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        file2.getParentFile().mkdirs();
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            fileOutputStream = new FileOutputStream(file2);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[5120];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            fileOutputStream.close();
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
                fileInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
                fileOutputStream.close();
            }
        }
    }

    public static void openInExplorer(File file) {
        if (file.isFile()) {
            if (1 == OS.getOS()) {
                CmdUtils.openAndSelectFileInWindows(file.getAbsolutePath());
            } else {
                try {
                    Desktop.getDesktop().open(file.getParentFile());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else {
            ThemeHelper.open(file);
        }
    }

    public static void open(File file) {
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void browse(String string) {
        try {
            Desktop.getDesktop().browse(URI.create(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getVersion() {
        return ThemeHelper.readFromFile(new File(ThemeHelper.getUserDir() + File.separator + "version.txt")).trim();
    }

    public static void setReviewMode(boolean bl) {
        if (bl) {
            ConfigUtil.put("preference", "Review", Boolean.TRUE.toString());
        } else {
            ConfigUtil.put("preference", "Review", Boolean.FALSE.toString());
        }
        ConfigUtil.save();
    }

    public static boolean isDebugMode() {
        return ConfigUtil.get("preference", "Debug").equals(Boolean.TRUE.toString());
    }

    public static boolean isReviewMode() {
        return ConfigUtil.get("preference", "Review").equals(Boolean.TRUE.toString());
    }

    public static void setInnerUserMode() {
        ConfigUtil.put("preference", "InnerUser", Boolean.TRUE.toString());
        ConfigUtil.save();
    }

    public static boolean isInnerUserMode() {
        return ConfigUtil.get("preference", "InnerUser").equals(Boolean.TRUE.toString());
    }

    public static File getCatalogFileFromReplaceFile(File file) {
        String string = ThemeHelper.getRelativePathFromReplace(file.getAbsolutePath());
        if (string == null) {
            return null;
        }
        return new File(ThemeHelper.getResourceCatalogPath() + File.separator + string);
    }

    public static String getRelativePathFromReplace(String string) {
        if (!string.startsWith(ConfigUtil.getThemePath())) {
            return null;
        }
        return string.substring(ConfigUtil.getThemePath().length() + 1);
    }

    public static boolean isNinePatchName(String string) {
        return string.toLowerCase().endsWith(NINE_PATCH_SUFFIX);
    }

    public static File getTmpFolder() {
        return new File(ThemeHelper.getUserDir() + File.separator + "tmp");
    }

    public static File getTmpTheme() {
        File file = new File(ThemeHelper.getTmpFolder() + File.separator + "themes" + File.separator + new File(ConfigUtil.getThemePath()).getName() + ".mtz");
        file.getParentFile().mkdirs();
        return file;
    }

    public static void searchAndDelete(String string, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    ThemeHelper.searchAndDelete(string, file2);
                    continue;
                }
                if (!file2.getName().equals(string)) continue;
                file2.delete();
            }
        }
    }

    public static String getThemeUIVersion() {
        return (String)sUiVersionMap.get(ThemeManager.getInstance().getThemeInfoData().mUIVersion);
    }

    public static String getTemplatePath() {
        String string;
        File file;
        String string2 = ThemeHelper.getUserDir();
        String string3 = ConfigUtil.get("preference", "Templates");
        if (!string3.isEmpty()) {
            string2 = string3;
        }
        if (!(file = new File(string = string2 + File.separator + "templates_" + ThemeHelper.getThemeUIVersion() + "_" + ResourceFactory.sLocale.getLanguage())).exists()) {
            string = string2 + File.separator + "templates_" + ThemeHelper.getThemeUIVersion();
        }
        return string;
    }

    public static String getWallpaper() {
        return ConfigUtil.getThemePath() + File.separator + "wallpaper" + File.separator + "default_wallpaper.jpg";
    }

    public static String getLockWallpaper() {
        return ConfigUtil.getThemePath() + File.separator + "wallpaper" + File.separator + "default_lock_wallpaper.jpg";
    }

    public static String getFolderName(String string) {
        return new File(string).getParentFile().getName();
    }

    public static String getLastName(String string) {
        string = ThemeHelper.assurePath(string);
        return string.substring(string.lastIndexOf(File.separator) + 1);
    }

    public static String removeLastName(String string) {
        string = ThemeHelper.assurePath(string);
        return string.substring(0, string.lastIndexOf(File.separator));
    }

    public static boolean waitForCompleteFile(String string) {
        boolean bl = false;
        String string2 = ThemeHelper.getTmpFolder() + File.separator + COMPLETE_FLAG_FILE;
        for (int i = 0; i < 60; ++i) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = CmdUtils.adb_pull(string, string2);
            if (bl) break;
        }
        if (!bl) {
            return false;
        }
        new File(string2).delete();
        return true;
    }

    public static boolean isMtzFile(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(".mtz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getJSON(String string) {
        InputStream inputStream = null;
        try {
            JSONObject jSONObject;
            inputStream = new URL(string).openStream();
            String string2 = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            JSONObject jSONObject2 = jSONObject = new JSONObject(string2);
            return jSONObject2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getXml(String string) {
        InputStream inputStream = null;
        try {
            inputStream = new URL(string).openStream();
            String string2 = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build((InputStream)new StringInputStream(string2));
            return document;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static void convertXxhdpi2Xhdpi() {
        if (ThemeManager.isThemeLoaded()) {
            GUIUtil.alert("Will start");
            File file = new File(ConfigUtil.getThemePath());
            for (File file2 : file.listFiles()) {
                FullResolutionMatchManager.adaptXxhdpiToXhdpi(file2);
            }
            GUIUtil.alert("OK");
        }
    }

    public static void convertToJpg() {
        if (ThemeManager.isThemeLoaded()) {
            GUIUtil.alert("Will start");
            File file = new File(ConfigUtil.getThemePath());
            for (File file2 : file.listFiles()) {
                if (!file2.getAbsolutePath().endsWith(".png")) continue;
                File file3 = new File(file2.getAbsolutePath().replace(".png", ".jpg"));
                BufferedImage bufferedImage = GUIUtil.getImage(file2);
                GUIUtil.saveImage(GUIUtil.scale(bufferedImage, 720, 1280), file3, 0.9f);
            }
            GUIUtil.alert("OK");
        }
    }

    public static String stripSuffix(String string, String string2) {
        return string.substring(0, string.length() - string2.length());
    }

    public static void setAutoLoadOnce(boolean bl) {
        ConfigUtil.put("preference", "AutoRunOnce", new Boolean(bl).toString());
        ConfigUtil.save();
    }

    public static void logAction(String string) {
    }

    public static HashSet<String> getFilesWithSuffix(String string, final String string2) {
        final HashSet<String> hashSet = new HashSet<String>();
        try {
            Files.walkFileTree(Paths.get(string, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    this.check(path);
                    return super.visitFile(path, basicFileAttributes);
                }

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    this.check(path);
                    return FileVisitResult.CONTINUE;
                }

                private void check(Path path) {
                    if (path.toString().endsWith(string2)) {
                        hashSet.add(path.toString());
                    }
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashSet;
    }

    public static String replaceFolder(String string, String string2, String string3) {
        return string.replace(string2, string3);
    }
}

