/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;

public class ShortcutManager
implements AWTEventListener {
    private static ShortcutManager sInstance = new ShortcutManager();
    private Map<String, ShortcutListener> mListeners;
    private Set<Component> mIgnoredComponents;
    private boolean[] mKeys = new boolean[1000];

    private ShortcutManager() {
        this.mIgnoredComponents = new HashSet<Component>();
        this.mListeners = new HashMap<String, ShortcutListener>();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getClass() == KeyEvent.class) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (keyEvent.getID() == 401) {
                this.mKeys[keyEvent.getKeyCode()] = true;
                String string = this.searchShortcut();
                ShortcutListener shortcutListener = this.mListeners.get(string);
                if (shortcutListener != null && !this.isIgnored(aWTEvent)) {
                    shortcutListener.handle();
                }
            } else if (keyEvent.getID() == 402) {
                this.mKeys[keyEvent.getKeyCode()] = false;
            }
        }
    }

    protected String searchShortcut() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (!this.mKeys[i]) continue;
            stringBuilder.append(i).append(".");
        }
        return stringBuilder.toString();
    }

    protected boolean isIgnored(AWTEvent aWTEvent) {
        if (!(aWTEvent.getSource() instanceof Component)) {
            return false;
        }
        boolean bl = false;
        for (Component component = (Component)aWTEvent.getSource(); component != null; component = component.getParent()) {
            if (!this.mIgnoredComponents.contains(component)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static ShortcutManager getInstance() {
        return sInstance;
    }

    public void removeShortcutListener(ShortcutListener shortcutListener) {
        String string = null;
        for (Map.Entry<String, ShortcutListener> entry : this.mListeners.entrySet()) {
            if (!entry.getValue().equals(shortcutListener)) continue;
            string = entry.getKey();
        }
        this.mListeners.remove(string);
    }

    public void addShortcutListener(ShortcutListener shortcutListener, int ... nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.sort(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            if (0 >= nArray[i] || nArray[i] >= this.mKeys.length) {
                System.out.println("Key is not valid");
                return;
            }
            stringBuilder.append(nArray[i]).append(".");
        }
        String string = stringBuilder.toString();
        if (this.mListeners.containsKey(string)) {
            System.out.println("The shourt cut is already used.");
        } else {
            this.mListeners.put(string, shortcutListener);
        }
    }

    public void addIgnoredComponent(Component component) {
        this.mIgnoredComponents.add(component);
    }

    public void removeDiscardComponent(Component component) {
        this.mIgnoredComponents.remove(component);
    }

    public void addShortcutListener(ShortcutListener shortcutListener, KeyStroke keyStroke) {
        int n = keyStroke.getKeyCode();
        String string = keyStroke.toString();
        if (string.contains("ctrl")) {
            if (string.contains("alt")) {
                this.addShortcutListener(shortcutListener, n, 17, 18);
            } else {
                this.addShortcutListener(shortcutListener, n, 17);
            }
        } else if (string.contains("alt")) {
            this.addShortcutListener(shortcutListener, n, 18);
        }
    }

    public static interface ShortcutListener {
        public void handle();
    }
}

