/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.util.DownloadProgressListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class InternetDownloadTask
extends SwingWorker {
    private DownloadProgressListener mDownloadProgressListener;
    private URL mUrl;
    private InputStream mUrlStream;
    private OutputStream mDestFileStream;
    private URLConnection mUrlConnection;
    public static final int BLOCK_SIZE = 4096;
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_TYPE_VALUE = "binary/data";
    public static final int DOWNLOAD_TIMEOUT = 5000;

    public InternetDownloadTask(String string, OutputStream outputStream) throws IOException {
        this(string);
        this.mDestFileStream = outputStream;
    }

    public InternetDownloadTask(String string) throws IOException {
        this.mUrl = new URL(string);
        this.mUrlConnection = this.mUrl.openConnection();
        this.mUrlConnection.setConnectTimeout(5000);
        this.mUrlConnection.setDoOutput(true);
        this.mUrlConnection.setDoInput(true);
        this.mUrlConnection.setRequestProperty(CONTENT_TYPE, CONTENT_TYPE_VALUE);
        this.mUrlStream = this.mUrl.openStream();
    }

    public void setDestFileStream(OutputStream outputStream) {
        this.mDestFileStream = outputStream;
    }

    public int getFileSize() {
        return this.mUrlConnection.getContentLength();
    }

    protected Object doInBackground() throws Exception {
        int n;
        int n2 = this.mUrlConnection.getContentLength();
        byte[] byArray = new byte[4096];
        int n3 = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.mUrlStream);
        while ((n = bufferedInputStream.read(byArray)) != -1 && !this.isCancelled()) {
            this.mDestFileStream.write(byArray, 0, n);
            this.mDownloadProgressListener.progress(n3 += n, n2);
        }
        this.mUrlStream.close();
        return null;
    }

    @Override
    protected void done() {
        super.done();
        try {
            this.mDestFileStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.mDownloadProgressListener != null) {
            if (this.isCancelled()) {
                this.mDownloadProgressListener.cancelled();
                return;
            }
            try {
                this.mDownloadProgressListener.done(this.get());
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        }
    }

    public void setDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
        this.mDownloadProgressListener = downloadProgressListener;
    }
}

