/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.update;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionFile
implements Comparable<VersionFile> {
    public int mYear;
    public int mMonth;
    public int mDay;
    public int mStamp;
    String mContent;
    public static String lineSeparator = "\n";

    public static VersionFile parse(String string) {
        VersionFile versionFile = new VersionFile();
        if (VersionFile.fillVersionFile(versionFile, string)) {
            return versionFile;
        }
        return null;
    }

    private static boolean fillVersionFile(VersionFile versionFile, String string) {
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return false;
        }
        versionFile.mYear = Integer.parseInt(matcher.group(1));
        versionFile.mMonth = Integer.parseInt(matcher.group(2));
        versionFile.mDay = Integer.parseInt(matcher.group(3));
        versionFile.mStamp = Integer.parseInt(matcher.group(4));
        return true;
    }

    public static VersionFile parse(File file) {
        VersionFile versionFile = new VersionFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            if (!VersionFile.fillVersionFile(versionFile, string)) {
                return null;
            }
            stringBuilder.append(string);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(lineSeparator + string);
            }
            versionFile.mContent = stringBuilder.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return versionFile;
    }

    public String getVersionString() {
        return this.mYear + "." + this.mMonth + "." + this.mDay + "_" + this.mStamp;
    }

    @Override
    public int compareTo(VersionFile versionFile) {
        if (this.mYear != versionFile.mYear) {
            return this.mYear - versionFile.mYear;
        }
        if (this.mMonth != versionFile.mMonth) {
            return this.mMonth - versionFile.mMonth;
        }
        if (this.mDay != versionFile.mDay) {
            return this.mDay - versionFile.mDay;
        }
        if (this.mStamp != versionFile.mStamp) {
            return this.mStamp - versionFile.mStamp;
        }
        return 0;
    }
}

