/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.review;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.WrapLayout;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BaseScreencapturePanel
extends JPanel {
    public static Color sImageBackground = GUIUtil.hex2color("#efeeee");
    public static final int IMAGE_WIDTH = 220;
    public static final int IMAGE_HEIGHT = 391;
    public static int CAPTURE_IMAGE_SIZE = 40;
    public static NinePatch sImageFramePatch = GUIUtil.getNinePatch("review/image_frame.9.png");
    public static BufferedImage sLoadingImage = ResourceFactory.getInstance().getImage("review/loading.png");
    public static BufferedImage sLoadFailImage = ResourceFactory.getInstance().getImage("review/load_failed.png");
    public JLabel mTitle;
    public JPanel mImagePanel;
    public Vector<String> mOriginPath;
    public Vector<JLabel> mImageLabels = new Vector();
    int mTop = 26;
    int mLeft = 29;
    int mRight = 30;
    int mBottom = 26;
    int mHGap = 15;
    int mVGap = 19;
    int mImagePerLine = 5;
    int mLastWidth = -1;
    protected String mResolution;
    protected MouseListener mMouseListener;
    public static String EDIT_PREFIX;
    public static BufferedImage sEditedImage;

    public BaseScreencapturePanel() {
        this.initVector();
        this.setBackground(sImageBackground);
        this.mTitle = new JLabel("Default");
        this.mTitle.setHorizontalAlignment(0);
        this.mTitle.setForeground(GUIUtil.hex2color("#b7b9bc"));
        this.mImagePanel = new JPanel();
        this.mImagePanel.setBackground(sImageBackground);
        double[][] dArrayArray = new double[][]{{-1.0}, {26.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.mTitle, "0, 0");
        this.add((Component)this.mImagePanel, "0, 1");
        this.layoutImages();
    }

    public void layoutImages() {
        this.mImagePanel.removeAll();
        this.mImagePanel.setLayout(new WrapLayout(0, 15, 19));
        for (int i = 0; i < this.mImageLabels.size(); ++i) {
            this.mImageLabels.get(i).setToolTipText("" + (i + 1));
            this.mImagePanel.add(this.mImageLabels.get(i));
        }
        this.revalidate();
        this.repaint();
    }

    protected void initVector() {
    }

    public void addImage(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (String string : stringArray) {
            this.mOriginPath.add(string);
            BufferedImage bufferedImage = GUIUtil.getImage(new File(string));
            this.mImageLabels.add(this.makeLabel(bufferedImage));
        }
        this.layoutImages();
    }

    private void tryLayout() {
        this.layoutImages();
    }

    public void setImage(int n, String string) {
        this.mOriginPath.set(n, string);
        String string2 = BaseScreencapturePanel.checkGetEdit(string);
        BufferedImage bufferedImage = GUIUtil.getImage(new File(string2));
        this.mImageLabels.set(n, this.makeLabel(bufferedImage, !string2.equals(string)));
        bufferedImage = null;
        this.tryLayout();
    }

    public void setImage(int n, BufferedImage bufferedImage) {
        this.mOriginPath.set(n, "");
        this.mImageLabels.set(n, this.makeLabel(bufferedImage));
        this.tryLayout();
    }

    public static String getEdit(String string) {
        File file = new File(string);
        return file.getParent() + File.separator + EDIT_PREFIX + file.getName();
    }

    public static String checkGetEdit(String string) {
        String string2 = BaseScreencapturePanel.getEdit(string);
        if (new File(string2).exists()) {
            return string2;
        }
        return string;
    }

    public void reloadImage(int n) {
        this.setImage(n, this.mOriginPath.get(n));
    }

    public static BufferedImage processLoadImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(220, 391, 6);
        sImageFramePatch.draw((Graphics2D)bufferedImage2.getGraphics(), 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        bufferedImage2.getGraphics().drawImage(bufferedImage, (bufferedImage2.getWidth() - bufferedImage.getWidth()) / 2, (bufferedImage2.getHeight() - bufferedImage.getHeight()) / 2, null);
        return bufferedImage2;
    }

    public JLabel makeLabel(BufferedImage bufferedImage) {
        return this.makeLabel(bufferedImage, false);
    }

    public JLabel makeLabel(BufferedImage bufferedImage, boolean bl) {
        ImageIcon imageIcon = this.makeIcon(bufferedImage, bl);
        JLabel jLabel = new JLabel(imageIcon);
        GUIUtil.hand(jLabel);
        jLabel.addMouseListener(this.mMouseListener);
        return jLabel;
    }

    public ImageIcon makeIcon(BufferedImage bufferedImage, boolean bl) {
        Image image = bufferedImage.getScaledInstance(220, 391, 4);
        if (bl) {
            BufferedImage bufferedImage2 = new BufferedImage(220, 391, 6);
            bufferedImage2.getGraphics().drawImage(image, 0, 0, null);
            bufferedImage2.getGraphics().drawImage(sEditedImage, 220 - sEditedImage.getWidth(), 0, null);
            image = bufferedImage2;
        }
        return new ImageIcon(image);
    }

    static {
        sLoadingImage = BaseScreencapturePanel.processLoadImage(sLoadingImage);
        sLoadFailImage = BaseScreencapturePanel.processLoadImage(sLoadFailImage);
        EDIT_PREFIX = "EDIT_";
        sEditedImage = ResourceFactory.getInstance().getImage("review/marked.png");
    }

    class EditImageThread
    extends Thread {
        private int mIndex;
        private String mPath;

        public EditImageThread(int n, String string) {
            this.mIndex = n;
            this.mPath = string;
        }

        @Override
        public void run() {
            CmdUtils.mspaint(this.mPath);
            BaseScreencapturePanel.this.reloadImage(this.mIndex);
        }
    }
}

