/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.catalog.CatalogManager;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.AbstractModuleBasePanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.outlook.OutlookPanel;
import com.miui.theme.tool.gui.outlook.OutlookPanelModel;
import com.miui.theme.tool.gui.outlook.OutlookSelectionEvent;
import com.miui.theme.tool.gui.outlook.OutlookTabData;
import com.miui.theme.tool.gui.skin.ModuleTabbedPane;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.CenterReplacePanel;
import com.miui.theme.tool.resourceeditor.CenterThemeValuesPanel;
import com.miui.theme.tool.resourceeditor.ResourceImportNotice;
import com.miui.theme.tool.resourceeditor.ScreenshotXml;
import com.miui.theme.tool.resourceeditor.ThemeValuesList;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.I18nObject;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ResourceEditorModulePanel
extends AbstractModuleBasePanel {
    protected ModuleTabbedPane mLeftPanel;
    protected String mPackageName;
    protected JPanel mImagePanel = new TransparentPanel();
    protected OutlookPanel mImageOutlookPanel = new OutlookPanel();
    protected JPanel mPropertyPanel = new TransparentPanel();
    protected OutlookPanel mPropertyOutlookPanel = new OutlookPanel();
    private ThemeValuesList mThemeValuesList;
    public Vector<ScreenshotXml> mScreenshotXmls = new Vector();
    public String mPackageTemplatePath;
    public String mPackageReplacePath;
    public String mPackageResourceCatalogPath;
    HashMap<String, OutlookTabData> mTags = new HashMap();
    private JPanel mLastImagePanel;
    private OutlookPanelModel.OutlookSelectionLisener mScreenshotXmlSelectListener = new OutlookPanelModel.OutlookSelectionLisener(){

        @Override
        public void valueChanged(OutlookSelectionEvent outlookSelectionEvent) {
            ScreenshotXml screenshotXml = (ScreenshotXml)ResourceEditorModulePanel.this.mImageOutlookPanel.getModel().get((int)outlookSelectionEvent.mTabIndex).mList.get(outlookSelectionEvent.mListIndex);
            CenterReplacePanel centerReplacePanel = new CenterReplacePanel(screenshotXml, ResourceEditorModulePanel.this);
            ResourceEditorModulePanel.this.mLastImagePanel = centerReplacePanel;
            ResourceEditorModulePanel.this.setRightPanel(centerReplacePanel);
        }
    };
    private JPanel mLastPropertyPanel;
    private CenterThemeValuesPanel mCenterThemeValuesPanel;
    private OutlookPanelModel.OutlookSelectionLisener mThemeValuesSelectListener = new OutlookPanelModel.OutlookSelectionLisener(){

        @Override
        public void valueChanged(OutlookSelectionEvent outlookSelectionEvent) {
            String string = sPropertyPackage[outlookSelectionEvent.mTabIndex];
            I18nObject i18nObject = (I18nObject)ResourceEditorModulePanel.this.mPropertyOutlookPanel.getModel().get((int)outlookSelectionEvent.mTabIndex).mList.get(outlookSelectionEvent.mListIndex);
            ResourceEditorModulePanel.this.mThemeValuesList.setFilter(i18nObject.mKey, string);
            ResourceEditorModulePanel.this.mCenterThemeValuesPanel.refreshUI();
            ResourceEditorModulePanel.this.mLastPropertyPanel = ResourceEditorModulePanel.this.mCenterThemeValuesPanel;
            ResourceEditorModulePanel.this.setRightPanel(ResourceEditorModulePanel.this.mCenterThemeValuesPanel);
        }
    };
    private ChangeListener mChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (ResourceEditorModulePanel.this.mLeftPanel.getSelectedIndex() == 0 && ResourceEditorModulePanel.this.mLastImagePanel != null) {
                ResourceEditorModulePanel.this.setRightPanel(ResourceEditorModulePanel.this.mLastImagePanel);
            } else if (ResourceEditorModulePanel.this.mLastPropertyPanel != null) {
                ResourceEditorModulePanel.this.setRightPanel(ResourceEditorModulePanel.this.mLastPropertyPanel);
            } else if (ResourceEditorModulePanel.this.mLeftPanel.getSelectedIndex() == 0) {
                ResourceEditorModulePanel.this.mImageOutlookPanel.defaultOpen();
            } else if (ResourceEditorModulePanel.this.mLeftPanel.getSelectedIndex() == 1) {
                ResourceEditorModulePanel.this.mPropertyOutlookPanel.defaultOpen();
            }
        }
    };
    public static final String[] sPropertyPackageNames = new String[]{"ModuleProperty", "MIUIProperty", "AndroidProperty"};
    public static final String[] sPropertyPackage = new String[]{"", "miui", "android"};
    public static final String[] sPropertyTypes = new String[]{"color", "string", "bool", "dimen", "integer"};

    public ResourceEditorModulePanel(String string) {
        this.mPackageName = string;
        this.checkAndImport();
    }

    private void checkAndImport() {
        boolean bl = false;
        try {
            bl = CatalogManager.checkAndImportCatalog(this.mPackageName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            GUIUtil.toast(ResourceFactory.getString("ImportFail"));
            this.initFailPage();
            return;
        }
        new Thread(){

            @Override
            public void run() {
                ResourceEditorModulePanel.this.init();
            }
        }.start();
    }

    private void initFailPage() {
        this.removeAll();
        double[][] dArrayArray = new double[][]{{-1.0, 232.0, -1.0}, {-1.0, 163.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        ResourceImportNotice resourceImportNotice = new ResourceImportNotice();
        resourceImportNotice.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ResourceEditorModulePanel.this.checkAndImport();
            }
        });
        this.add((Component)resourceImportNotice, "1, 1");
        this.revalidate();
        this.repaint();
    }

    public void init() {
        this.initLayout();
        this.initImagePanel();
        this.initPropertyPanel();
        this.initLeftPanel();
        this.add((Component)this.mLeftPanel, "0, 0");
        String string = NewMainFrame.getInstance().getMainPanel().getAndClearLaunchResourceType();
        if (string != null) {
            this.mLeftPanel.setSelectedIndex(1);
            this.mPropertyOutlookPanel.defaultOpen(sPropertyPackageNames[0], string);
        }
        this.revalidate();
        this.repaint();
    }

    private void initImagePanel() {
        this.mImagePanel.setBackground(this.mLeftBackground);
        this.mPackageTemplatePath = ThemeHelper.getTemplatePath() + File.separator + this.mPackageName;
        this.mPackageReplacePath = ConfigUtil.getThemePath() + File.separator + this.mPackageName;
        this.mPackageResourceCatalogPath = ThemeHelper.getResourceCatalogPath() + File.separator + this.mPackageName;
        this.loadImageResources();
        for (ScreenshotXml screenshotXml : this.mScreenshotXmls) {
            if (!this.mTags.containsKey(screenshotXml.mTag)) {
                OutlookTabData outlookTabData = new OutlookTabData();
                this.mTags.put(screenshotXml.mTag, outlookTabData);
                outlookTabData.mTitle = new I18nObject(screenshotXml.mTag);
                this.mImageOutlookPanel.getModel().add(outlookTabData);
            }
            this.mTags.get((Object)screenshotXml.mTag).mList.add(screenshotXml);
        }
        this.mImageOutlookPanel.addSelectionListener(this.mScreenshotXmlSelectListener);
        this.layoutOutlookPanel(this.mImagePanel, this.mImageOutlookPanel);
    }

    private void initPropertyPanel() {
        this.mPropertyPanel.setBackground(this.mLeftBackground);
        this.mThemeValuesList = new ThemeValuesList(this.mPackageName);
        this.mCenterThemeValuesPanel = new CenterThemeValuesPanel(this.mThemeValuesList);
        if (this.mPackageName.equals("framework-miui-res") || this.mPackageName.equals("framework-res")) {
            String string = sPropertyPackageNames[0];
            OutlookTabData outlookTabData = new OutlookTabData();
            outlookTabData.mTitle = new I18nObject(string);
            for (String string2 : sPropertyTypes) {
                outlookTabData.mList.add(new I18nObject(string2));
            }
            this.mPropertyOutlookPanel.getModel().add(outlookTabData);
        } else {
            for (String string : sPropertyPackageNames) {
                OutlookTabData outlookTabData = new OutlookTabData();
                outlookTabData.mTitle = new I18nObject(string);
                for (String string3 : sPropertyTypes) {
                    outlookTabData.mList.add(new I18nObject(string3));
                }
                this.mPropertyOutlookPanel.getModel().add(outlookTabData);
            }
        }
        this.mPropertyOutlookPanel.addSelectionListener(this.mThemeValuesSelectListener);
        this.layoutOutlookPanel(this.mPropertyPanel, this.mPropertyOutlookPanel);
    }

    private void initLeftPanel() {
        this.mLeftPanel = new ModuleTabbedPane();
        this.mLeftPanel.addChangeListener(this.mChangeListener);
        this.mLeftPanel.addTab(ResourceFactory.getString(""), this.mImagePanel);
        this.mLeftPanel.addTab(ResourceFactory.getString(""), this.mPropertyPanel);
    }

    private void loadImageResources() {
        this.mScreenshotXmls.clear();
        File file = new File(this.mPackageTemplatePath);
        if (file.exists()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(ScreenshotXml.SCREENSHOT_SUFFIX) || file.getName().toLowerCase().endsWith(".png");
                }
            });
            long l = System.currentTimeMillis();
            for (File file2 : fileArray) {
                if (!file2.isFile()) continue;
                String string = file2.getName();
                String string2 = ResourceEditorModulePanel.mapSuffixtoXML(string);
                File file3 = new File(this.mPackageTemplatePath + File.separator + string2);
                ScreenshotXml screenshotXml = new ScreenshotXml(file2, file3);
                this.mScreenshotXmls.add(screenshotXml);
                if (!file3.exists()) continue;
                screenshotXml.parse();
            }
            Collections.sort(this.mScreenshotXmls);
            new Thread(){

                @Override
                public void run() {
                    for (ScreenshotXml screenshotXml : ResourceEditorModulePanel.this.mScreenshotXmls) {
                        screenshotXml.matchResource(ResourceEditorModulePanel.this.mPackageResourceCatalogPath);
                    }
                }
            }.start();
        }
    }

    static String mapSuffixtoXML(String string) {
        return string.substring(0, string.length() - 3) + "xml";
    }
}

