/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.ResourceReplacePanel;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.ModuleRightPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.ImageReplacePanel;
import com.miui.theme.tool.resourceeditor.ModuleResourceReplacePanel;
import com.miui.theme.tool.resourceeditor.Notifier;
import com.miui.theme.tool.resourceeditor.Resource;
import com.miui.theme.tool.resourceeditor.ResourceEditorModulePanel;
import com.miui.theme.tool.resourceeditor.ResourceReplaceTabbedPane;
import com.miui.theme.tool.resourceeditor.ScreenshotXml;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class CenterReplacePanel
extends ModuleRightPanel
implements Observer {
    private ScreenshotXml mScreenshotXml;
    private ImageReplacePanel mImageReplacePanel;
    private Notifier mNotifier;
    private Vector<Resource> mSelectedResources;
    private JPanel mRightPanel = new CommonRightPanel();
    private ResourceEditorModulePanel mResourceEditorModulePanel;
    private boolean mDisableRemember = false;
    HashMap<String, JPanel> mFolderPanelMap;
    private JTabbedPane mRightTabbedPane;
    private String mRightLastTitle;
    private int mRightLastValue;
    ResourceReplacePanel.ReplaceActionListener ral = new ResourceReplacePanel.ReplaceActionListener(){

        @Override
        public void onWait() {
        }

        @Override
        public void onRefresh() {
            if (CenterReplacePanel.this.mRightTabbedPane != null && !CenterReplacePanel.this.mDisableRemember) {
                CenterReplacePanel.this.mRightLastTitle = CenterReplacePanel.this.mRightTabbedPane.getTitleAt(CenterReplacePanel.this.mRightTabbedPane.getSelectedIndex());
                JScrollPane jScrollPane = (JScrollPane)CenterReplacePanel.this.mRightTabbedPane.getComponentAt(CenterReplacePanel.this.mRightTabbedPane.getSelectedIndex());
                CenterReplacePanel.this.mRightLastValue = jScrollPane.getVerticalScrollBar().getValue();
            }
            CenterReplacePanel.this.refreshRight();
        }
    };

    public CenterReplacePanel(ScreenshotXml screenshotXml, ResourceEditorModulePanel resourceEditorModulePanel) {
        this.mScreenshotXml = screenshotXml;
        this.mResourceEditorModulePanel = resourceEditorModulePanel;
        this.initNotifier();
        this.initLayout();
        this.initImagePanel();
        this.add((Component)this.mRightPanel, "2, 0");
        this.initRightPanelWithAnnotation();
    }

    private void initLayout() {
        double[][] dArrayArray = new double[][]{{470.0, 1.0, -1.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.getSepPanel(), "1, 0");
    }

    public void initNotifier() {
        this.mNotifier = new Notifier();
        this.mNotifier.addObserver(this);
    }

    private void initImagePanel() {
        this.mImageReplacePanel = new ImageReplacePanel(GUIUtil.getImage(this.mScreenshotXml.mFile));
        this.mImageReplacePanel.bindResources(this.mScreenshotXml.mResources);
        this.mImageReplacePanel.bindNotifier(this.mNotifier);
        TransparentPanel transparentPanel = new TransparentPanel();
        double[][] dArrayArray = new double[][]{{-1.0, 400.0, -1.0}, {-1.0, 700.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        transparentPanel.setLayout(tableLayout);
        transparentPanel.add((Component)this.mImageReplacePanel, "1, 1");
        this.add((Component)transparentPanel, "0, 0");
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Vector) {
            this.mSelectedResources = (Vector)object;
        }
        this.mDisableRemember = true;
        this.refreshRight();
    }

    private void refreshRight() {
        if (this.mSelectedResources == null) {
            return;
        }
        if (this.mSelectedResources.size() > 0) {
            Resource[] resourceArray = new Resource[this.mSelectedResources.size()];
            this.mSelectedResources.toArray(resourceArray);
            this.showResourcePaths(this.mSelectedResources);
        } else {
            this.initRightPanelWithAnnotation();
        }
    }

    private void initRightPanelWithAnnotation() {
        int n = 20;
        this.mRightPanel.removeAll();
        this.mRightPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceFactory.getString("ScreenshotAnnotation"));
        JLabel jLabel2 = new JLabel("<html>" + this.mScreenshotXml.mAnnotation + "</html>");
        GridBagHelper.addComponent(this.mRightPanel, jLabel, 0, 0, 1, 1, 0, 0, n, n, 1.0, 0.0, 0, 17);
        GridBagHelper.addComponent(this.mRightPanel, jLabel2, 0, 1, 1, 1, 0, 0, n, n, 1.0, 0.0, 0, 17);
        JLabel jLabel3 = new JLabel();
        GridBagHelper.addComponent(this.mRightPanel, jLabel3, 0, 2, 1, 1, 0, 0, 0, 0, 1.0, 1.0, 0, 11);
        this.mRightPanel.validate();
        this.mRightPanel.repaint();
    }

    public JPanel getFolderPanel(String string) {
        String string2 = ThemeHelper.removeLastName(string);
        if (!this.mFolderPanelMap.containsKey(string2)) {
            CommonRightPanel commonRightPanel = new CommonRightPanel();
            this.mFolderPanelMap.put(string2, commonRightPanel);
            double[][] dArrayArray = new double[][]{{-1.0}, new double[0]};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            commonRightPanel.setLayout(tableLayout);
        }
        return this.mFolderPanelMap.get(string2);
    }

    private void showResourcePaths(Vector<Resource> vector) {
        this.mFolderPanelMap = new HashMap();
        for (int i = 0; i < vector.size(); ++i) {
            Resource resource = vector.get(i);
            Vector<String> vector2 = resource.mPaths;
            Vector<String> vector3 = resource.mPathDescriptions;
            for (int j = 0; j < vector2.size(); ++j) {
                Object object;
                JPanel jPanel = this.getFolderPanel(vector2.get(j));
                String string = this.mResourceEditorModulePanel.mPackageResourceCatalogPath + File.separator + vector2.get(j);
                String string2 = this.mResourceEditorModulePanel.mPackageReplacePath + File.separator + vector2.get(j);
                File file = new File(string);
                File file2 = new File(string2);
                String string3 = resource.mWidth + "x" + resource.mHeight;
                if (file.exists()) {
                    object = GUIUtil.getImage(file);
                    string3 = ((BufferedImage)object).getWidth() + "x" + ((BufferedImage)object).getHeight();
                }
                if (!vector3.get(j).isEmpty()) {
                    string3 = vector3.get(j) + "," + string3;
                }
                object = new ModuleResourceReplacePanel(file.getName(), string3, file, file2, this.ral);
                TableLayout tableLayout = (TableLayout)jPanel.getLayout();
                int n = tableLayout.getNumRow();
                tableLayout.insertRow(n, -2.0);
                jPanel.add((Component)object, "0," + n);
            }
        }
        this.initRightPanel();
    }

    private void initRightPanel() {
        this.mRightPanel.removeAll();
        int n = 13;
        double[][] dArrayArray = new double[][]{{n, -1.0, n}, {n, -1.0, n}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mRightPanel.setLayout(tableLayout);
        this.mRightTabbedPane = new ResourceReplaceTabbedPane();
        NewMainFrame.getInstance().bindMoveWindowListener(this.mRightTabbedPane);
        for (String object : this.mFolderPanelMap.keySet()) {
            JPanel jPanel = this.mFolderPanelMap.get(object);
            String string = ResourceFactory.getString(ThemeHelper.getLastName(object));
            if (object.contains(".maml.unzip")) {
                string = ResourceFactory.getString("MAML");
            }
            if (string.isEmpty()) continue;
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.mRightTabbedPane.addTab(string, jScrollPane);
        }
        this.mRightPanel.add((Component)this.mRightTabbedPane, "1, 1");
        if (this.mRightLastTitle != null && !this.mDisableRemember) {
            for (int i = 0; i < this.mRightTabbedPane.getTabCount(); ++i) {
                if (!this.mRightTabbedPane.getTitleAt(i).equals(this.mRightLastTitle)) continue;
                this.mRightTabbedPane.setSelectedIndex(i);
                final JScrollBar jScrollBar = ((JScrollPane)this.mRightTabbedPane.getComponentAt(i)).getVerticalScrollBar();
                new Thread(){

                    @Override
                    public void run() {
                        while (jScrollBar.getMaximum() == 100) {
                        }
                        jScrollBar.setValue(CenterReplacePanel.this.mRightLastValue);
                    }
                }.start();
                break;
            }
        }
        this.mDisableRemember = false;
        this.mRightPanel.revalidate();
        this.mRightPanel.repaint();
        this.mRightPanel.updateUI();
    }
}

