/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.phone.uiautomator;

import com.miui.theme.tool.phone.tree.BasicTreeNode;
import com.miui.theme.tool.phone.tree.OnlyTextHierarchXmlLoader;
import com.miui.theme.tool.phone.tree.UiHierarchyXmlLoader;
import com.miui.theme.tool.phone.tree.UiNode;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UiAutomatorModel {
    private BasicTreeNode mRootNode;
    private BasicTreeNode mSelectedNode;
    private Rectangle mCurrentDrawingRect;
    private List<Rectangle> mNafNodes;
    private boolean mExploreMode = true;
    private boolean mShowNafNodes = false;
    private boolean mOnlyParseText = false;
    private String mPackageName;

    public UiAutomatorModel(File file, boolean bl) {
        UiHierarchyXmlLoader uiHierarchyXmlLoader = new UiHierarchyXmlLoader();
        uiHierarchyXmlLoader = bl ? new OnlyTextHierarchXmlLoader() : new UiHierarchyXmlLoader();
        this.mOnlyParseText = bl;
        BasicTreeNode basicTreeNode = uiHierarchyXmlLoader.parseXml(file.getAbsolutePath());
        this.mPackageName = uiHierarchyXmlLoader.getPackageName();
        if (basicTreeNode == null) {
            System.err.println("null rootnode after parsing.");
            throw new IllegalArgumentException("Invalid ui automator hierarchy file.");
        }
        this.mNafNodes = uiHierarchyXmlLoader.getNafNodes();
        if (this.mRootNode != null) {
            this.mRootNode.clearAllChildren();
        }
        this.mRootNode = basicTreeNode;
        this.mExploreMode = true;
    }

    public BasicTreeNode getXmlRootNode() {
        return this.mRootNode;
    }

    public BasicTreeNode getSelectedNode() {
        return this.mSelectedNode;
    }

    public void setSelectedNode(BasicTreeNode basicTreeNode) {
        this.mSelectedNode = basicTreeNode;
        if (this.mSelectedNode instanceof UiNode) {
            UiNode uiNode = (UiNode)this.mSelectedNode;
            this.mCurrentDrawingRect = new Rectangle(uiNode.x, uiNode.y, uiNode.width, uiNode.height);
        } else {
            this.mCurrentDrawingRect = null;
        }
    }

    public Rectangle getCurrentDrawingRect() {
        return this.mCurrentDrawingRect;
    }

    public BasicTreeNode updateSelectionForCoordinates(int n, int n2) {
        MinAreaFindNodeListener minAreaFindNodeListener;
        boolean bl;
        BasicTreeNode basicTreeNode = null;
        if (this.mRootNode != null && (bl = this.mRootNode.findLeafMostNodesAtPoint(n, n2, minAreaFindNodeListener = new MinAreaFindNodeListener())) && minAreaFindNodeListener.mNode != null && !minAreaFindNodeListener.mNode.equals(this.mSelectedNode) && (!this.mOnlyParseText || OnlyTextHierarchXmlLoader.isTextNode(minAreaFindNodeListener.mNode))) {
            basicTreeNode = minAreaFindNodeListener.mNode;
        }
        return basicTreeNode;
    }

    public boolean isExploreMode() {
        return this.mExploreMode;
    }

    public void toggleExploreMode() {
        this.mExploreMode = !this.mExploreMode;
    }

    public void setExploreMode(boolean bl) {
        this.mExploreMode = bl;
    }

    public List<Rectangle> getNafNodes() {
        return this.mNafNodes;
    }

    public void toggleShowNaf() {
        this.mShowNafNodes = !this.mShowNafNodes;
    }

    public boolean shouldShowNafNodes() {
        return this.mShowNafNodes;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<String> getNodesTextList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getNodeTextListImpl(this.mRootNode, arrayList);
        System.out.println(UiAutomatorModel.class.getSimpleName() + " get text-node list: " + this.mPackageName + " " + arrayList.size());
        return arrayList;
    }

    private void getNodeTextListImpl(BasicTreeNode basicTreeNode, List<String> list) {
        Object object;
        String object22;
        if (basicTreeNode == null) {
            return;
        }
        if (basicTreeNode instanceof UiNode && (object22 = ((UiNode)(object = (UiNode)basicTreeNode)).getTextContent("").trim()).length() >= 0) {
            list.add(object22);
        }
        for (BasicTreeNode basicTreeNode2 : basicTreeNode.getChildrenList()) {
            this.getNodeTextListImpl(basicTreeNode2, list);
        }
    }

    public UiNode findMatchedNodeByText(String string) {
        return this.findMatchedNodeByTextImpl(this.mRootNode, string);
    }

    private UiNode findMatchedNodeByTextImpl(BasicTreeNode basicTreeNode, String string) {
        Object object;
        if (basicTreeNode == null) {
            return null;
        }
        if (basicTreeNode instanceof UiNode && ((UiNode)(object = (UiNode)basicTreeNode)).getTextContent("").equals(string)) {
            return object;
        }
        for (BasicTreeNode basicTreeNode2 : basicTreeNode.getChildrenList()) {
            UiNode uiNode = this.findMatchedNodeByTextImpl(basicTreeNode2, string);
            if (uiNode == null) continue;
            return uiNode;
        }
        return null;
    }

    private static class MinAreaFindNodeListener
    implements BasicTreeNode.IFindNodeListener {
        BasicTreeNode mNode = null;

        private MinAreaFindNodeListener() {
        }

        @Override
        public void onFoundNode(BasicTreeNode basicTreeNode) {
            if (this.mNode == null) {
                this.mNode = basicTreeNode;
            } else if (basicTreeNode.height * basicTreeNode.width < this.mNode.height * this.mNode.width) {
                this.mNode = basicTreeNode;
            }
        }
    }
}

