/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.phone.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicTreeNode {
    private static final BasicTreeNode[] CHILDREN_TEMPLATE = new BasicTreeNode[0];
    protected BasicTreeNode mParent;
    protected final List<BasicTreeNode> mChildren = new ArrayList<BasicTreeNode>();
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean mHasBounds = false;

    public void addChild(BasicTreeNode basicTreeNode) {
        if (basicTreeNode == null) {
            throw new NullPointerException("Cannot add null child");
        }
        if (this.mChildren.contains(basicTreeNode)) {
            throw new IllegalArgumentException("node already a child");
        }
        this.mChildren.add(basicTreeNode);
        basicTreeNode.mParent = this;
    }

    public List<BasicTreeNode> getChildrenList() {
        return Collections.unmodifiableList(this.mChildren);
    }

    public BasicTreeNode[] getChildren() {
        return this.mChildren.toArray(CHILDREN_TEMPLATE);
    }

    public BasicTreeNode getParent() {
        return this.mParent;
    }

    public boolean hasChild() {
        return this.mChildren.size() != 0;
    }

    public int getChildCount() {
        return this.mChildren.size();
    }

    public void clearAllChildren() {
        for (BasicTreeNode basicTreeNode : this.mChildren) {
            basicTreeNode.clearAllChildren();
        }
        this.mChildren.clear();
    }

    public boolean findLeafMostNodesAtPoint(int n, int n2, IFindNodeListener iFindNodeListener) {
        boolean bl = false;
        for (BasicTreeNode basicTreeNode : this.mChildren) {
            bl |= basicTreeNode.findLeafMostNodesAtPoint(n, n2, iFindNodeListener);
        }
        if (bl) {
            return true;
        }
        if (this.mHasBounds) {
            if (this.x <= n && n <= this.x + this.width && this.y <= n2 && n2 <= this.y + this.height) {
                iFindNodeListener.onFoundNode(this);
                return true;
            }
            return false;
        }
        return false;
    }

    public Object[] getAttributesArray() {
        return null;
    }

    public static interface IFindNodeListener {
        public void onFoundNode(BasicTreeNode var1);
    }
}

