/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.os;

import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.util.Hex;
import java.io.File;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class OS {
    public static final int WINDOWS = 1;
    public static final int LINUX = 2;
    public static final int MAC_OS = 3;
    public static final int OTHER_OS = 4;
    public static String sMac = OS.getMac();

    public static int getOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows") != -1) {
            return 1;
        }
        if (string.indexOf("linux") != -1) {
            return 2;
        }
        if (string.indexOf("mac") != -1) {
            return 3;
        }
        return 4;
    }

    public static void rmFile(String string) {
        if (!new File(string).exists()) {
            return;
        }
        CmdUtils.deleteFile(string);
    }

    public static void rmDir(String string) {
        CmdUtils.deleteDir(string);
    }

    public static String getMac() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                byte[] byArray = enumeration.nextElement().getHardwareAddress();
                if (byArray == null || byArray.length == 0) continue;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Hex.bytesToHexString(byArray));
                return stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

