/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class NinePatchDecoder {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int NP_COLOR = -16777216;

    public static boolean decode(String string, boolean bl) throws Exception {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = IOUtils.toByteArray((InputStream)fileInputStream);
            fileInputStream.close();
            if (!(byArray[37] == 110 && byArray[38] == 112 && byArray[39] == 84 && byArray[40] == 99 || byArray[37] == 110 && byArray[38] == 112 && byArray[39] == 79 && byArray[40] == 108)) {
                return false;
            }
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n + 2, n2 + 2, 6);
            if (bufferedImage.getType() == 6) {
                bufferedImage2.getRaster().setRect(1, 1, bufferedImage.getRaster());
            } else {
                bufferedImage2.getGraphics().drawImage(bufferedImage, 1, 1, null);
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            NinePatch ninePatch = NinePatchDecoder.getNinePatch(dataInputStream);
            if (ninePatch.xDivs.length <= 0 || ninePatch.yDivs.length <= 0) {
                return false;
            }
            if (!bl) {
                return true;
            }
            NinePatchDecoder.drawHLine(bufferedImage2, n2 + 1, ninePatch.padLeft + 1, n - ninePatch.padRight);
            NinePatchDecoder.drawVLine(bufferedImage2, n + 1, ninePatch.padTop + 1, n2 - ninePatch.padBottom);
            int[] nArray = ninePatch.xDivs;
            for (int i = 0; i < nArray.length; i += 2) {
                NinePatchDecoder.drawHLine(bufferedImage2, 0, nArray[i] + 1, nArray[i + 1]);
            }
            int[] nArray2 = ninePatch.yDivs;
            for (int i = 0; i < nArray2.length; i += 2) {
                NinePatchDecoder.drawVLine(bufferedImage2, 0, nArray2[i] + 1, nArray2[i + 1]);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ImageIO.write((RenderedImage)bufferedImage2, "png", fileOutputStream);
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
    }

    private static NinePatch getNinePatch(DataInputStream dataInputStream) throws Exception {
        NinePatchDecoder.find9patchChunk(dataInputStream);
        return NinePatch.decode(dataInputStream);
    }

    private static void find9patchChunk(DataInputStream dataInputStream) throws Exception {
        dataInputStream.skipBytes(8);
        while (true) {
            int n = 0;
            try {
                n = dataInputStream.readInt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (dataInputStream.readInt() == 1852855395) {
                return;
            }
            dataInputStream.skipBytes(n + 4);
        }
    }

    private static void drawHLine(BufferedImage bufferedImage, int n, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            bufferedImage.setRGB(i, n, -16777216);
        }
    }

    private static void drawVLine(BufferedImage bufferedImage, int n, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            bufferedImage.setRGB(n, i, -16777216);
        }
    }

    private static class NinePatch {
        public final int padLeft;
        public final int padRight;
        public final int padTop;
        public final int padBottom;
        public final int[] xDivs;
        public final int[] yDivs;

        public NinePatch(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
            this.padLeft = n;
            this.padRight = n2;
            this.padTop = n3;
            this.padBottom = n4;
            this.xDivs = nArray;
            this.yDivs = nArray2;
        }

        public static NinePatch decode(DataInputStream dataInputStream) throws IOException {
            dataInputStream.skipBytes(1);
            int n = dataInputStream.readByte();
            int n2 = dataInputStream.readByte();
            dataInputStream.skipBytes(1);
            dataInputStream.skipBytes(8);
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            int n6 = dataInputStream.readInt();
            dataInputStream.skipBytes(4);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = dataInputStream.readInt();
            }
            return new NinePatch(n3, n4, n5, n6, nArray, nArray2);
        }
    }
}

