/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import miui.imagefilters.TFilter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class TransformFilter {
    public static final String TF_ICON_TRANSFORM = "IconTransform";
    public static final String TF_NAME = "name";
    public static final String TF_VALUE = "value";
    public static final String TF_CONFIG = "Config";
    public static final String TF_CONFIG_NAME_USEMODICON = "UseModIcon";
    public static final String TF_POINTS_MAPPING = "PointsMapping";
    public static final String TF_ICON_FILTERS = "IconFilters";
    public static final String TF_POINT = "Point";
    public static final String TF_POINT_FROMX = "fromX";
    public static final String TF_POINT_FROMY = "fromY";
    public static final String TF_POINT_TOX = "toX";
    public static final String TF_POINT_TOY = "toY";
    public static final String TF_FILTER = "Filter";
    public static final String TF_FILTER_NAME = "name";
    public static final String TF_FILTER_PARAM = "Param";
    public static final String FILTER_HSL = "Hsl";
    public static final String FILTER_HSL_HUEMODIFY = "HueModify";
    public static final String FILTER_HSL_HUEADJUST = "HueAdjust";
    public static final String FILTER_HSL_SATURATIONMODIFY = "SaturationModify";
    public static final String FILTER_HSL_SATURATIONADJUST = "SaturationAdjust";
    public static final String FILTER_HSL_LIGHTNESSMODIFY = "LightnessModify";
    public static final String FILTER_HSL_LIGHTNESSADJUST = "LightnessAdjust";
    public static final String FILTER_EDGES = "Edges";
    public static final String FILTER_LEVELS = "Levels";
    public static final String FILTER_LEVELS_INPUTMIN = "InputMin";
    public static final String FILTER_LEVELS_INPUTMIDDLE = "InputMiddle";
    public static final String FILTER_LEVELS_INPUTMAX = "InputMax";
    public static final String FILTER_LEVELS_OUTPUTMIN = "OutputMin";
    public static final String FILTER_LEVELS_OUTPUTMAX = "OutputMax";
    public static final String FILTER_GRAYSCALE = "GrayScale";
    public static final String FILTER_GRAYSCALE_BLACKCOLOR = "BlackColor";
    public static final String FILTER_GRAYSCALE_WHITECOLOR = "WhiteColor";
    public static final String FILTER_BLENDIMAGE = "BlendImage";
    public boolean mUseModIcon = true;
    private File mFilterFile;
    public List<Float> mPointsMappingFrom = new ArrayList<Float>();
    public List<Float> mPointsMappingTo = new ArrayList<Float>();
    public List<TFilter> mFilters = new ArrayList<TFilter>();

    public TransformFilter(File file) {
        this.mFilterFile = file;
    }

    public void save() {
        Element iOException;
        Element element2;
        Element element3 = new Element(TF_ICON_TRANSFORM);
        if (!this.mUseModIcon) {
            element2 = new Element(TF_CONFIG);
            element2.setAttribute("name", TF_CONFIG_NAME_USEMODICON);
            element2.setAttribute(TF_VALUE, Boolean.FALSE.toString());
            element3.addContent((Content)element2);
        }
        if (this.mPointsMappingFrom.size() > 0) {
            element2 = new Element(TF_POINTS_MAPPING);
            for (int i = 0; i < this.mPointsMappingFrom.size() / 2; ++i) {
                Element object2 = new Element(TF_POINT);
                object2.setAttribute(TF_POINT_FROMX, "" + this.mPointsMappingFrom.get(2 * i));
                object2.setAttribute(TF_POINT_FROMY, "" + this.mPointsMappingFrom.get(2 * i + 1));
                object2.setAttribute(TF_POINT_TOX, "" + this.mPointsMappingTo.get(2 * i));
                object2.setAttribute(TF_POINT_TOY, "" + this.mPointsMappingTo.get(2 * i + 1));
                element2.addContent((Content)object2);
            }
            element3.addContent((Content)element2);
        }
        element2 = new Element(TF_ICON_FILTERS);
        if (this.mFilters.size() > 0) {
            for (TFilter tFilter : this.mFilters) {
                iOException = new Element(TF_FILTER);
                iOException.setAttribute("name", tFilter.mName);
                if (tFilter.mParamEntrys != null) {
                    for (Map.Entry entry : tFilter.mParamEntrys) {
                        Element element = new Element(TF_FILTER_PARAM);
                        element.setAttribute("name", (String)entry.getKey());
                        element.setAttribute(TF_VALUE, (String)entry.getValue());
                        iOException.addContent((Content)element);
                    }
                }
                element2.addContent((Content)iOException);
            }
            element3.addContent((Content)element2);
        }
        XMLOutputter xMLOutputter = new XMLOutputter();
        try {
            if (!this.mFilterFile.getParentFile().exists()) {
                this.mFilterFile.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.mFilterFile);
            iOException = Format.getPrettyFormat();
            iOException.setEncoding("UTF-8");
            iOException.setIndent("    ");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            xMLOutputter.setFormat((Format)iOException);
            xMLOutputter.output(new Document(element3), (Writer)outputStreamWriter);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException2) {
            iOException2.printStackTrace();
        }
    }
}

